package io.resys.thena.docdb.api.actions;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.thena.docdb.api.models.Objects;
import io.resys.thena.docdb.api.models.Repo;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ObjectsActions.BlobObject}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBlobObject.builder()}.
 */
@Generated(from = "ObjectsActions.BlobObject", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableBlobObject implements ObjectsActions.BlobObject {
  private final Repo repo;
  private final Objects.Commit commit;
  private final Objects.Tree tree;
  private final Objects.Blob blob;

  private ImmutableBlobObject(
      Repo repo,
      Objects.Commit commit,
      Objects.Tree tree,
      Objects.Blob blob) {
    this.repo = repo;
    this.commit = commit;
    this.tree = tree;
    this.blob = blob;
  }

  /**
   * @return The value of the {@code repo} attribute
   */
  @Override
  public Repo getRepo() {
    return repo;
  }

  /**
   * @return The value of the {@code commit} attribute
   */
  @Override
  public Objects.Commit getCommit() {
    return commit;
  }

  /**
   * @return The value of the {@code tree} attribute
   */
  @Override
  public Objects.Tree getTree() {
    return tree;
  }

  /**
   * @return The value of the {@code blob} attribute
   */
  @Override
  public Objects.Blob getBlob() {
    return blob;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ObjectsActions.BlobObject#getRepo() repo} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repo
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlobObject withRepo(Repo value) {
    if (this.repo == value) return this;
    Repo newValue = java.util.Objects.requireNonNull(value, "repo");
    return new ImmutableBlobObject(newValue, this.commit, this.tree, this.blob);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ObjectsActions.BlobObject#getCommit() commit} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commit
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlobObject withCommit(Objects.Commit value) {
    if (this.commit == value) return this;
    Objects.Commit newValue = java.util.Objects.requireNonNull(value, "commit");
    return new ImmutableBlobObject(this.repo, newValue, this.tree, this.blob);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ObjectsActions.BlobObject#getTree() tree} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tree
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlobObject withTree(Objects.Tree value) {
    if (this.tree == value) return this;
    Objects.Tree newValue = java.util.Objects.requireNonNull(value, "tree");
    return new ImmutableBlobObject(this.repo, this.commit, newValue, this.blob);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ObjectsActions.BlobObject#getBlob() blob} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blob
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBlobObject withBlob(Objects.Blob value) {
    if (this.blob == value) return this;
    Objects.Blob newValue = java.util.Objects.requireNonNull(value, "blob");
    return new ImmutableBlobObject(this.repo, this.commit, this.tree, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBlobObject} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBlobObject
        && equalTo((ImmutableBlobObject) another);
  }

  private boolean equalTo(ImmutableBlobObject another) {
    return repo.equals(another.repo)
        && commit.equals(another.commit)
        && tree.equals(another.tree)
        && blob.equals(another.blob);
  }

  /**
   * Computes a hash code from attributes: {@code repo}, {@code commit}, {@code tree}, {@code blob}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + repo.hashCode();
    h += (h << 5) + commit.hashCode();
    h += (h << 5) + tree.hashCode();
    h += (h << 5) + blob.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code BlobObject} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("BlobObject")
        .omitNullValues()
        .add("repo", repo)
        .add("commit", commit)
        .add("tree", tree)
        .add("blob", blob)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ObjectsActions.BlobObject} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BlobObject instance
   */
  public static ImmutableBlobObject copyOf(ObjectsActions.BlobObject instance) {
    if (instance instanceof ImmutableBlobObject) {
      return (ImmutableBlobObject) instance;
    }
    return ImmutableBlobObject.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBlobObject ImmutableBlobObject}.
   * <pre>
   * ImmutableBlobObject.builder()
   *    .repo(io.resys.thena.docdb.api.models.Repo) // required {@link ObjectsActions.BlobObject#getRepo() repo}
   *    .commit(io.resys.thena.docdb.api.models.Objects.Commit) // required {@link ObjectsActions.BlobObject#getCommit() commit}
   *    .tree(io.resys.thena.docdb.api.models.Objects.Tree) // required {@link ObjectsActions.BlobObject#getTree() tree}
   *    .blob(io.resys.thena.docdb.api.models.Objects.Blob) // required {@link ObjectsActions.BlobObject#getBlob() blob}
   *    .build();
   * </pre>
   * @return A new ImmutableBlobObject builder
   */
  public static ImmutableBlobObject.Builder builder() {
    return new ImmutableBlobObject.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBlobObject ImmutableBlobObject}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ObjectsActions.BlobObject", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REPO = 0x1L;
    private static final long INIT_BIT_COMMIT = 0x2L;
    private static final long INIT_BIT_TREE = 0x4L;
    private static final long INIT_BIT_BLOB = 0x8L;
    private long initBits = 0xfL;

    private @Nullable Repo repo;
    private @Nullable Objects.Commit commit;
    private @Nullable Objects.Tree tree;
    private @Nullable Objects.Blob blob;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code BlobObject} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ObjectsActions.BlobObject instance) {
      java.util.Objects.requireNonNull(instance, "instance");
      repo(instance.getRepo());
      commit(instance.getCommit());
      tree(instance.getTree());
      blob(instance.getBlob());
      return this;
    }

    /**
     * Initializes the value for the {@link ObjectsActions.BlobObject#getRepo() repo} attribute.
     * @param repo The value for repo 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repo(Repo repo) {
      this.repo = java.util.Objects.requireNonNull(repo, "repo");
      initBits &= ~INIT_BIT_REPO;
      return this;
    }

    /**
     * Initializes the value for the {@link ObjectsActions.BlobObject#getCommit() commit} attribute.
     * @param commit The value for commit 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commit(Objects.Commit commit) {
      this.commit = java.util.Objects.requireNonNull(commit, "commit");
      initBits &= ~INIT_BIT_COMMIT;
      return this;
    }

    /**
     * Initializes the value for the {@link ObjectsActions.BlobObject#getTree() tree} attribute.
     * @param tree The value for tree 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tree(Objects.Tree tree) {
      this.tree = java.util.Objects.requireNonNull(tree, "tree");
      initBits &= ~INIT_BIT_TREE;
      return this;
    }

    /**
     * Initializes the value for the {@link ObjectsActions.BlobObject#getBlob() blob} attribute.
     * @param blob The value for blob 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blob(Objects.Blob blob) {
      this.blob = java.util.Objects.requireNonNull(blob, "blob");
      initBits &= ~INIT_BIT_BLOB;
      return this;
    }

    /**
     * Builds a new {@link ImmutableBlobObject ImmutableBlobObject}.
     * @return An immutable instance of BlobObject
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBlobObject build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableBlobObject(repo, commit, tree, blob);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REPO) != 0) attributes.add("repo");
      if ((initBits & INIT_BIT_COMMIT) != 0) attributes.add("commit");
      if ((initBits & INIT_BIT_TREE) != 0) attributes.add("tree");
      if ((initBits & INIT_BIT_BLOB) != 0) attributes.add("blob");
      return "Cannot build BlobObject, some of required attributes are not set " + attributes;
    }
  }
}
