package io.resys.hdes.client.spi;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.hdes.client.api.ast.AstBody;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GitConfig.GitFile}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGitFile.builder()}.
 */
@Generated(from = "GitConfig.GitFile", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGitFile implements GitConfig.GitFile {
  private final String id;
  private final String treeValue;
  private final String blobValue;
  private final String blobHash;
  private final AstBody.AstBodyType bodyType;

  private ImmutableGitFile(
      String id,
      String treeValue,
      String blobValue,
      String blobHash,
      AstBody.AstBodyType bodyType) {
    this.id = id;
    this.treeValue = treeValue;
    this.blobValue = blobValue;
    this.blobHash = blobHash;
    this.bodyType = bodyType;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code treeValue} attribute
   */
  @Override
  public String getTreeValue() {
    return treeValue;
  }

  /**
   * @return The value of the {@code blobValue} attribute
   */
  @Override
  public String getBlobValue() {
    return blobValue;
  }

  /**
   * @return The value of the {@code blobHash} attribute
   */
  @Override
  public String getBlobHash() {
    return blobHash;
  }

  /**
   * @return The value of the {@code bodyType} attribute
   */
  @Override
  public AstBody.AstBodyType getBodyType() {
    return bodyType;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitFile#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitFile withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableGitFile(newValue, this.treeValue, this.blobValue, this.blobHash, this.bodyType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitFile#getTreeValue() treeValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for treeValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitFile withTreeValue(String value) {
    String newValue = Objects.requireNonNull(value, "treeValue");
    if (this.treeValue.equals(newValue)) return this;
    return new ImmutableGitFile(this.id, newValue, this.blobValue, this.blobHash, this.bodyType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitFile#getBlobValue() blobValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blobValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitFile withBlobValue(String value) {
    String newValue = Objects.requireNonNull(value, "blobValue");
    if (this.blobValue.equals(newValue)) return this;
    return new ImmutableGitFile(this.id, this.treeValue, newValue, this.blobHash, this.bodyType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitFile#getBlobHash() blobHash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blobHash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitFile withBlobHash(String value) {
    String newValue = Objects.requireNonNull(value, "blobHash");
    if (this.blobHash.equals(newValue)) return this;
    return new ImmutableGitFile(this.id, this.treeValue, this.blobValue, newValue, this.bodyType);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitFile#getBodyType() bodyType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bodyType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitFile withBodyType(AstBody.AstBodyType value) {
    if (this.bodyType == value) return this;
    AstBody.AstBodyType newValue = Objects.requireNonNull(value, "bodyType");
    if (this.bodyType.equals(newValue)) return this;
    return new ImmutableGitFile(this.id, this.treeValue, this.blobValue, this.blobHash, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGitFile} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGitFile
        && equalTo((ImmutableGitFile) another);
  }

  private boolean equalTo(ImmutableGitFile another) {
    return id.equals(another.id)
        && treeValue.equals(another.treeValue)
        && blobValue.equals(another.blobValue)
        && blobHash.equals(another.blobHash)
        && bodyType.equals(another.bodyType);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code treeValue}, {@code blobValue}, {@code blobHash}, {@code bodyType}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + treeValue.hashCode();
    h += (h << 5) + blobValue.hashCode();
    h += (h << 5) + blobHash.hashCode();
    h += (h << 5) + bodyType.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GitFile} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GitFile")
        .omitNullValues()
        .add("id", id)
        .add("treeValue", treeValue)
        .add("blobValue", blobValue)
        .add("blobHash", blobHash)
        .add("bodyType", bodyType)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GitConfig.GitFile} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GitFile instance
   */
  public static ImmutableGitFile copyOf(GitConfig.GitFile instance) {
    if (instance instanceof ImmutableGitFile) {
      return (ImmutableGitFile) instance;
    }
    return ImmutableGitFile.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGitFile ImmutableGitFile}.
   * <pre>
   * ImmutableGitFile.builder()
   *    .id(String) // required {@link GitConfig.GitFile#getId() id}
   *    .treeValue(String) // required {@link GitConfig.GitFile#getTreeValue() treeValue}
   *    .blobValue(String) // required {@link GitConfig.GitFile#getBlobValue() blobValue}
   *    .blobHash(String) // required {@link GitConfig.GitFile#getBlobHash() blobHash}
   *    .bodyType(io.resys.hdes.client.api.ast.AstBody.AstBodyType) // required {@link GitConfig.GitFile#getBodyType() bodyType}
   *    .build();
   * </pre>
   * @return A new ImmutableGitFile builder
   */
  public static ImmutableGitFile.Builder builder() {
    return new ImmutableGitFile.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGitFile ImmutableGitFile}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GitConfig.GitFile", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_TREE_VALUE = 0x2L;
    private static final long INIT_BIT_BLOB_VALUE = 0x4L;
    private static final long INIT_BIT_BLOB_HASH = 0x8L;
    private static final long INIT_BIT_BODY_TYPE = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String id;
    private @Nullable String treeValue;
    private @Nullable String blobValue;
    private @Nullable String blobHash;
    private @Nullable AstBody.AstBodyType bodyType;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GitFile} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GitConfig.GitFile instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      treeValue(instance.getTreeValue());
      blobValue(instance.getBlobValue());
      blobHash(instance.getBlobHash());
      bodyType(instance.getBodyType());
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitFile#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitFile#getTreeValue() treeValue} attribute.
     * @param treeValue The value for treeValue 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder treeValue(String treeValue) {
      this.treeValue = Objects.requireNonNull(treeValue, "treeValue");
      initBits &= ~INIT_BIT_TREE_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitFile#getBlobValue() blobValue} attribute.
     * @param blobValue The value for blobValue 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blobValue(String blobValue) {
      this.blobValue = Objects.requireNonNull(blobValue, "blobValue");
      initBits &= ~INIT_BIT_BLOB_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitFile#getBlobHash() blobHash} attribute.
     * @param blobHash The value for blobHash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blobHash(String blobHash) {
      this.blobHash = Objects.requireNonNull(blobHash, "blobHash");
      initBits &= ~INIT_BIT_BLOB_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitFile#getBodyType() bodyType} attribute.
     * @param bodyType The value for bodyType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bodyType(AstBody.AstBodyType bodyType) {
      this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
      initBits &= ~INIT_BIT_BODY_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGitFile ImmutableGitFile}.
     * @return An immutable instance of GitFile
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGitFile build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGitFile(id, treeValue, blobValue, blobHash, bodyType);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_TREE_VALUE) != 0) attributes.add("treeValue");
      if ((initBits & INIT_BIT_BLOB_VALUE) != 0) attributes.add("blobValue");
      if ((initBits & INIT_BIT_BLOB_HASH) != 0) attributes.add("blobHash");
      if ((initBits & INIT_BIT_BODY_TYPE) != 0) attributes.add("bodyType");
      return "Cannot build GitFile, some of required attributes are not set " + attributes;
    }
  }
}
