package io.resys.hdes.client.spi;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import io.resys.hdes.client.api.ast.AstBody;
import io.resys.hdes.client.api.ast.AstCommand;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link GitConfig.GitEntry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGitEntry.builder()}.
 */
@Generated(from = "GitConfig.GitEntry", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableGitEntry implements GitConfig.GitEntry {
  private final String id;
  private final Timestamp created;
  private final Timestamp modified;
  private final AstBody.AstBodyType bodyType;
  private final String revision;
  private final String blobHash;
  private final String treeValue;
  private final String blobValue;
  private final ImmutableList<AstCommand> commands;

  private ImmutableGitEntry(
      String id,
      Timestamp created,
      Timestamp modified,
      AstBody.AstBodyType bodyType,
      String revision,
      String blobHash,
      String treeValue,
      String blobValue,
      ImmutableList<AstCommand> commands) {
    this.id = id;
    this.created = created;
    this.modified = modified;
    this.bodyType = bodyType;
    this.revision = revision;
    this.blobHash = blobHash;
    this.treeValue = treeValue;
    this.blobValue = blobValue;
    this.commands = commands;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @Override
  public Timestamp getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code modified} attribute
   */
  @Override
  public Timestamp getModified() {
    return modified;
  }

  /**
   * @return The value of the {@code bodyType} attribute
   */
  @Override
  public AstBody.AstBodyType getBodyType() {
    return bodyType;
  }

  /**
   * @return The value of the {@code revision} attribute
   */
  @Override
  public String getRevision() {
    return revision;
  }

  /**
   * @return The value of the {@code blobHash} attribute
   */
  @Override
  public String getBlobHash() {
    return blobHash;
  }

  /**
   * @return The value of the {@code treeValue} attribute
   */
  @Override
  public String getTreeValue() {
    return treeValue;
  }

  /**
   * @return The value of the {@code blobValue} attribute
   */
  @Override
  public String getBlobValue() {
    return blobValue;
  }

  /**
   * @return The value of the {@code commands} attribute
   */
  @Override
  public ImmutableList<AstCommand> getCommands() {
    return commands;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitEntry#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitEntry withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableGitEntry(
        newValue,
        this.created,
        this.modified,
        this.bodyType,
        this.revision,
        this.blobHash,
        this.treeValue,
        this.blobValue,
        this.commands);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitEntry#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitEntry withCreated(Timestamp value) {
    if (this.created == value) return this;
    Timestamp newValue = Objects.requireNonNull(value, "created");
    return new ImmutableGitEntry(
        this.id,
        newValue,
        this.modified,
        this.bodyType,
        this.revision,
        this.blobHash,
        this.treeValue,
        this.blobValue,
        this.commands);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitEntry#getModified() modified} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for modified
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitEntry withModified(Timestamp value) {
    if (this.modified == value) return this;
    Timestamp newValue = Objects.requireNonNull(value, "modified");
    return new ImmutableGitEntry(
        this.id,
        this.created,
        newValue,
        this.bodyType,
        this.revision,
        this.blobHash,
        this.treeValue,
        this.blobValue,
        this.commands);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitEntry#getBodyType() bodyType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for bodyType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitEntry withBodyType(AstBody.AstBodyType value) {
    if (this.bodyType == value) return this;
    AstBody.AstBodyType newValue = Objects.requireNonNull(value, "bodyType");
    if (this.bodyType.equals(newValue)) return this;
    return new ImmutableGitEntry(
        this.id,
        this.created,
        this.modified,
        newValue,
        this.revision,
        this.blobHash,
        this.treeValue,
        this.blobValue,
        this.commands);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitEntry#getRevision() revision} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revision
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitEntry withRevision(String value) {
    String newValue = Objects.requireNonNull(value, "revision");
    if (this.revision.equals(newValue)) return this;
    return new ImmutableGitEntry(
        this.id,
        this.created,
        this.modified,
        this.bodyType,
        newValue,
        this.blobHash,
        this.treeValue,
        this.blobValue,
        this.commands);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitEntry#getBlobHash() blobHash} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blobHash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitEntry withBlobHash(String value) {
    String newValue = Objects.requireNonNull(value, "blobHash");
    if (this.blobHash.equals(newValue)) return this;
    return new ImmutableGitEntry(
        this.id,
        this.created,
        this.modified,
        this.bodyType,
        this.revision,
        newValue,
        this.treeValue,
        this.blobValue,
        this.commands);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitEntry#getTreeValue() treeValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for treeValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitEntry withTreeValue(String value) {
    String newValue = Objects.requireNonNull(value, "treeValue");
    if (this.treeValue.equals(newValue)) return this;
    return new ImmutableGitEntry(
        this.id,
        this.created,
        this.modified,
        this.bodyType,
        this.revision,
        this.blobHash,
        newValue,
        this.blobValue,
        this.commands);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link GitConfig.GitEntry#getBlobValue() blobValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for blobValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGitEntry withBlobValue(String value) {
    String newValue = Objects.requireNonNull(value, "blobValue");
    if (this.blobValue.equals(newValue)) return this;
    return new ImmutableGitEntry(
        this.id,
        this.created,
        this.modified,
        this.bodyType,
        this.revision,
        this.blobHash,
        this.treeValue,
        newValue,
        this.commands);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GitConfig.GitEntry#getCommands() commands}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGitEntry withCommands(AstCommand... elements) {
    ImmutableList<AstCommand> newValue = ImmutableList.copyOf(elements);
    return new ImmutableGitEntry(
        this.id,
        this.created,
        this.modified,
        this.bodyType,
        this.revision,
        this.blobHash,
        this.treeValue,
        this.blobValue,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link GitConfig.GitEntry#getCommands() commands}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of commands elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGitEntry withCommands(Iterable<? extends AstCommand> elements) {
    if (this.commands == elements) return this;
    ImmutableList<AstCommand> newValue = ImmutableList.copyOf(elements);
    return new ImmutableGitEntry(
        this.id,
        this.created,
        this.modified,
        this.bodyType,
        this.revision,
        this.blobHash,
        this.treeValue,
        this.blobValue,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGitEntry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGitEntry
        && equalTo((ImmutableGitEntry) another);
  }

  private boolean equalTo(ImmutableGitEntry another) {
    return id.equals(another.id)
        && created.equals(another.created)
        && modified.equals(another.modified)
        && bodyType.equals(another.bodyType)
        && revision.equals(another.revision)
        && blobHash.equals(another.blobHash)
        && treeValue.equals(another.treeValue)
        && blobValue.equals(another.blobValue)
        && commands.equals(another.commands);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code created}, {@code modified}, {@code bodyType}, {@code revision}, {@code blobHash}, {@code treeValue}, {@code blobValue}, {@code commands}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + created.hashCode();
    h += (h << 5) + modified.hashCode();
    h += (h << 5) + bodyType.hashCode();
    h += (h << 5) + revision.hashCode();
    h += (h << 5) + blobHash.hashCode();
    h += (h << 5) + treeValue.hashCode();
    h += (h << 5) + blobValue.hashCode();
    h += (h << 5) + commands.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GitEntry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("GitEntry")
        .omitNullValues()
        .add("id", id)
        .add("created", created)
        .add("modified", modified)
        .add("bodyType", bodyType)
        .add("revision", revision)
        .add("blobHash", blobHash)
        .add("treeValue", treeValue)
        .add("blobValue", blobValue)
        .add("commands", commands)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link GitConfig.GitEntry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GitEntry instance
   */
  public static ImmutableGitEntry copyOf(GitConfig.GitEntry instance) {
    if (instance instanceof ImmutableGitEntry) {
      return (ImmutableGitEntry) instance;
    }
    return ImmutableGitEntry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGitEntry ImmutableGitEntry}.
   * <pre>
   * ImmutableGitEntry.builder()
   *    .id(String) // required {@link GitConfig.GitEntry#getId() id}
   *    .created(java.sql.Timestamp) // required {@link GitConfig.GitEntry#getCreated() created}
   *    .modified(java.sql.Timestamp) // required {@link GitConfig.GitEntry#getModified() modified}
   *    .bodyType(io.resys.hdes.client.api.ast.AstBody.AstBodyType) // required {@link GitConfig.GitEntry#getBodyType() bodyType}
   *    .revision(String) // required {@link GitConfig.GitEntry#getRevision() revision}
   *    .blobHash(String) // required {@link GitConfig.GitEntry#getBlobHash() blobHash}
   *    .treeValue(String) // required {@link GitConfig.GitEntry#getTreeValue() treeValue}
   *    .blobValue(String) // required {@link GitConfig.GitEntry#getBlobValue() blobValue}
   *    .addCommands|addAllCommands(io.resys.hdes.client.api.ast.AstCommand) // {@link GitConfig.GitEntry#getCommands() commands} elements
   *    .build();
   * </pre>
   * @return A new ImmutableGitEntry builder
   */
  public static ImmutableGitEntry.Builder builder() {
    return new ImmutableGitEntry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGitEntry ImmutableGitEntry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "GitConfig.GitEntry", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_CREATED = 0x2L;
    private static final long INIT_BIT_MODIFIED = 0x4L;
    private static final long INIT_BIT_BODY_TYPE = 0x8L;
    private static final long INIT_BIT_REVISION = 0x10L;
    private static final long INIT_BIT_BLOB_HASH = 0x20L;
    private static final long INIT_BIT_TREE_VALUE = 0x40L;
    private static final long INIT_BIT_BLOB_VALUE = 0x80L;
    private long initBits = 0xffL;

    private @Nullable String id;
    private @Nullable Timestamp created;
    private @Nullable Timestamp modified;
    private @Nullable AstBody.AstBodyType bodyType;
    private @Nullable String revision;
    private @Nullable String blobHash;
    private @Nullable String treeValue;
    private @Nullable String blobValue;
    private ImmutableList.Builder<AstCommand> commands = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GitEntry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(GitConfig.GitEntry instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      created(instance.getCreated());
      modified(instance.getModified());
      bodyType(instance.getBodyType());
      revision(instance.getRevision());
      blobHash(instance.getBlobHash());
      treeValue(instance.getTreeValue());
      blobValue(instance.getBlobValue());
      addAllCommands(instance.getCommands());
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitEntry#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitEntry#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder created(Timestamp created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitEntry#getModified() modified} attribute.
     * @param modified The value for modified 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder modified(Timestamp modified) {
      this.modified = Objects.requireNonNull(modified, "modified");
      initBits &= ~INIT_BIT_MODIFIED;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitEntry#getBodyType() bodyType} attribute.
     * @param bodyType The value for bodyType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder bodyType(AstBody.AstBodyType bodyType) {
      this.bodyType = Objects.requireNonNull(bodyType, "bodyType");
      initBits &= ~INIT_BIT_BODY_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitEntry#getRevision() revision} attribute.
     * @param revision The value for revision 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder revision(String revision) {
      this.revision = Objects.requireNonNull(revision, "revision");
      initBits &= ~INIT_BIT_REVISION;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitEntry#getBlobHash() blobHash} attribute.
     * @param blobHash The value for blobHash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blobHash(String blobHash) {
      this.blobHash = Objects.requireNonNull(blobHash, "blobHash");
      initBits &= ~INIT_BIT_BLOB_HASH;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitEntry#getTreeValue() treeValue} attribute.
     * @param treeValue The value for treeValue 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder treeValue(String treeValue) {
      this.treeValue = Objects.requireNonNull(treeValue, "treeValue");
      initBits &= ~INIT_BIT_TREE_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link GitConfig.GitEntry#getBlobValue() blobValue} attribute.
     * @param blobValue The value for blobValue 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder blobValue(String blobValue) {
      this.blobValue = Objects.requireNonNull(blobValue, "blobValue");
      initBits &= ~INIT_BIT_BLOB_VALUE;
      return this;
    }

    /**
     * Adds one element to {@link GitConfig.GitEntry#getCommands() commands} list.
     * @param element A commands element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCommands(AstCommand element) {
      this.commands.add(element);
      return this;
    }

    /**
     * Adds elements to {@link GitConfig.GitEntry#getCommands() commands} list.
     * @param elements An array of commands elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addCommands(AstCommand... elements) {
      this.commands.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link GitConfig.GitEntry#getCommands() commands} list.
     * @param elements An iterable of commands elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commands(Iterable<? extends AstCommand> elements) {
      this.commands = ImmutableList.builder();
      return addAllCommands(elements);
    }

    /**
     * Adds elements to {@link GitConfig.GitEntry#getCommands() commands} list.
     * @param elements An iterable of commands elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllCommands(Iterable<? extends AstCommand> elements) {
      this.commands.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableGitEntry ImmutableGitEntry}.
     * @return An immutable instance of GitEntry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGitEntry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGitEntry(id, created, modified, bodyType, revision, blobHash, treeValue, blobValue, commands.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      if ((initBits & INIT_BIT_MODIFIED) != 0) attributes.add("modified");
      if ((initBits & INIT_BIT_BODY_TYPE) != 0) attributes.add("bodyType");
      if ((initBits & INIT_BIT_REVISION) != 0) attributes.add("revision");
      if ((initBits & INIT_BIT_BLOB_HASH) != 0) attributes.add("blobHash");
      if ((initBits & INIT_BIT_TREE_VALUE) != 0) attributes.add("treeValue");
      if ((initBits & INIT_BIT_BLOB_VALUE) != 0) attributes.add("blobValue");
      return "Cannot build GitEntry, some of required attributes are not set " + attributes;
    }
  }
}
