/*
 * Decompiled with CFR 0.152.
 */
package io.resys.wrench.assets.bundle.spi;

import io.resys.wrench.assets.bundle.spi.exceptions.DataException;
import io.resys.wrench.assets.bundle.spi.exceptions.DataRedirectException;
import io.resys.wrench.assets.bundle.spi.exceptions.Message;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.Nullable;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.context.request.WebRequest;

@ControllerAdvice
public class AssetExceptionMapping {
    private static final Logger LOGGER = LoggerFactory.getLogger(AssetExceptionMapping.class);

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Object> handleConflict(Exception t, WebRequest webRequest) {
        HttpHeaders headers = new HttpHeaders();
        if (t instanceof DataRedirectException) {
            DataRedirectException redirect = (DataRedirectException)t;
            headers.set("Location", redirect.getUrl());
            return new ResponseEntity(null, (MultiValueMap)headers, HttpStatus.FOUND);
        }
        long timestamp = System.currentTimeMillis();
        String stacktrace = String.valueOf(timestamp) + " " + t.getMessage() + ExceptionUtils.getStackTrace((Throwable)t);
        String hash = this.exceptionHash(stacktrace, timestamp);
        LOGGER.error("Internal error ID " + hash, (Throwable)t);
        Map.Entry<Integer, List<Message>> body = this.createBody(t, hash);
        List<Message> messages = body.getValue();
        messages.add(new Message("stacktrace", stacktrace));
        return this.handleExceptionInternal(t, body.getValue(), headers, HttpStatus.resolve((int)body.getKey()), webRequest);
    }

    protected ResponseEntity<Object> handleExceptionInternal(Exception ex, @Nullable Object body, HttpHeaders headers, HttpStatus status, WebRequest request) {
        if (HttpStatus.INTERNAL_SERVER_ERROR.equals((Object)status)) {
            request.setAttribute("javax.servlet.error.exception", (Object)ex, 0);
        }
        return new ResponseEntity(body, (MultiValueMap)headers, status);
    }

    protected String exceptionHash(String msg, long timestamp) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            md5.update(msg.getBytes(Charset.forName("UTF-8")));
            byte[] digest = md5.digest();
            return Hex.encodeHexString((byte[])digest);
        }
        catch (NoSuchAlgorithmException ex) {
            LOGGER.warn("MD5 Digester not found, falling back to timestamp hash", (Throwable)ex);
            return Long.toHexString(timestamp);
        }
    }

    private Map.Entry<Integer, List<Message>> createBody(Exception e, String hash) {
        int status;
        ArrayList<Message> messages = new ArrayList<Message>();
        if (e instanceof DataException) {
            status = ((DataException)e).getMessagesList().getStatus();
            messages.addAll(((DataException)e).getMessagesList().get());
        } else {
            status = 500;
            messages.add(new Message("internalError", "internal error, see log code"));
        }
        List body = messages.stream().map(m -> this.translate(m.setLogCode(hash))).collect(Collectors.toList());
        return new AbstractMap.SimpleEntry<Integer, List<Message>>(status, body);
    }

    protected Message translate(Message message) {
        try {
            String translation = MessageFormat.format(message.getValue(), message.getArgs());
            return new Message(message.getCode(), translation, message.getContext()).setArgs(message.getArgs());
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
            return message;
        }
    }
}

