package io.resys.hdes.projects.spi.mongodb.support;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoWrapper}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoWrapper.builder()}.
 */
@Generated(from = "MongoWrapper", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableMongoWrapper implements MongoWrapper {
  private final MongoClient client;
  private final MongoWrapper.MongoDbConfig config;
  private final MongoDatabase db;

  private ImmutableMongoWrapper(
      MongoClient client,
      MongoWrapper.MongoDbConfig config,
      MongoDatabase db) {
    this.client = client;
    this.config = config;
    this.db = db;
  }

  /**
   * @return The value of the {@code client} attribute
   */
  @Override
  public MongoClient getClient() {
    return client;
  }

  /**
   * @return The value of the {@code config} attribute
   */
  @Override
  public MongoWrapper.MongoDbConfig getConfig() {
    return config;
  }

  /**
   * @return The value of the {@code db} attribute
   */
  @Override
  public MongoDatabase getDb() {
    return db;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoWrapper#getClient() client} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for client
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoWrapper withClient(MongoClient value) {
    if (this.client == value) return this;
    MongoClient newValue = Objects.requireNonNull(value, "client");
    return new ImmutableMongoWrapper(newValue, this.config, this.db);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoWrapper#getConfig() config} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for config
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoWrapper withConfig(MongoWrapper.MongoDbConfig value) {
    if (this.config == value) return this;
    MongoWrapper.MongoDbConfig newValue = Objects.requireNonNull(value, "config");
    return new ImmutableMongoWrapper(this.client, newValue, this.db);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoWrapper#getDb() db} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for db
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoWrapper withDb(MongoDatabase value) {
    if (this.db == value) return this;
    MongoDatabase newValue = Objects.requireNonNull(value, "db");
    return new ImmutableMongoWrapper(this.client, this.config, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoWrapper} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoWrapper
        && equalTo((ImmutableMongoWrapper) another);
  }

  private boolean equalTo(ImmutableMongoWrapper another) {
    return client.equals(another.client)
        && config.equals(another.config)
        && db.equals(another.db);
  }

  /**
   * Computes a hash code from attributes: {@code client}, {@code config}, {@code db}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + client.hashCode();
    h += (h << 5) + config.hashCode();
    h += (h << 5) + db.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongoWrapper} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MongoWrapper{"
        + "client=" + client
        + ", config=" + config
        + ", db=" + db
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MongoWrapper} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoWrapper instance
   */
  public static ImmutableMongoWrapper copyOf(MongoWrapper instance) {
    if (instance instanceof ImmutableMongoWrapper) {
      return (ImmutableMongoWrapper) instance;
    }
    return ImmutableMongoWrapper.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoWrapper ImmutableMongoWrapper}.
   * <pre>
   * ImmutableMongoWrapper.builder()
   *    .client(com.mongodb.client.MongoClient) // required {@link MongoWrapper#getClient() client}
   *    .config(io.resys.hdes.projects.spi.mongodb.support.MongoWrapper.MongoDbConfig) // required {@link MongoWrapper#getConfig() config}
   *    .db(com.mongodb.client.MongoDatabase) // required {@link MongoWrapper#getDb() db}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoWrapper builder
   */
  public static ImmutableMongoWrapper.Builder builder() {
    return new ImmutableMongoWrapper.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoWrapper ImmutableMongoWrapper}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoWrapper", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CLIENT = 0x1L;
    private static final long INIT_BIT_CONFIG = 0x2L;
    private static final long INIT_BIT_DB = 0x4L;
    private long initBits = 0x7L;

    private @Nullable MongoClient client;
    private @Nullable MongoWrapper.MongoDbConfig config;
    private @Nullable MongoDatabase db;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MongoWrapper} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoWrapper instance) {
      Objects.requireNonNull(instance, "instance");
      client(instance.getClient());
      config(instance.getConfig());
      db(instance.getDb());
      return this;
    }

    /**
     * Initializes the value for the {@link MongoWrapper#getClient() client} attribute.
     * @param client The value for client 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder client(MongoClient client) {
      this.client = Objects.requireNonNull(client, "client");
      initBits &= ~INIT_BIT_CLIENT;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoWrapper#getConfig() config} attribute.
     * @param config The value for config 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder config(MongoWrapper.MongoDbConfig config) {
      this.config = Objects.requireNonNull(config, "config");
      initBits &= ~INIT_BIT_CONFIG;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoWrapper#getDb() db} attribute.
     * @param db The value for db 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder db(MongoDatabase db) {
      this.db = Objects.requireNonNull(db, "db");
      initBits &= ~INIT_BIT_DB;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoWrapper ImmutableMongoWrapper}.
     * @return An immutable instance of MongoWrapper
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoWrapper build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMongoWrapper(client, config, db);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CLIENT) != 0) attributes.add("client");
      if ((initBits & INIT_BIT_CONFIG) != 0) attributes.add("config");
      if ((initBits & INIT_BIT_DB) != 0) attributes.add("db");
      return "Cannot build MongoWrapper, some of required attributes are not set " + attributes;
    }
  }
}
