package io.resys.hdes.projects.spi.mongodb.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoWrapper.MongoDbConfig}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoDbConfig.builder()}.
 */
@Generated(from = "MongoWrapper.MongoDbConfig", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableMongoDbConfig
    implements MongoWrapper.MongoDbConfig {
  private final String db;
  private final String transactions;
  private final String projects;
  private final String users;
  private final String groups;
  private final String groupUsers;
  private final String access;

  private ImmutableMongoDbConfig(
      String db,
      String transactions,
      String projects,
      String users,
      String groups,
      String groupUsers,
      String access) {
    this.db = db;
    this.transactions = transactions;
    this.projects = projects;
    this.users = users;
    this.groups = groups;
    this.groupUsers = groupUsers;
    this.access = access;
  }

  /**
   * @return The value of the {@code db} attribute
   */
  @Override
  public String getDb() {
    return db;
  }

  /**
   * @return The value of the {@code transactions} attribute
   */
  @Override
  public String getTransactions() {
    return transactions;
  }

  /**
   * @return The value of the {@code projects} attribute
   */
  @Override
  public String getProjects() {
    return projects;
  }

  /**
   * @return The value of the {@code users} attribute
   */
  @Override
  public String getUsers() {
    return users;
  }

  /**
   * @return The value of the {@code groups} attribute
   */
  @Override
  public String getGroups() {
    return groups;
  }

  /**
   * @return The value of the {@code groupUsers} attribute
   */
  @Override
  public String getGroupUsers() {
    return groupUsers;
  }

  /**
   * @return The value of the {@code access} attribute
   */
  @Override
  public String getAccess() {
    return access;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoWrapper.MongoDbConfig#getDb() db} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for db
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withDb(String value) {
    String newValue = Objects.requireNonNull(value, "db");
    if (this.db.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(
        newValue,
        this.transactions,
        this.projects,
        this.users,
        this.groups,
        this.groupUsers,
        this.access);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoWrapper.MongoDbConfig#getTransactions() transactions} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for transactions
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withTransactions(String value) {
    String newValue = Objects.requireNonNull(value, "transactions");
    if (this.transactions.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(this.db, newValue, this.projects, this.users, this.groups, this.groupUsers, this.access);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoWrapper.MongoDbConfig#getProjects() projects} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for projects
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withProjects(String value) {
    String newValue = Objects.requireNonNull(value, "projects");
    if (this.projects.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(this.db, this.transactions, newValue, this.users, this.groups, this.groupUsers, this.access);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoWrapper.MongoDbConfig#getUsers() users} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for users
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withUsers(String value) {
    String newValue = Objects.requireNonNull(value, "users");
    if (this.users.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(this.db, this.transactions, this.projects, newValue, this.groups, this.groupUsers, this.access);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoWrapper.MongoDbConfig#getGroups() groups} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for groups
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withGroups(String value) {
    String newValue = Objects.requireNonNull(value, "groups");
    if (this.groups.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(this.db, this.transactions, this.projects, this.users, newValue, this.groupUsers, this.access);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoWrapper.MongoDbConfig#getGroupUsers() groupUsers} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for groupUsers
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withGroupUsers(String value) {
    String newValue = Objects.requireNonNull(value, "groupUsers");
    if (this.groupUsers.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(this.db, this.transactions, this.projects, this.users, this.groups, newValue, this.access);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoWrapper.MongoDbConfig#getAccess() access} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for access
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMongoDbConfig withAccess(String value) {
    String newValue = Objects.requireNonNull(value, "access");
    if (this.access.equals(newValue)) return this;
    return new ImmutableMongoDbConfig(this.db, this.transactions, this.projects, this.users, this.groups, this.groupUsers, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoDbConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoDbConfig
        && equalTo((ImmutableMongoDbConfig) another);
  }

  private boolean equalTo(ImmutableMongoDbConfig another) {
    return db.equals(another.db)
        && transactions.equals(another.transactions)
        && projects.equals(another.projects)
        && users.equals(another.users)
        && groups.equals(another.groups)
        && groupUsers.equals(another.groupUsers)
        && access.equals(another.access);
  }

  /**
   * Computes a hash code from attributes: {@code db}, {@code transactions}, {@code projects}, {@code users}, {@code groups}, {@code groupUsers}, {@code access}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + db.hashCode();
    h += (h << 5) + transactions.hashCode();
    h += (h << 5) + projects.hashCode();
    h += (h << 5) + users.hashCode();
    h += (h << 5) + groups.hashCode();
    h += (h << 5) + groupUsers.hashCode();
    h += (h << 5) + access.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongoDbConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MongoDbConfig{"
        + "db=" + db
        + ", transactions=" + transactions
        + ", projects=" + projects
        + ", users=" + users
        + ", groups=" + groups
        + ", groupUsers=" + groupUsers
        + ", access=" + access
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MongoWrapper.MongoDbConfig} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoDbConfig instance
   */
  public static ImmutableMongoDbConfig copyOf(MongoWrapper.MongoDbConfig instance) {
    if (instance instanceof ImmutableMongoDbConfig) {
      return (ImmutableMongoDbConfig) instance;
    }
    return ImmutableMongoDbConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoDbConfig ImmutableMongoDbConfig}.
   * <pre>
   * ImmutableMongoDbConfig.builder()
   *    .db(String) // required {@link MongoWrapper.MongoDbConfig#getDb() db}
   *    .transactions(String) // required {@link MongoWrapper.MongoDbConfig#getTransactions() transactions}
   *    .projects(String) // required {@link MongoWrapper.MongoDbConfig#getProjects() projects}
   *    .users(String) // required {@link MongoWrapper.MongoDbConfig#getUsers() users}
   *    .groups(String) // required {@link MongoWrapper.MongoDbConfig#getGroups() groups}
   *    .groupUsers(String) // required {@link MongoWrapper.MongoDbConfig#getGroupUsers() groupUsers}
   *    .access(String) // required {@link MongoWrapper.MongoDbConfig#getAccess() access}
   *    .build();
   * </pre>
   * @return A new ImmutableMongoDbConfig builder
   */
  public static ImmutableMongoDbConfig.Builder builder() {
    return new ImmutableMongoDbConfig.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoDbConfig ImmutableMongoDbConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoWrapper.MongoDbConfig", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_DB = 0x1L;
    private static final long INIT_BIT_TRANSACTIONS = 0x2L;
    private static final long INIT_BIT_PROJECTS = 0x4L;
    private static final long INIT_BIT_USERS = 0x8L;
    private static final long INIT_BIT_GROUPS = 0x10L;
    private static final long INIT_BIT_GROUP_USERS = 0x20L;
    private static final long INIT_BIT_ACCESS = 0x40L;
    private long initBits = 0x7fL;

    private @Nullable String db;
    private @Nullable String transactions;
    private @Nullable String projects;
    private @Nullable String users;
    private @Nullable String groups;
    private @Nullable String groupUsers;
    private @Nullable String access;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MongoDbConfig} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoWrapper.MongoDbConfig instance) {
      Objects.requireNonNull(instance, "instance");
      db(instance.getDb());
      transactions(instance.getTransactions());
      projects(instance.getProjects());
      users(instance.getUsers());
      groups(instance.getGroups());
      groupUsers(instance.getGroupUsers());
      access(instance.getAccess());
      return this;
    }

    /**
     * Initializes the value for the {@link MongoWrapper.MongoDbConfig#getDb() db} attribute.
     * @param db The value for db 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder db(String db) {
      this.db = Objects.requireNonNull(db, "db");
      initBits &= ~INIT_BIT_DB;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoWrapper.MongoDbConfig#getTransactions() transactions} attribute.
     * @param transactions The value for transactions 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder transactions(String transactions) {
      this.transactions = Objects.requireNonNull(transactions, "transactions");
      initBits &= ~INIT_BIT_TRANSACTIONS;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoWrapper.MongoDbConfig#getProjects() projects} attribute.
     * @param projects The value for projects 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder projects(String projects) {
      this.projects = Objects.requireNonNull(projects, "projects");
      initBits &= ~INIT_BIT_PROJECTS;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoWrapper.MongoDbConfig#getUsers() users} attribute.
     * @param users The value for users 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder users(String users) {
      this.users = Objects.requireNonNull(users, "users");
      initBits &= ~INIT_BIT_USERS;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoWrapper.MongoDbConfig#getGroups() groups} attribute.
     * @param groups The value for groups 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groups(String groups) {
      this.groups = Objects.requireNonNull(groups, "groups");
      initBits &= ~INIT_BIT_GROUPS;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoWrapper.MongoDbConfig#getGroupUsers() groupUsers} attribute.
     * @param groupUsers The value for groupUsers 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupUsers(String groupUsers) {
      this.groupUsers = Objects.requireNonNull(groupUsers, "groupUsers");
      initBits &= ~INIT_BIT_GROUP_USERS;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoWrapper.MongoDbConfig#getAccess() access} attribute.
     * @param access The value for access 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder access(String access) {
      this.access = Objects.requireNonNull(access, "access");
      initBits &= ~INIT_BIT_ACCESS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoDbConfig ImmutableMongoDbConfig}.
     * @return An immutable instance of MongoDbConfig
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoDbConfig build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMongoDbConfig(db, transactions, projects, users, groups, groupUsers, access);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_DB) != 0) attributes.add("db");
      if ((initBits & INIT_BIT_TRANSACTIONS) != 0) attributes.add("transactions");
      if ((initBits & INIT_BIT_PROJECTS) != 0) attributes.add("projects");
      if ((initBits & INIT_BIT_USERS) != 0) attributes.add("users");
      if ((initBits & INIT_BIT_GROUPS) != 0) attributes.add("groups");
      if ((initBits & INIT_BIT_GROUP_USERS) != 0) attributes.add("groupUsers");
      if ((initBits & INIT_BIT_ACCESS) != 0) attributes.add("access");
      return "Cannot build MongoDbConfig, some of required attributes are not set " + attributes;
    }
  }
}
