package io.resys.hdes.projects.spi.mongodb.queries;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.bson.conversions.Bson;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoQuery.QueryResultWithAccess}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQueryResultWithAccess.builder()}.
 */
@Generated(from = "MongoQuery.QueryResultWithAccess", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableQueryResultWithAccess<T>
    implements MongoQuery.QueryResultWithAccess<T> {
  private final T value;
  private final Bson filter;

  private ImmutableQueryResultWithAccess(T value, Bson filter) {
    this.value = value;
    this.filter = filter;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public T getValue() {
    return value;
  }

  /**
   * @return The value of the {@code filter} attribute
   */
  @Override
  public Bson getFilter() {
    return filter;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoQuery.QueryResultWithAccess#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryResultWithAccess<T> withValue(T value) {
    if (this.value == value) return this;
    T newValue = Objects.requireNonNull(value, "value");
    return new ImmutableQueryResultWithAccess<>(newValue, this.filter);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MongoQuery.QueryResultWithAccess#getFilter() filter} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for filter
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryResultWithAccess<T> withFilter(Bson value) {
    if (this.filter == value) return this;
    Bson newValue = Objects.requireNonNull(value, "filter");
    return new ImmutableQueryResultWithAccess<>(this.value, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQueryResultWithAccess} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQueryResultWithAccess<?>
        && equalTo((ImmutableQueryResultWithAccess<?>) another);
  }

  private boolean equalTo(ImmutableQueryResultWithAccess<?> another) {
    return value.equals(another.value)
        && filter.equals(another.filter);
  }

  /**
   * Computes a hash code from attributes: {@code value}, {@code filter}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + value.hashCode();
    h += (h << 5) + filter.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QueryResultWithAccess} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "QueryResultWithAccess{"
        + "value=" + value
        + ", filter=" + filter
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MongoQuery.QueryResultWithAccess} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable QueryResultWithAccess instance
   */
  public static <T> ImmutableQueryResultWithAccess<T> copyOf(MongoQuery.QueryResultWithAccess<T> instance) {
    if (instance instanceof ImmutableQueryResultWithAccess<?>) {
      return (ImmutableQueryResultWithAccess<T>) instance;
    }
    return ImmutableQueryResultWithAccess.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQueryResultWithAccess ImmutableQueryResultWithAccess}.
   * <pre>
   * ImmutableQueryResultWithAccess.&amp;lt;T&amp;gt;builder()
   *    .value(T) // required {@link MongoQuery.QueryResultWithAccess#getValue() value}
   *    .filter(org.bson.conversions.Bson) // required {@link MongoQuery.QueryResultWithAccess#getFilter() filter}
   *    .build();
   * </pre>
   * @param <T> generic parameter T
   * @return A new ImmutableQueryResultWithAccess builder
   */
  public static <T> ImmutableQueryResultWithAccess.Builder<T> builder() {
    return new ImmutableQueryResultWithAccess.Builder<>();
  }

  /**
   * Builds instances of type {@link ImmutableQueryResultWithAccess ImmutableQueryResultWithAccess}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoQuery.QueryResultWithAccess", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder<T> {
    private static final long INIT_BIT_VALUE = 0x1L;
    private static final long INIT_BIT_FILTER = 0x2L;
    private long initBits = 0x3L;

    private @Nullable T value;
    private @Nullable Bson filter;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code QueryResultWithAccess} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(MongoQuery.QueryResultWithAccess<T> instance) {
      Objects.requireNonNull(instance, "instance");
      value(instance.getValue());
      filter(instance.getFilter());
      return this;
    }

    /**
     * Initializes the value for the {@link MongoQuery.QueryResultWithAccess#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> value(T value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the value for the {@link MongoQuery.QueryResultWithAccess#getFilter() filter} attribute.
     * @param filter The value for filter 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> filter(Bson filter) {
      this.filter = Objects.requireNonNull(filter, "filter");
      initBits &= ~INIT_BIT_FILTER;
      return this;
    }

    /**
     * Builds a new {@link ImmutableQueryResultWithAccess ImmutableQueryResultWithAccess}.
     * @return An immutable instance of QueryResultWithAccess
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQueryResultWithAccess<T> build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQueryResultWithAccess<>(value, filter);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      if ((initBits & INIT_BIT_FILTER) != 0) attributes.add("filter");
      return "Cannot build QueryResultWithAccess, some of required attributes are not set " + attributes;
    }
  }
}
