package io.resys.hdes.projects.spi.mongodb.builders;

import io.resys.hdes.projects.api.PmRepository;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link MongoBuilder.MongoBuilderTree}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMongoBuilderTree.builder()}.
 */
@Generated(from = "MongoBuilder.MongoBuilderTree", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableMongoBuilderTree
    implements MongoBuilder.MongoBuilderTree {
  private final Map<String, PmRepository.Project> project;
  private final Map<String, PmRepository.Access> access;
  private final Map<String, PmRepository.User> user;
  private final Map<String, PmRepository.Group> groups;
  private final Map<String, PmRepository.GroupUser> groupUsers;

  private ImmutableMongoBuilderTree(
      Map<String, PmRepository.Project> project,
      Map<String, PmRepository.Access> access,
      Map<String, PmRepository.User> user,
      Map<String, PmRepository.Group> groups,
      Map<String, PmRepository.GroupUser> groupUsers) {
    this.project = project;
    this.access = access;
    this.user = user;
    this.groups = groups;
    this.groupUsers = groupUsers;
  }

  /**
   * @return The value of the {@code project} attribute
   */
  @Override
  public Map<String, PmRepository.Project> getProject() {
    return project;
  }

  /**
   * @return The value of the {@code access} attribute
   */
  @Override
  public Map<String, PmRepository.Access> getAccess() {
    return access;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @Override
  public Map<String, PmRepository.User> getUser() {
    return user;
  }

  /**
   * @return The value of the {@code groups} attribute
   */
  @Override
  public Map<String, PmRepository.Group> getGroups() {
    return groups;
  }

  /**
   * @return The value of the {@code groupUsers} attribute
   */
  @Override
  public Map<String, PmRepository.GroupUser> getGroupUsers() {
    return groupUsers;
  }

  /**
   * Copy the current immutable object by replacing the {@link MongoBuilder.MongoBuilderTree#getProject() project} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the project map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoBuilderTree withProject(Map<String, ? extends PmRepository.Project> entries) {
    if (this.project == entries) return this;
    Map<String, PmRepository.Project> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableMongoBuilderTree(newValue, this.access, this.user, this.groups, this.groupUsers);
  }

  /**
   * Copy the current immutable object by replacing the {@link MongoBuilder.MongoBuilderTree#getAccess() access} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the access map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoBuilderTree withAccess(Map<String, ? extends PmRepository.Access> entries) {
    if (this.access == entries) return this;
    Map<String, PmRepository.Access> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableMongoBuilderTree(this.project, newValue, this.user, this.groups, this.groupUsers);
  }

  /**
   * Copy the current immutable object by replacing the {@link MongoBuilder.MongoBuilderTree#getUser() user} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the user map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoBuilderTree withUser(Map<String, ? extends PmRepository.User> entries) {
    if (this.user == entries) return this;
    Map<String, PmRepository.User> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableMongoBuilderTree(this.project, this.access, newValue, this.groups, this.groupUsers);
  }

  /**
   * Copy the current immutable object by replacing the {@link MongoBuilder.MongoBuilderTree#getGroups() groups} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the groups map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoBuilderTree withGroups(Map<String, ? extends PmRepository.Group> entries) {
    if (this.groups == entries) return this;
    Map<String, PmRepository.Group> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableMongoBuilderTree(this.project, this.access, this.user, newValue, this.groupUsers);
  }

  /**
   * Copy the current immutable object by replacing the {@link MongoBuilder.MongoBuilderTree#getGroupUsers() groupUsers} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the groupUsers map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMongoBuilderTree withGroupUsers(Map<String, ? extends PmRepository.GroupUser> entries) {
    if (this.groupUsers == entries) return this;
    Map<String, PmRepository.GroupUser> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableMongoBuilderTree(this.project, this.access, this.user, this.groups, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMongoBuilderTree} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMongoBuilderTree
        && equalTo((ImmutableMongoBuilderTree) another);
  }

  private boolean equalTo(ImmutableMongoBuilderTree another) {
    return project.equals(another.project)
        && access.equals(another.access)
        && user.equals(another.user)
        && groups.equals(another.groups)
        && groupUsers.equals(another.groupUsers);
  }

  /**
   * Computes a hash code from attributes: {@code project}, {@code access}, {@code user}, {@code groups}, {@code groupUsers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + project.hashCode();
    h += (h << 5) + access.hashCode();
    h += (h << 5) + user.hashCode();
    h += (h << 5) + groups.hashCode();
    h += (h << 5) + groupUsers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MongoBuilderTree} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MongoBuilderTree{"
        + "project=" + project
        + ", access=" + access
        + ", user=" + user
        + ", groups=" + groups
        + ", groupUsers=" + groupUsers
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link MongoBuilder.MongoBuilderTree} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MongoBuilderTree instance
   */
  public static ImmutableMongoBuilderTree copyOf(MongoBuilder.MongoBuilderTree instance) {
    if (instance instanceof ImmutableMongoBuilderTree) {
      return (ImmutableMongoBuilderTree) instance;
    }
    return ImmutableMongoBuilderTree.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMongoBuilderTree ImmutableMongoBuilderTree}.
   * <pre>
   * ImmutableMongoBuilderTree.builder()
   *    .putProject|putAllProject(String =&gt; io.resys.hdes.projects.api.PmRepository.Project) // {@link MongoBuilder.MongoBuilderTree#getProject() project} mappings
   *    .putAccess|putAllAccess(String =&gt; io.resys.hdes.projects.api.PmRepository.Access) // {@link MongoBuilder.MongoBuilderTree#getAccess() access} mappings
   *    .putUser|putAllUser(String =&gt; io.resys.hdes.projects.api.PmRepository.User) // {@link MongoBuilder.MongoBuilderTree#getUser() user} mappings
   *    .putGroups|putAllGroups(String =&gt; io.resys.hdes.projects.api.PmRepository.Group) // {@link MongoBuilder.MongoBuilderTree#getGroups() groups} mappings
   *    .putGroupUsers|putAllGroupUsers(String =&gt; io.resys.hdes.projects.api.PmRepository.GroupUser) // {@link MongoBuilder.MongoBuilderTree#getGroupUsers() groupUsers} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableMongoBuilderTree builder
   */
  public static ImmutableMongoBuilderTree.Builder builder() {
    return new ImmutableMongoBuilderTree.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMongoBuilderTree ImmutableMongoBuilderTree}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MongoBuilder.MongoBuilderTree", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private Map<String, PmRepository.Project> project = new LinkedHashMap<String, PmRepository.Project>();
    private Map<String, PmRepository.Access> access = new LinkedHashMap<String, PmRepository.Access>();
    private Map<String, PmRepository.User> user = new LinkedHashMap<String, PmRepository.User>();
    private Map<String, PmRepository.Group> groups = new LinkedHashMap<String, PmRepository.Group>();
    private Map<String, PmRepository.GroupUser> groupUsers = new LinkedHashMap<String, PmRepository.GroupUser>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code MongoBuilderTree} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MongoBuilder.MongoBuilderTree instance) {
      Objects.requireNonNull(instance, "instance");
      putAllProject(instance.getProject());
      putAllAccess(instance.getAccess());
      putAllUser(instance.getUser());
      putAllGroups(instance.getGroups());
      putAllGroupUsers(instance.getGroupUsers());
      return this;
    }

    /**
     * Put one entry to the {@link MongoBuilder.MongoBuilderTree#getProject() project} map.
     * @param key The key in the project map
     * @param value The associated value in the project map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProject(String key, PmRepository.Project value) {
      this.project.put(
          Objects.requireNonNull(key, "project key"),
          Objects.requireNonNull(value, "project value"));
      return this;
    }

    /**
     * Put one entry to the {@link MongoBuilder.MongoBuilderTree#getProject() project} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProject(Map.Entry<String, ? extends PmRepository.Project> entry) {
      String k = entry.getKey();
      PmRepository.Project v = entry.getValue();
      this.project.put(
          Objects.requireNonNull(k, "project key"),
          Objects.requireNonNull(v, "project value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MongoBuilder.MongoBuilderTree#getProject() project} map. Nulls are not permitted
     * @param entries The entries that will be added to the project map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder project(Map<String, ? extends PmRepository.Project> entries) {
      this.project.clear();
      return putAllProject(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MongoBuilder.MongoBuilderTree#getProject() project} map. Nulls are not permitted
     * @param entries The entries that will be added to the project map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllProject(Map<String, ? extends PmRepository.Project> entries) {
      for (Map.Entry<String, ? extends PmRepository.Project> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.Project v = e.getValue();
        this.project.put(
            Objects.requireNonNull(k, "project key"),
            Objects.requireNonNull(v, "project value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link MongoBuilder.MongoBuilderTree#getAccess() access} map.
     * @param key The key in the access map
     * @param value The associated value in the access map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAccess(String key, PmRepository.Access value) {
      this.access.put(
          Objects.requireNonNull(key, "access key"),
          Objects.requireNonNull(value, "access value"));
      return this;
    }

    /**
     * Put one entry to the {@link MongoBuilder.MongoBuilderTree#getAccess() access} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAccess(Map.Entry<String, ? extends PmRepository.Access> entry) {
      String k = entry.getKey();
      PmRepository.Access v = entry.getValue();
      this.access.put(
          Objects.requireNonNull(k, "access key"),
          Objects.requireNonNull(v, "access value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MongoBuilder.MongoBuilderTree#getAccess() access} map. Nulls are not permitted
     * @param entries The entries that will be added to the access map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder access(Map<String, ? extends PmRepository.Access> entries) {
      this.access.clear();
      return putAllAccess(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MongoBuilder.MongoBuilderTree#getAccess() access} map. Nulls are not permitted
     * @param entries The entries that will be added to the access map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAccess(Map<String, ? extends PmRepository.Access> entries) {
      for (Map.Entry<String, ? extends PmRepository.Access> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.Access v = e.getValue();
        this.access.put(
            Objects.requireNonNull(k, "access key"),
            Objects.requireNonNull(v, "access value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link MongoBuilder.MongoBuilderTree#getUser() user} map.
     * @param key The key in the user map
     * @param value The associated value in the user map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putUser(String key, PmRepository.User value) {
      this.user.put(
          Objects.requireNonNull(key, "user key"),
          Objects.requireNonNull(value, "user value"));
      return this;
    }

    /**
     * Put one entry to the {@link MongoBuilder.MongoBuilderTree#getUser() user} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putUser(Map.Entry<String, ? extends PmRepository.User> entry) {
      String k = entry.getKey();
      PmRepository.User v = entry.getValue();
      this.user.put(
          Objects.requireNonNull(k, "user key"),
          Objects.requireNonNull(v, "user value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MongoBuilder.MongoBuilderTree#getUser() user} map. Nulls are not permitted
     * @param entries The entries that will be added to the user map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder user(Map<String, ? extends PmRepository.User> entries) {
      this.user.clear();
      return putAllUser(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MongoBuilder.MongoBuilderTree#getUser() user} map. Nulls are not permitted
     * @param entries The entries that will be added to the user map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllUser(Map<String, ? extends PmRepository.User> entries) {
      for (Map.Entry<String, ? extends PmRepository.User> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.User v = e.getValue();
        this.user.put(
            Objects.requireNonNull(k, "user key"),
            Objects.requireNonNull(v, "user value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link MongoBuilder.MongoBuilderTree#getGroups() groups} map.
     * @param key The key in the groups map
     * @param value The associated value in the groups map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroups(String key, PmRepository.Group value) {
      this.groups.put(
          Objects.requireNonNull(key, "groups key"),
          Objects.requireNonNull(value, "groups value"));
      return this;
    }

    /**
     * Put one entry to the {@link MongoBuilder.MongoBuilderTree#getGroups() groups} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroups(Map.Entry<String, ? extends PmRepository.Group> entry) {
      String k = entry.getKey();
      PmRepository.Group v = entry.getValue();
      this.groups.put(
          Objects.requireNonNull(k, "groups key"),
          Objects.requireNonNull(v, "groups value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MongoBuilder.MongoBuilderTree#getGroups() groups} map. Nulls are not permitted
     * @param entries The entries that will be added to the groups map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groups(Map<String, ? extends PmRepository.Group> entries) {
      this.groups.clear();
      return putAllGroups(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MongoBuilder.MongoBuilderTree#getGroups() groups} map. Nulls are not permitted
     * @param entries The entries that will be added to the groups map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllGroups(Map<String, ? extends PmRepository.Group> entries) {
      for (Map.Entry<String, ? extends PmRepository.Group> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.Group v = e.getValue();
        this.groups.put(
            Objects.requireNonNull(k, "groups key"),
            Objects.requireNonNull(v, "groups value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link MongoBuilder.MongoBuilderTree#getGroupUsers() groupUsers} map.
     * @param key The key in the groupUsers map
     * @param value The associated value in the groupUsers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroupUsers(String key, PmRepository.GroupUser value) {
      this.groupUsers.put(
          Objects.requireNonNull(key, "groupUsers key"),
          Objects.requireNonNull(value, "groupUsers value"));
      return this;
    }

    /**
     * Put one entry to the {@link MongoBuilder.MongoBuilderTree#getGroupUsers() groupUsers} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroupUsers(Map.Entry<String, ? extends PmRepository.GroupUser> entry) {
      String k = entry.getKey();
      PmRepository.GroupUser v = entry.getValue();
      this.groupUsers.put(
          Objects.requireNonNull(k, "groupUsers key"),
          Objects.requireNonNull(v, "groupUsers value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MongoBuilder.MongoBuilderTree#getGroupUsers() groupUsers} map. Nulls are not permitted
     * @param entries The entries that will be added to the groupUsers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder groupUsers(Map<String, ? extends PmRepository.GroupUser> entries) {
      this.groupUsers.clear();
      return putAllGroupUsers(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MongoBuilder.MongoBuilderTree#getGroupUsers() groupUsers} map. Nulls are not permitted
     * @param entries The entries that will be added to the groupUsers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllGroupUsers(Map<String, ? extends PmRepository.GroupUser> entries) {
      for (Map.Entry<String, ? extends PmRepository.GroupUser> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.GroupUser v = e.getValue();
        this.groupUsers.put(
            Objects.requireNonNull(k, "groupUsers key"),
            Objects.requireNonNull(v, "groupUsers value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableMongoBuilderTree ImmutableMongoBuilderTree}.
     * @return An immutable instance of MongoBuilderTree
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMongoBuilderTree build() {
      return new ImmutableMongoBuilderTree(
          createUnmodifiableMap(false, false, project),
          createUnmodifiableMap(false, false, access),
          createUnmodifiableMap(false, false, user),
          createUnmodifiableMap(false, false, groups),
          createUnmodifiableMap(false, false, groupUsers));
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
