package io.resys.hdes.projects.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRepository.UserResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUserResource.builder()}.
 */
@Generated(from = "PmRepository.UserResource", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableUserResource implements PmRepository.UserResource {
  private final PmRepository.User user;
  private final Map<String, PmRepository.Project> projects;
  private final Map<String, PmRepository.Access> access;
  private final Map<String, PmRepository.Group> groups;
  private final Map<String, PmRepository.GroupUser> groupUsers;

  private ImmutableUserResource(
      PmRepository.User user,
      Map<String, PmRepository.Project> projects,
      Map<String, PmRepository.Access> access,
      Map<String, PmRepository.Group> groups,
      Map<String, PmRepository.GroupUser> groupUsers) {
    this.user = user;
    this.projects = projects;
    this.access = access;
    this.groups = groups;
    this.groupUsers = groupUsers;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty("user")
  @Override
  public PmRepository.User getUser() {
    return user;
  }

  /**
   * @return The value of the {@code projects} attribute
   */
  @JsonProperty("projects")
  @Override
  public Map<String, PmRepository.Project> getProjects() {
    return projects;
  }

  /**
   * @return The value of the {@code access} attribute
   */
  @JsonProperty("access")
  @Override
  public Map<String, PmRepository.Access> getAccess() {
    return access;
  }

  /**
   * @return The value of the {@code groups} attribute
   */
  @JsonProperty("groups")
  @Override
  public Map<String, PmRepository.Group> getGroups() {
    return groups;
  }

  /**
   * @return The value of the {@code groupUsers} attribute
   */
  @JsonProperty("groupUsers")
  @Override
  public Map<String, PmRepository.GroupUser> getGroupUsers() {
    return groupUsers;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.UserResource#getUser() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUserResource withUser(PmRepository.User value) {
    if (this.user == value) return this;
    PmRepository.User newValue = Objects.requireNonNull(value, "user");
    return new ImmutableUserResource(newValue, this.projects, this.access, this.groups, this.groupUsers);
  }

  /**
   * Copy the current immutable object by replacing the {@link PmRepository.UserResource#getProjects() projects} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the projects map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserResource withProjects(Map<String, ? extends PmRepository.Project> entries) {
    if (this.projects == entries) return this;
    Map<String, PmRepository.Project> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableUserResource(this.user, newValue, this.access, this.groups, this.groupUsers);
  }

  /**
   * Copy the current immutable object by replacing the {@link PmRepository.UserResource#getAccess() access} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the access map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserResource withAccess(Map<String, ? extends PmRepository.Access> entries) {
    if (this.access == entries) return this;
    Map<String, PmRepository.Access> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableUserResource(this.user, this.projects, newValue, this.groups, this.groupUsers);
  }

  /**
   * Copy the current immutable object by replacing the {@link PmRepository.UserResource#getGroups() groups} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the groups map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserResource withGroups(Map<String, ? extends PmRepository.Group> entries) {
    if (this.groups == entries) return this;
    Map<String, PmRepository.Group> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableUserResource(this.user, this.projects, this.access, newValue, this.groupUsers);
  }

  /**
   * Copy the current immutable object by replacing the {@link PmRepository.UserResource#getGroupUsers() groupUsers} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the groupUsers map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUserResource withGroupUsers(Map<String, ? extends PmRepository.GroupUser> entries) {
    if (this.groupUsers == entries) return this;
    Map<String, PmRepository.GroupUser> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableUserResource(this.user, this.projects, this.access, this.groups, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUserResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUserResource
        && equalTo((ImmutableUserResource) another);
  }

  private boolean equalTo(ImmutableUserResource another) {
    return user.equals(another.user)
        && projects.equals(another.projects)
        && access.equals(another.access)
        && groups.equals(another.groups)
        && groupUsers.equals(another.groupUsers);
  }

  /**
   * Computes a hash code from attributes: {@code user}, {@code projects}, {@code access}, {@code groups}, {@code groupUsers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + user.hashCode();
    h += (h << 5) + projects.hashCode();
    h += (h << 5) + access.hashCode();
    h += (h << 5) + groups.hashCode();
    h += (h << 5) + groupUsers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UserResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserResource{"
        + "user=" + user
        + ", projects=" + projects
        + ", access=" + access
        + ", groups=" + groups
        + ", groupUsers=" + groupUsers
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PmRepository.UserResource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PmRepository.UserResource {
    @Nullable PmRepository.User user;
    @Nullable Map<String, PmRepository.Project> projects = Collections.emptyMap();
    @Nullable Map<String, PmRepository.Access> access = Collections.emptyMap();
    @Nullable Map<String, PmRepository.Group> groups = Collections.emptyMap();
    @Nullable Map<String, PmRepository.GroupUser> groupUsers = Collections.emptyMap();
    @JsonProperty("user")
    public void setUser(PmRepository.User user) {
      this.user = user;
    }
    @JsonProperty("projects")
    public void setProjects(Map<String, PmRepository.Project> projects) {
      this.projects = projects;
    }
    @JsonProperty("access")
    public void setAccess(Map<String, PmRepository.Access> access) {
      this.access = access;
    }
    @JsonProperty("groups")
    public void setGroups(Map<String, PmRepository.Group> groups) {
      this.groups = groups;
    }
    @JsonProperty("groupUsers")
    public void setGroupUsers(Map<String, PmRepository.GroupUser> groupUsers) {
      this.groupUsers = groupUsers;
    }
    @Override
    public PmRepository.User getUser() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PmRepository.Project> getProjects() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PmRepository.Access> getAccess() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PmRepository.Group> getGroups() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PmRepository.GroupUser> getGroupUsers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableUserResource fromJson(Json json) {
    ImmutableUserResource.Builder builder = ImmutableUserResource.builder();
    if (json.user != null) {
      builder.user(json.user);
    }
    if (json.projects != null) {
      builder.putAllProjects(json.projects);
    }
    if (json.access != null) {
      builder.putAllAccess(json.access);
    }
    if (json.groups != null) {
      builder.putAllGroups(json.groups);
    }
    if (json.groupUsers != null) {
      builder.putAllGroupUsers(json.groupUsers);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PmRepository.UserResource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UserResource instance
   */
  public static ImmutableUserResource copyOf(PmRepository.UserResource instance) {
    if (instance instanceof ImmutableUserResource) {
      return (ImmutableUserResource) instance;
    }
    return ImmutableUserResource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUserResource ImmutableUserResource}.
   * <pre>
   * ImmutableUserResource.builder()
   *    .user(io.resys.hdes.projects.api.PmRepository.User) // required {@link PmRepository.UserResource#getUser() user}
   *    .putProjects|putAllProjects(String =&gt; io.resys.hdes.projects.api.PmRepository.Project) // {@link PmRepository.UserResource#getProjects() projects} mappings
   *    .putAccess|putAllAccess(String =&gt; io.resys.hdes.projects.api.PmRepository.Access) // {@link PmRepository.UserResource#getAccess() access} mappings
   *    .putGroups|putAllGroups(String =&gt; io.resys.hdes.projects.api.PmRepository.Group) // {@link PmRepository.UserResource#getGroups() groups} mappings
   *    .putGroupUsers|putAllGroupUsers(String =&gt; io.resys.hdes.projects.api.PmRepository.GroupUser) // {@link PmRepository.UserResource#getGroupUsers() groupUsers} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableUserResource builder
   */
  public static ImmutableUserResource.Builder builder() {
    return new ImmutableUserResource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUserResource ImmutableUserResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRepository.UserResource", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_USER = 0x1L;
    private long initBits = 0x1L;

    private @Nullable PmRepository.User user;
    private Map<String, PmRepository.Project> projects = new LinkedHashMap<String, PmRepository.Project>();
    private Map<String, PmRepository.Access> access = new LinkedHashMap<String, PmRepository.Access>();
    private Map<String, PmRepository.Group> groups = new LinkedHashMap<String, PmRepository.Group>();
    private Map<String, PmRepository.GroupUser> groupUsers = new LinkedHashMap<String, PmRepository.GroupUser>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.UserResource instance) {
      Objects.requireNonNull(instance, "instance");
      user(instance.getUser());
      putAllProjects(instance.getProjects());
      putAllAccess(instance.getAccess());
      putAllGroups(instance.getGroups());
      putAllGroupUsers(instance.getGroupUsers());
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.UserResource#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("user")
    public final Builder user(PmRepository.User user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.UserResource#getProjects() projects} map.
     * @param key The key in the projects map
     * @param value The associated value in the projects map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProjects(String key, PmRepository.Project value) {
      this.projects.put(
          Objects.requireNonNull(key, "projects key"),
          Objects.requireNonNull(value, "projects value"));
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.UserResource#getProjects() projects} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProjects(Map.Entry<String, ? extends PmRepository.Project> entry) {
      String k = entry.getKey();
      PmRepository.Project v = entry.getValue();
      this.projects.put(
          Objects.requireNonNull(k, "projects key"),
          Objects.requireNonNull(v, "projects value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PmRepository.UserResource#getProjects() projects} map. Nulls are not permitted
     * @param entries The entries that will be added to the projects map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("projects")
    public final Builder projects(Map<String, ? extends PmRepository.Project> entries) {
      this.projects.clear();
      return putAllProjects(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PmRepository.UserResource#getProjects() projects} map. Nulls are not permitted
     * @param entries The entries that will be added to the projects map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllProjects(Map<String, ? extends PmRepository.Project> entries) {
      for (Map.Entry<String, ? extends PmRepository.Project> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.Project v = e.getValue();
        this.projects.put(
            Objects.requireNonNull(k, "projects key"),
            Objects.requireNonNull(v, "projects value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.UserResource#getAccess() access} map.
     * @param key The key in the access map
     * @param value The associated value in the access map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAccess(String key, PmRepository.Access value) {
      this.access.put(
          Objects.requireNonNull(key, "access key"),
          Objects.requireNonNull(value, "access value"));
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.UserResource#getAccess() access} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAccess(Map.Entry<String, ? extends PmRepository.Access> entry) {
      String k = entry.getKey();
      PmRepository.Access v = entry.getValue();
      this.access.put(
          Objects.requireNonNull(k, "access key"),
          Objects.requireNonNull(v, "access value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PmRepository.UserResource#getAccess() access} map. Nulls are not permitted
     * @param entries The entries that will be added to the access map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("access")
    public final Builder access(Map<String, ? extends PmRepository.Access> entries) {
      this.access.clear();
      return putAllAccess(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PmRepository.UserResource#getAccess() access} map. Nulls are not permitted
     * @param entries The entries that will be added to the access map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAccess(Map<String, ? extends PmRepository.Access> entries) {
      for (Map.Entry<String, ? extends PmRepository.Access> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.Access v = e.getValue();
        this.access.put(
            Objects.requireNonNull(k, "access key"),
            Objects.requireNonNull(v, "access value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.UserResource#getGroups() groups} map.
     * @param key The key in the groups map
     * @param value The associated value in the groups map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroups(String key, PmRepository.Group value) {
      this.groups.put(
          Objects.requireNonNull(key, "groups key"),
          Objects.requireNonNull(value, "groups value"));
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.UserResource#getGroups() groups} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroups(Map.Entry<String, ? extends PmRepository.Group> entry) {
      String k = entry.getKey();
      PmRepository.Group v = entry.getValue();
      this.groups.put(
          Objects.requireNonNull(k, "groups key"),
          Objects.requireNonNull(v, "groups value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PmRepository.UserResource#getGroups() groups} map. Nulls are not permitted
     * @param entries The entries that will be added to the groups map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groups")
    public final Builder groups(Map<String, ? extends PmRepository.Group> entries) {
      this.groups.clear();
      return putAllGroups(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PmRepository.UserResource#getGroups() groups} map. Nulls are not permitted
     * @param entries The entries that will be added to the groups map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllGroups(Map<String, ? extends PmRepository.Group> entries) {
      for (Map.Entry<String, ? extends PmRepository.Group> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.Group v = e.getValue();
        this.groups.put(
            Objects.requireNonNull(k, "groups key"),
            Objects.requireNonNull(v, "groups value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.UserResource#getGroupUsers() groupUsers} map.
     * @param key The key in the groupUsers map
     * @param value The associated value in the groupUsers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroupUsers(String key, PmRepository.GroupUser value) {
      this.groupUsers.put(
          Objects.requireNonNull(key, "groupUsers key"),
          Objects.requireNonNull(value, "groupUsers value"));
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.UserResource#getGroupUsers() groupUsers} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroupUsers(Map.Entry<String, ? extends PmRepository.GroupUser> entry) {
      String k = entry.getKey();
      PmRepository.GroupUser v = entry.getValue();
      this.groupUsers.put(
          Objects.requireNonNull(k, "groupUsers key"),
          Objects.requireNonNull(v, "groupUsers value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PmRepository.UserResource#getGroupUsers() groupUsers} map. Nulls are not permitted
     * @param entries The entries that will be added to the groupUsers map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupUsers")
    public final Builder groupUsers(Map<String, ? extends PmRepository.GroupUser> entries) {
      this.groupUsers.clear();
      return putAllGroupUsers(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PmRepository.UserResource#getGroupUsers() groupUsers} map. Nulls are not permitted
     * @param entries The entries that will be added to the groupUsers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllGroupUsers(Map<String, ? extends PmRepository.GroupUser> entries) {
      for (Map.Entry<String, ? extends PmRepository.GroupUser> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.GroupUser v = e.getValue();
        this.groupUsers.put(
            Objects.requireNonNull(k, "groupUsers key"),
            Objects.requireNonNull(v, "groupUsers value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableUserResource ImmutableUserResource}.
     * @return An immutable instance of UserResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUserResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUserResource(
          user,
          createUnmodifiableMap(false, false, projects),
          createUnmodifiableMap(false, false, access),
          createUnmodifiableMap(false, false, groups),
          createUnmodifiableMap(false, false, groupUsers));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_USER) != 0) attributes.add("user");
      return "Cannot build UserResource, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
