package io.resys.hdes.projects.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRepository.User}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableUser.builder()}.
 */
@Generated(from = "PmRepository.User", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableUser implements PmRepository.User {
  private final String id;
  private final String rev;
  private final LocalDateTime created;
  private final @Nullable String externalId;
  private final @Nullable String email;
  private final String name;
  private final String token;
  private final PmRepository.UserStatus status;

  private ImmutableUser(
      String id,
      String rev,
      LocalDateTime created,
      @Nullable String externalId,
      @Nullable String email,
      String name,
      String token,
      PmRepository.UserStatus status) {
    this.id = id;
    this.rev = rev;
    this.created = created;
    this.externalId = externalId;
    this.email = email;
    this.name = name;
    this.token = token;
    this.status = status;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("rev")
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public LocalDateTime getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code externalId} attribute
   */
  @JsonProperty("externalId")
  @Override
  public Optional<String> getExternalId() {
    return Optional.ofNullable(externalId);
  }

  /**
   * @return The value of the {@code email} attribute
   */
  @JsonProperty("email")
  @Override
  public Optional<String> getEmail() {
    return Optional.ofNullable(email);
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty("token")
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("status")
  @Override
  public PmRepository.UserStatus getStatus() {
    return status;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.User#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableUser(
        newValue,
        this.rev,
        this.created,
        this.externalId,
        this.email,
        this.name,
        this.token,
        this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.User#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withRev(String value) {
    String newValue = Objects.requireNonNull(value, "rev");
    if (this.rev.equals(newValue)) return this;
    return new ImmutableUser(
        this.id,
        newValue,
        this.created,
        this.externalId,
        this.email,
        this.name,
        this.token,
        this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.User#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withCreated(LocalDateTime value) {
    if (this.created == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "created");
    return new ImmutableUser(this.id, this.rev, newValue, this.externalId, this.email, this.name, this.token, this.status);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PmRepository.User#getExternalId() externalId} attribute.
   * @param value The value for externalId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUser withExternalId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "externalId");
    if (Objects.equals(this.externalId, newValue)) return this;
    return new ImmutableUser(this.id, this.rev, this.created, newValue, this.email, this.name, this.token, this.status);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PmRepository.User#getExternalId() externalId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for externalId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUser withExternalId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.externalId, value)) return this;
    return new ImmutableUser(this.id, this.rev, this.created, value, this.email, this.name, this.token, this.status);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PmRepository.User#getEmail() email} attribute.
   * @param value The value for email
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUser withEmail(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "email");
    if (Objects.equals(this.email, newValue)) return this;
    return new ImmutableUser(this.id, this.rev, this.created, this.externalId, newValue, this.name, this.token, this.status);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PmRepository.User#getEmail() email} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for email
   * @return A modified copy of {@code this} object
   */
  public final ImmutableUser withEmail(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.email, value)) return this;
    return new ImmutableUser(this.id, this.rev, this.created, this.externalId, value, this.name, this.token, this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.User#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableUser(this.id, this.rev, this.created, this.externalId, this.email, newValue, this.token, this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.User#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withToken(String value) {
    String newValue = Objects.requireNonNull(value, "token");
    if (this.token.equals(newValue)) return this;
    return new ImmutableUser(this.id, this.rev, this.created, this.externalId, this.email, this.name, newValue, this.status);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.User#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableUser withStatus(PmRepository.UserStatus value) {
    if (this.status == value) return this;
    PmRepository.UserStatus newValue = Objects.requireNonNull(value, "status");
    if (this.status.equals(newValue)) return this;
    return new ImmutableUser(this.id, this.rev, this.created, this.externalId, this.email, this.name, this.token, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableUser} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableUser
        && equalTo((ImmutableUser) another);
  }

  private boolean equalTo(ImmutableUser another) {
    return id.equals(another.id)
        && rev.equals(another.rev)
        && created.equals(another.created)
        && Objects.equals(externalId, another.externalId)
        && Objects.equals(email, another.email)
        && name.equals(another.name)
        && token.equals(another.token)
        && status.equals(another.status);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code created}, {@code externalId}, {@code email}, {@code name}, {@code token}, {@code status}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rev.hashCode();
    h += (h << 5) + created.hashCode();
    h += (h << 5) + Objects.hashCode(externalId);
    h += (h << 5) + Objects.hashCode(email);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + token.hashCode();
    h += (h << 5) + status.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code User} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("User{");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("rev=").append(rev);
    builder.append(", ");
    builder.append("created=").append(created);
    if (externalId != null) {
      builder.append(", ");
      builder.append("externalId=").append(externalId);
    }
    if (email != null) {
      builder.append(", ");
      builder.append("email=").append(email);
    }
    builder.append(", ");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("token=").append(token);
    builder.append(", ");
    builder.append("status=").append(status);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PmRepository.User", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PmRepository.User {
    @Nullable String id;
    @Nullable String rev;
    @Nullable LocalDateTime created;
    @Nullable Optional<String> externalId = Optional.empty();
    @Nullable Optional<String> email = Optional.empty();
    @Nullable String name;
    @Nullable String token;
    @Nullable PmRepository.UserStatus status;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("rev")
    public void setRev(String rev) {
      this.rev = rev;
    }
    @JsonProperty("created")
    public void setCreated(LocalDateTime created) {
      this.created = created;
    }
    @JsonProperty("externalId")
    public void setExternalId(Optional<String> externalId) {
      this.externalId = externalId;
    }
    @JsonProperty("email")
    public void setEmail(Optional<String> email) {
      this.email = email;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("token")
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty("status")
    public void setStatus(PmRepository.UserStatus status) {
      this.status = status;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getExternalId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public PmRepository.UserStatus getStatus() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableUser fromJson(Json json) {
    ImmutableUser.Builder builder = ImmutableUser.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.externalId != null) {
      builder.externalId(json.externalId);
    }
    if (json.email != null) {
      builder.email(json.email);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.token != null) {
      builder.token(json.token);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PmRepository.User} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable User instance
   */
  public static ImmutableUser copyOf(PmRepository.User instance) {
    if (instance instanceof ImmutableUser) {
      return (ImmutableUser) instance;
    }
    return ImmutableUser.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableUser ImmutableUser}.
   * <pre>
   * ImmutableUser.builder()
   *    .id(String) // required {@link PmRepository.User#getId() id}
   *    .rev(String) // required {@link PmRepository.User#getRev() rev}
   *    .created(java.time.LocalDateTime) // required {@link PmRepository.User#getCreated() created}
   *    .externalId(String) // optional {@link PmRepository.User#getExternalId() externalId}
   *    .email(String) // optional {@link PmRepository.User#getEmail() email}
   *    .name(String) // required {@link PmRepository.User#getName() name}
   *    .token(String) // required {@link PmRepository.User#getToken() token}
   *    .status(io.resys.hdes.projects.api.PmRepository.UserStatus) // required {@link PmRepository.User#getStatus() status}
   *    .build();
   * </pre>
   * @return A new ImmutableUser builder
   */
  public static ImmutableUser.Builder builder() {
    return new ImmutableUser.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableUser ImmutableUser}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRepository.User", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_REV = 0x2L;
    private static final long INIT_BIT_CREATED = 0x4L;
    private static final long INIT_BIT_NAME = 0x8L;
    private static final long INIT_BIT_TOKEN = 0x10L;
    private static final long INIT_BIT_STATUS = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable LocalDateTime created;
    private @Nullable String externalId;
    private @Nullable String email;
    private @Nullable String name;
    private @Nullable String token;
    private @Nullable PmRepository.UserStatus status;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code User} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.User instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rev(instance.getRev());
      created(instance.getCreated());
      Optional<String> externalIdOptional = instance.getExternalId();
      if (externalIdOptional.isPresent()) {
        externalId(externalIdOptional);
      }
      Optional<String> emailOptional = instance.getEmail();
      if (emailOptional.isPresent()) {
        email(emailOptional);
      }
      name(instance.getName());
      token(instance.getToken());
      status(instance.getStatus());
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.User#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.User#getRev() rev} attribute.
     * @param rev The value for rev 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rev")
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      initBits &= ~INIT_BIT_REV;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.User#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(LocalDateTime created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.User#getExternalId() externalId} to externalId.
     * @param externalId The value for externalId
     * @return {@code this} builder for chained invocation
     */
    public final Builder externalId(String externalId) {
      this.externalId = Objects.requireNonNull(externalId, "externalId");
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.User#getExternalId() externalId} to externalId.
     * @param externalId The value for externalId
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("externalId")
    public final Builder externalId(Optional<String> externalId) {
      this.externalId = externalId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.User#getEmail() email} to email.
     * @param email The value for email
     * @return {@code this} builder for chained invocation
     */
    public final Builder email(String email) {
      this.email = Objects.requireNonNull(email, "email");
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.User#getEmail() email} to email.
     * @param email The value for email
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("email")
    public final Builder email(Optional<String> email) {
      this.email = email.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.User#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.User#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("token")
    public final Builder token(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.User#getStatus() status} attribute.
     * @param status The value for status 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(PmRepository.UserStatus status) {
      this.status = Objects.requireNonNull(status, "status");
      initBits &= ~INIT_BIT_STATUS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableUser ImmutableUser}.
     * @return An immutable instance of User
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableUser build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableUser(id, rev, created, externalId, email, name, token, status);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_REV) != 0) attributes.add("rev");
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_TOKEN) != 0) attributes.add("token");
      if ((initBits & INIT_BIT_STATUS) != 0) attributes.add("status");
      return "Cannot build User, some of required attributes are not set " + attributes;
    }
  }
}
