package io.resys.hdes.projects.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRepository.TokenResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTokenResource.builder()}.
 */
@Generated(from = "PmRepository.TokenResource", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableTokenResource implements PmRepository.TokenResource {
  private final String name;
  private final @Nullable String email;
  private final String id;
  private final List<PmRepository.TokenAccessResource> access;

  private ImmutableTokenResource(
      String name,
      @Nullable String email,
      String id,
      List<PmRepository.TokenAccessResource> access) {
    this.name = name;
    this.email = email;
    this.id = id;
    this.access = access;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code email} attribute
   */
  @JsonProperty("email")
  @Override
  public Optional<String> getEmail() {
    return Optional.ofNullable(email);
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code access} attribute
   */
  @JsonProperty("access")
  @Override
  public List<PmRepository.TokenAccessResource> getAccess() {
    return access;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.TokenResource#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenResource withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableTokenResource(newValue, this.email, this.id, this.access);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PmRepository.TokenResource#getEmail() email} attribute.
   * @param value The value for email
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTokenResource withEmail(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "email");
    if (Objects.equals(this.email, newValue)) return this;
    return new ImmutableTokenResource(this.name, newValue, this.id, this.access);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PmRepository.TokenResource#getEmail() email} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for email
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTokenResource withEmail(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.email, value)) return this;
    return new ImmutableTokenResource(this.name, value, this.id, this.access);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.TokenResource#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTokenResource withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableTokenResource(this.name, this.email, newValue, this.access);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.TokenResource#getAccess() access}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTokenResource withAccess(PmRepository.TokenAccessResource... elements) {
    List<PmRepository.TokenAccessResource> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableTokenResource(this.name, this.email, this.id, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.TokenResource#getAccess() access}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of access elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTokenResource withAccess(Iterable<? extends PmRepository.TokenAccessResource> elements) {
    if (this.access == elements) return this;
    List<PmRepository.TokenAccessResource> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableTokenResource(this.name, this.email, this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTokenResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTokenResource
        && equalTo((ImmutableTokenResource) another);
  }

  private boolean equalTo(ImmutableTokenResource another) {
    return name.equals(another.name)
        && Objects.equals(email, another.email)
        && id.equals(another.id)
        && access.equals(another.access);
  }

  /**
   * Computes a hash code from attributes: {@code name}, {@code email}, {@code id}, {@code access}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + name.hashCode();
    h += (h << 5) + Objects.hashCode(email);
    h += (h << 5) + id.hashCode();
    h += (h << 5) + access.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TokenResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("TokenResource{");
    builder.append("name=").append(name);
    if (email != null) {
      builder.append(", ");
      builder.append("email=").append(email);
    }
    builder.append(", ");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("access=").append(access);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PmRepository.TokenResource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PmRepository.TokenResource {
    @Nullable String name;
    @Nullable Optional<String> email = Optional.empty();
    @Nullable String id;
    @Nullable List<PmRepository.TokenAccessResource> access = Collections.emptyList();
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("email")
    public void setEmail(Optional<String> email) {
      this.email = email;
    }
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("access")
    public void setAccess(List<PmRepository.TokenAccessResource> access) {
      this.access = access;
    }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public List<PmRepository.TokenAccessResource> getAccess() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTokenResource fromJson(Json json) {
    ImmutableTokenResource.Builder builder = ImmutableTokenResource.builder();
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.email != null) {
      builder.email(json.email);
    }
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.access != null) {
      builder.addAllAccess(json.access);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PmRepository.TokenResource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TokenResource instance
   */
  public static ImmutableTokenResource copyOf(PmRepository.TokenResource instance) {
    if (instance instanceof ImmutableTokenResource) {
      return (ImmutableTokenResource) instance;
    }
    return ImmutableTokenResource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTokenResource ImmutableTokenResource}.
   * <pre>
   * ImmutableTokenResource.builder()
   *    .name(String) // required {@link PmRepository.TokenResource#getName() name}
   *    .email(String) // optional {@link PmRepository.TokenResource#getEmail() email}
   *    .id(String) // required {@link PmRepository.TokenResource#getId() id}
   *    .addAccess|addAllAccess(io.resys.hdes.projects.api.PmRepository.TokenAccessResource) // {@link PmRepository.TokenResource#getAccess() access} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTokenResource builder
   */
  public static ImmutableTokenResource.Builder builder() {
    return new ImmutableTokenResource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTokenResource ImmutableTokenResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRepository.TokenResource", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String name;
    private @Nullable String email;
    private @Nullable String id;
    private List<PmRepository.TokenAccessResource> access = new ArrayList<PmRepository.TokenAccessResource>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TokenResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.TokenResource instance) {
      Objects.requireNonNull(instance, "instance");
      name(instance.getName());
      Optional<String> emailOptional = instance.getEmail();
      if (emailOptional.isPresent()) {
        email(emailOptional);
      }
      id(instance.getId());
      addAllAccess(instance.getAccess());
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.TokenResource#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.TokenResource#getEmail() email} to email.
     * @param email The value for email
     * @return {@code this} builder for chained invocation
     */
    public final Builder email(String email) {
      this.email = Objects.requireNonNull(email, "email");
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.TokenResource#getEmail() email} to email.
     * @param email The value for email
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("email")
    public final Builder email(Optional<String> email) {
      this.email = email.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.TokenResource#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Adds one element to {@link PmRepository.TokenResource#getAccess() access} list.
     * @param element A access element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAccess(PmRepository.TokenAccessResource element) {
      this.access.add(Objects.requireNonNull(element, "access element"));
      return this;
    }

    /**
     * Adds elements to {@link PmRepository.TokenResource#getAccess() access} list.
     * @param elements An array of access elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAccess(PmRepository.TokenAccessResource... elements) {
      for (PmRepository.TokenAccessResource element : elements) {
        this.access.add(Objects.requireNonNull(element, "access element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PmRepository.TokenResource#getAccess() access} list.
     * @param elements An iterable of access elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("access")
    public final Builder access(Iterable<? extends PmRepository.TokenAccessResource> elements) {
      this.access.clear();
      return addAllAccess(elements);
    }

    /**
     * Adds elements to {@link PmRepository.TokenResource#getAccess() access} list.
     * @param elements An iterable of access elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAccess(Iterable<? extends PmRepository.TokenAccessResource> elements) {
      for (PmRepository.TokenAccessResource element : elements) {
        this.access.add(Objects.requireNonNull(element, "access element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableTokenResource ImmutableTokenResource}.
     * @return An immutable instance of TokenResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTokenResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTokenResource(name, email, id, createUnmodifiableList(true, access));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      return "Cannot build TokenResource, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
