package io.resys.hdes.projects.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRevException.RevisionConflict}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRevisionConflict.builder()}.
 */
@Generated(from = "PmRevException.RevisionConflict", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableRevisionConflict
    implements PmRevException.RevisionConflict {
  private final String id;
  private final String rev;
  private final String revToUpdate;
  private final PmRevException.RevisionType type;

  private ImmutableRevisionConflict(
      String id,
      String rev,
      String revToUpdate,
      PmRevException.RevisionType type) {
    this.id = id;
    this.rev = rev;
    this.revToUpdate = revToUpdate;
    this.type = type;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code revToUpdate} attribute
   */
  @Override
  public String getRevToUpdate() {
    return revToUpdate;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public PmRevException.RevisionType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRevException.RevisionConflict#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRevisionConflict withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableRevisionConflict(newValue, this.rev, this.revToUpdate, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRevException.RevisionConflict#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRevisionConflict withRev(String value) {
    String newValue = Objects.requireNonNull(value, "rev");
    if (this.rev.equals(newValue)) return this;
    return new ImmutableRevisionConflict(this.id, newValue, this.revToUpdate, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRevException.RevisionConflict#getRevToUpdate() revToUpdate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for revToUpdate
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRevisionConflict withRevToUpdate(String value) {
    String newValue = Objects.requireNonNull(value, "revToUpdate");
    if (this.revToUpdate.equals(newValue)) return this;
    return new ImmutableRevisionConflict(this.id, this.rev, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRevException.RevisionConflict#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRevisionConflict withType(PmRevException.RevisionType value) {
    if (this.type == value) return this;
    PmRevException.RevisionType newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableRevisionConflict(this.id, this.rev, this.revToUpdate, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRevisionConflict} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRevisionConflict
        && equalTo((ImmutableRevisionConflict) another);
  }

  private boolean equalTo(ImmutableRevisionConflict another) {
    return id.equals(another.id)
        && rev.equals(another.rev)
        && revToUpdate.equals(another.revToUpdate)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code revToUpdate}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rev.hashCode();
    h += (h << 5) + revToUpdate.hashCode();
    h += (h << 5) + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RevisionConflict} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "RevisionConflict{"
        + "id=" + id
        + ", rev=" + rev
        + ", revToUpdate=" + revToUpdate
        + ", type=" + type
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link PmRevException.RevisionConflict} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RevisionConflict instance
   */
  public static ImmutableRevisionConflict copyOf(PmRevException.RevisionConflict instance) {
    if (instance instanceof ImmutableRevisionConflict) {
      return (ImmutableRevisionConflict) instance;
    }
    return ImmutableRevisionConflict.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRevisionConflict ImmutableRevisionConflict}.
   * <pre>
   * ImmutableRevisionConflict.builder()
   *    .id(String) // required {@link PmRevException.RevisionConflict#getId() id}
   *    .rev(String) // required {@link PmRevException.RevisionConflict#getRev() rev}
   *    .revToUpdate(String) // required {@link PmRevException.RevisionConflict#getRevToUpdate() revToUpdate}
   *    .type(io.resys.hdes.projects.api.PmRevException.RevisionType) // required {@link PmRevException.RevisionConflict#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableRevisionConflict builder
   */
  public static ImmutableRevisionConflict.Builder builder() {
    return new ImmutableRevisionConflict.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRevisionConflict ImmutableRevisionConflict}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRevException.RevisionConflict", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_REV = 0x2L;
    private static final long INIT_BIT_REV_TO_UPDATE = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable String revToUpdate;
    private @Nullable PmRevException.RevisionType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RevisionConflict} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRevException.RevisionConflict instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rev(instance.getRev());
      revToUpdate(instance.getRevToUpdate());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link PmRevException.RevisionConflict#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRevException.RevisionConflict#getRev() rev} attribute.
     * @param rev The value for rev 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      initBits &= ~INIT_BIT_REV;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRevException.RevisionConflict#getRevToUpdate() revToUpdate} attribute.
     * @param revToUpdate The value for revToUpdate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder revToUpdate(String revToUpdate) {
      this.revToUpdate = Objects.requireNonNull(revToUpdate, "revToUpdate");
      initBits &= ~INIT_BIT_REV_TO_UPDATE;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRevException.RevisionConflict#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder type(PmRevException.RevisionType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRevisionConflict ImmutableRevisionConflict}.
     * @return An immutable instance of RevisionConflict
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRevisionConflict build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRevisionConflict(id, rev, revToUpdate, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_REV) != 0) attributes.add("rev");
      if ((initBits & INIT_BIT_REV_TO_UPDATE) != 0) attributes.add("revToUpdate");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build RevisionConflict, some of required attributes are not set " + attributes;
    }
  }
}
