package io.resys.hdes.projects.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRepository.ProjectResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProjectResource.builder()}.
 */
@Generated(from = "PmRepository.ProjectResource", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableProjectResource implements PmRepository.ProjectResource {
  private final PmRepository.Project project;
  private final Map<String, PmRepository.User> users;
  private final Map<String, PmRepository.Access> access;
  private final Map<String, PmRepository.Group> groups;
  private final Map<String, PmRepository.GroupUser> groupUsers;

  private ImmutableProjectResource(
      PmRepository.Project project,
      Map<String, PmRepository.User> users,
      Map<String, PmRepository.Access> access,
      Map<String, PmRepository.Group> groups,
      Map<String, PmRepository.GroupUser> groupUsers) {
    this.project = project;
    this.users = users;
    this.access = access;
    this.groups = groups;
    this.groupUsers = groupUsers;
  }

  /**
   * @return The value of the {@code project} attribute
   */
  @JsonProperty("project")
  @Override
  public PmRepository.Project getProject() {
    return project;
  }

  /**
   * @return The value of the {@code users} attribute
   */
  @JsonProperty("users")
  @Override
  public Map<String, PmRepository.User> getUsers() {
    return users;
  }

  /**
   * @return The value of the {@code access} attribute
   */
  @JsonProperty("access")
  @Override
  public Map<String, PmRepository.Access> getAccess() {
    return access;
  }

  /**
   * @return The value of the {@code groups} attribute
   */
  @JsonProperty("groups")
  @Override
  public Map<String, PmRepository.Group> getGroups() {
    return groups;
  }

  /**
   * @return The value of the {@code groupUsers} attribute
   */
  @JsonProperty("groupUsers")
  @Override
  public Map<String, PmRepository.GroupUser> getGroupUsers() {
    return groupUsers;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.ProjectResource#getProject() project} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for project
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProjectResource withProject(PmRepository.Project value) {
    if (this.project == value) return this;
    PmRepository.Project newValue = Objects.requireNonNull(value, "project");
    return new ImmutableProjectResource(newValue, this.users, this.access, this.groups, this.groupUsers);
  }

  /**
   * Copy the current immutable object by replacing the {@link PmRepository.ProjectResource#getUsers() users} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the users map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProjectResource withUsers(Map<String, ? extends PmRepository.User> entries) {
    if (this.users == entries) return this;
    Map<String, PmRepository.User> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableProjectResource(this.project, newValue, this.access, this.groups, this.groupUsers);
  }

  /**
   * Copy the current immutable object by replacing the {@link PmRepository.ProjectResource#getAccess() access} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the access map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProjectResource withAccess(Map<String, ? extends PmRepository.Access> entries) {
    if (this.access == entries) return this;
    Map<String, PmRepository.Access> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableProjectResource(this.project, this.users, newValue, this.groups, this.groupUsers);
  }

  /**
   * Copy the current immutable object by replacing the {@link PmRepository.ProjectResource#getGroups() groups} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the groups map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProjectResource withGroups(Map<String, ? extends PmRepository.Group> entries) {
    if (this.groups == entries) return this;
    Map<String, PmRepository.Group> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableProjectResource(this.project, this.users, this.access, newValue, this.groupUsers);
  }

  /**
   * Copy the current immutable object by replacing the {@link PmRepository.ProjectResource#getGroupUsers() groupUsers} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the groupUsers map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableProjectResource withGroupUsers(Map<String, ? extends PmRepository.GroupUser> entries) {
    if (this.groupUsers == entries) return this;
    Map<String, PmRepository.GroupUser> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableProjectResource(this.project, this.users, this.access, this.groups, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProjectResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProjectResource
        && equalTo((ImmutableProjectResource) another);
  }

  private boolean equalTo(ImmutableProjectResource another) {
    return project.equals(another.project)
        && users.equals(another.users)
        && access.equals(another.access)
        && groups.equals(another.groups)
        && groupUsers.equals(another.groupUsers);
  }

  /**
   * Computes a hash code from attributes: {@code project}, {@code users}, {@code access}, {@code groups}, {@code groupUsers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + project.hashCode();
    h += (h << 5) + users.hashCode();
    h += (h << 5) + access.hashCode();
    h += (h << 5) + groups.hashCode();
    h += (h << 5) + groupUsers.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ProjectResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ProjectResource{"
        + "project=" + project
        + ", users=" + users
        + ", access=" + access
        + ", groups=" + groups
        + ", groupUsers=" + groupUsers
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PmRepository.ProjectResource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PmRepository.ProjectResource {
    @Nullable PmRepository.Project project;
    @Nullable Map<String, PmRepository.User> users = Collections.emptyMap();
    @Nullable Map<String, PmRepository.Access> access = Collections.emptyMap();
    @Nullable Map<String, PmRepository.Group> groups = Collections.emptyMap();
    @Nullable Map<String, PmRepository.GroupUser> groupUsers = Collections.emptyMap();
    @JsonProperty("project")
    public void setProject(PmRepository.Project project) {
      this.project = project;
    }
    @JsonProperty("users")
    public void setUsers(Map<String, PmRepository.User> users) {
      this.users = users;
    }
    @JsonProperty("access")
    public void setAccess(Map<String, PmRepository.Access> access) {
      this.access = access;
    }
    @JsonProperty("groups")
    public void setGroups(Map<String, PmRepository.Group> groups) {
      this.groups = groups;
    }
    @JsonProperty("groupUsers")
    public void setGroupUsers(Map<String, PmRepository.GroupUser> groupUsers) {
      this.groupUsers = groupUsers;
    }
    @Override
    public PmRepository.Project getProject() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PmRepository.User> getUsers() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PmRepository.Access> getAccess() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PmRepository.Group> getGroups() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PmRepository.GroupUser> getGroupUsers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableProjectResource fromJson(Json json) {
    ImmutableProjectResource.Builder builder = ImmutableProjectResource.builder();
    if (json.project != null) {
      builder.project(json.project);
    }
    if (json.users != null) {
      builder.putAllUsers(json.users);
    }
    if (json.access != null) {
      builder.putAllAccess(json.access);
    }
    if (json.groups != null) {
      builder.putAllGroups(json.groups);
    }
    if (json.groupUsers != null) {
      builder.putAllGroupUsers(json.groupUsers);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PmRepository.ProjectResource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ProjectResource instance
   */
  public static ImmutableProjectResource copyOf(PmRepository.ProjectResource instance) {
    if (instance instanceof ImmutableProjectResource) {
      return (ImmutableProjectResource) instance;
    }
    return ImmutableProjectResource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProjectResource ImmutableProjectResource}.
   * <pre>
   * ImmutableProjectResource.builder()
   *    .project(io.resys.hdes.projects.api.PmRepository.Project) // required {@link PmRepository.ProjectResource#getProject() project}
   *    .putUsers|putAllUsers(String =&gt; io.resys.hdes.projects.api.PmRepository.User) // {@link PmRepository.ProjectResource#getUsers() users} mappings
   *    .putAccess|putAllAccess(String =&gt; io.resys.hdes.projects.api.PmRepository.Access) // {@link PmRepository.ProjectResource#getAccess() access} mappings
   *    .putGroups|putAllGroups(String =&gt; io.resys.hdes.projects.api.PmRepository.Group) // {@link PmRepository.ProjectResource#getGroups() groups} mappings
   *    .putGroupUsers|putAllGroupUsers(String =&gt; io.resys.hdes.projects.api.PmRepository.GroupUser) // {@link PmRepository.ProjectResource#getGroupUsers() groupUsers} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableProjectResource builder
   */
  public static ImmutableProjectResource.Builder builder() {
    return new ImmutableProjectResource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProjectResource ImmutableProjectResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRepository.ProjectResource", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_PROJECT = 0x1L;
    private long initBits = 0x1L;

    private @Nullable PmRepository.Project project;
    private Map<String, PmRepository.User> users = new LinkedHashMap<String, PmRepository.User>();
    private Map<String, PmRepository.Access> access = new LinkedHashMap<String, PmRepository.Access>();
    private Map<String, PmRepository.Group> groups = new LinkedHashMap<String, PmRepository.Group>();
    private Map<String, PmRepository.GroupUser> groupUsers = new LinkedHashMap<String, PmRepository.GroupUser>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ProjectResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.ProjectResource instance) {
      Objects.requireNonNull(instance, "instance");
      project(instance.getProject());
      putAllUsers(instance.getUsers());
      putAllAccess(instance.getAccess());
      putAllGroups(instance.getGroups());
      putAllGroupUsers(instance.getGroupUsers());
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.ProjectResource#getProject() project} attribute.
     * @param project The value for project 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("project")
    public final Builder project(PmRepository.Project project) {
      this.project = Objects.requireNonNull(project, "project");
      initBits &= ~INIT_BIT_PROJECT;
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.ProjectResource#getUsers() users} map.
     * @param key The key in the users map
     * @param value The associated value in the users map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putUsers(String key, PmRepository.User value) {
      this.users.put(
          Objects.requireNonNull(key, "users key"),
          Objects.requireNonNull(value, "users value"));
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.ProjectResource#getUsers() users} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putUsers(Map.Entry<String, ? extends PmRepository.User> entry) {
      String k = entry.getKey();
      PmRepository.User v = entry.getValue();
      this.users.put(
          Objects.requireNonNull(k, "users key"),
          Objects.requireNonNull(v, "users value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PmRepository.ProjectResource#getUsers() users} map. Nulls are not permitted
     * @param entries The entries that will be added to the users map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("users")
    public final Builder users(Map<String, ? extends PmRepository.User> entries) {
      this.users.clear();
      return putAllUsers(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PmRepository.ProjectResource#getUsers() users} map. Nulls are not permitted
     * @param entries The entries that will be added to the users map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllUsers(Map<String, ? extends PmRepository.User> entries) {
      for (Map.Entry<String, ? extends PmRepository.User> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.User v = e.getValue();
        this.users.put(
            Objects.requireNonNull(k, "users key"),
            Objects.requireNonNull(v, "users value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.ProjectResource#getAccess() access} map.
     * @param key The key in the access map
     * @param value The associated value in the access map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAccess(String key, PmRepository.Access value) {
      this.access.put(
          Objects.requireNonNull(key, "access key"),
          Objects.requireNonNull(value, "access value"));
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.ProjectResource#getAccess() access} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAccess(Map.Entry<String, ? extends PmRepository.Access> entry) {
      String k = entry.getKey();
      PmRepository.Access v = entry.getValue();
      this.access.put(
          Objects.requireNonNull(k, "access key"),
          Objects.requireNonNull(v, "access value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PmRepository.ProjectResource#getAccess() access} map. Nulls are not permitted
     * @param entries The entries that will be added to the access map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("access")
    public final Builder access(Map<String, ? extends PmRepository.Access> entries) {
      this.access.clear();
      return putAllAccess(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PmRepository.ProjectResource#getAccess() access} map. Nulls are not permitted
     * @param entries The entries that will be added to the access map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAccess(Map<String, ? extends PmRepository.Access> entries) {
      for (Map.Entry<String, ? extends PmRepository.Access> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.Access v = e.getValue();
        this.access.put(
            Objects.requireNonNull(k, "access key"),
            Objects.requireNonNull(v, "access value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.ProjectResource#getGroups() groups} map.
     * @param key The key in the groups map
     * @param value The associated value in the groups map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroups(String key, PmRepository.Group value) {
      this.groups.put(
          Objects.requireNonNull(key, "groups key"),
          Objects.requireNonNull(value, "groups value"));
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.ProjectResource#getGroups() groups} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroups(Map.Entry<String, ? extends PmRepository.Group> entry) {
      String k = entry.getKey();
      PmRepository.Group v = entry.getValue();
      this.groups.put(
          Objects.requireNonNull(k, "groups key"),
          Objects.requireNonNull(v, "groups value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PmRepository.ProjectResource#getGroups() groups} map. Nulls are not permitted
     * @param entries The entries that will be added to the groups map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groups")
    public final Builder groups(Map<String, ? extends PmRepository.Group> entries) {
      this.groups.clear();
      return putAllGroups(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PmRepository.ProjectResource#getGroups() groups} map. Nulls are not permitted
     * @param entries The entries that will be added to the groups map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllGroups(Map<String, ? extends PmRepository.Group> entries) {
      for (Map.Entry<String, ? extends PmRepository.Group> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.Group v = e.getValue();
        this.groups.put(
            Objects.requireNonNull(k, "groups key"),
            Objects.requireNonNull(v, "groups value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.ProjectResource#getGroupUsers() groupUsers} map.
     * @param key The key in the groupUsers map
     * @param value The associated value in the groupUsers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroupUsers(String key, PmRepository.GroupUser value) {
      this.groupUsers.put(
          Objects.requireNonNull(key, "groupUsers key"),
          Objects.requireNonNull(value, "groupUsers value"));
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.ProjectResource#getGroupUsers() groupUsers} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroupUsers(Map.Entry<String, ? extends PmRepository.GroupUser> entry) {
      String k = entry.getKey();
      PmRepository.GroupUser v = entry.getValue();
      this.groupUsers.put(
          Objects.requireNonNull(k, "groupUsers key"),
          Objects.requireNonNull(v, "groupUsers value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PmRepository.ProjectResource#getGroupUsers() groupUsers} map. Nulls are not permitted
     * @param entries The entries that will be added to the groupUsers map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupUsers")
    public final Builder groupUsers(Map<String, ? extends PmRepository.GroupUser> entries) {
      this.groupUsers.clear();
      return putAllGroupUsers(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PmRepository.ProjectResource#getGroupUsers() groupUsers} map. Nulls are not permitted
     * @param entries The entries that will be added to the groupUsers map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllGroupUsers(Map<String, ? extends PmRepository.GroupUser> entries) {
      for (Map.Entry<String, ? extends PmRepository.GroupUser> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.GroupUser v = e.getValue();
        this.groupUsers.put(
            Objects.requireNonNull(k, "groupUsers key"),
            Objects.requireNonNull(v, "groupUsers value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableProjectResource ImmutableProjectResource}.
     * @return An immutable instance of ProjectResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProjectResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProjectResource(
          project,
          createUnmodifiableMap(false, false, users),
          createUnmodifiableMap(false, false, access),
          createUnmodifiableMap(false, false, groups),
          createUnmodifiableMap(false, false, groupUsers));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_PROJECT) != 0) attributes.add("project");
      return "Cannot build ProjectResource, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
