package io.resys.hdes.projects.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRepository.Project}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableProject.builder()}.
 */
@Generated(from = "PmRepository.Project", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableProject implements PmRepository.Project {
  private final String id;
  private final String rev;
  private final String name;
  private final LocalDateTime created;

  private ImmutableProject(String id, String rev, String name, LocalDateTime created) {
    this.id = id;
    this.rev = rev;
    this.name = name;
    this.created = created;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("rev")
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public LocalDateTime getCreated() {
    return created;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Project#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProject withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableProject(newValue, this.rev, this.name, this.created);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Project#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProject withRev(String value) {
    String newValue = Objects.requireNonNull(value, "rev");
    if (this.rev.equals(newValue)) return this;
    return new ImmutableProject(this.id, newValue, this.name, this.created);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Project#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProject withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableProject(this.id, this.rev, newValue, this.created);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Project#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableProject withCreated(LocalDateTime value) {
    if (this.created == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "created");
    return new ImmutableProject(this.id, this.rev, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableProject} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableProject
        && equalTo((ImmutableProject) another);
  }

  private boolean equalTo(ImmutableProject another) {
    return id.equals(another.id)
        && rev.equals(another.rev)
        && name.equals(another.name)
        && created.equals(another.created);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code name}, {@code created}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rev.hashCode();
    h += (h << 5) + name.hashCode();
    h += (h << 5) + created.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Project} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Project{"
        + "id=" + id
        + ", rev=" + rev
        + ", name=" + name
        + ", created=" + created
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PmRepository.Project", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PmRepository.Project {
    @Nullable String id;
    @Nullable String rev;
    @Nullable String name;
    @Nullable LocalDateTime created;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("rev")
    public void setRev(String rev) {
      this.rev = rev;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("created")
    public void setCreated(LocalDateTime created) {
      this.created = created;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getCreated() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableProject fromJson(Json json) {
    ImmutableProject.Builder builder = ImmutableProject.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PmRepository.Project} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Project instance
   */
  public static ImmutableProject copyOf(PmRepository.Project instance) {
    if (instance instanceof ImmutableProject) {
      return (ImmutableProject) instance;
    }
    return ImmutableProject.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableProject ImmutableProject}.
   * <pre>
   * ImmutableProject.builder()
   *    .id(String) // required {@link PmRepository.Project#getId() id}
   *    .rev(String) // required {@link PmRepository.Project#getRev() rev}
   *    .name(String) // required {@link PmRepository.Project#getName() name}
   *    .created(java.time.LocalDateTime) // required {@link PmRepository.Project#getCreated() created}
   *    .build();
   * </pre>
   * @return A new ImmutableProject builder
   */
  public static ImmutableProject.Builder builder() {
    return new ImmutableProject.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableProject ImmutableProject}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRepository.Project", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_REV = 0x2L;
    private static final long INIT_BIT_NAME = 0x4L;
    private static final long INIT_BIT_CREATED = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable String name;
    private @Nullable LocalDateTime created;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Project} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.Project instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rev(instance.getRev());
      name(instance.getName());
      created(instance.getCreated());
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Project#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Project#getRev() rev} attribute.
     * @param rev The value for rev 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rev")
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      initBits &= ~INIT_BIT_REV;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Project#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Project#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(LocalDateTime created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Builds a new {@link ImmutableProject ImmutableProject}.
     * @return An immutable instance of Project
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableProject build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableProject(id, rev, name, created);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_REV) != 0) attributes.add("rev");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      return "Cannot build Project, some of required attributes are not set " + attributes;
    }
  }
}
