package io.resys.hdes.projects.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRepository.GroupUser}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGroupUser.builder()}.
 */
@Generated(from = "PmRepository.GroupUser", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableGroupUser implements PmRepository.GroupUser {
  private final String id;
  private final String rev;
  private final LocalDateTime created;
  private final String userId;
  private final String groupId;

  private ImmutableGroupUser(
      String id,
      String rev,
      LocalDateTime created,
      String userId,
      String groupId) {
    this.id = id;
    this.rev = rev;
    this.created = created;
    this.userId = userId;
    this.groupId = groupId;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("rev")
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public LocalDateTime getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("userId")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code groupId} attribute
   */
  @JsonProperty("groupId")
  @Override
  public String getGroupId() {
    return groupId;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.GroupUser#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupUser withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableGroupUser(newValue, this.rev, this.created, this.userId, this.groupId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.GroupUser#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupUser withRev(String value) {
    String newValue = Objects.requireNonNull(value, "rev");
    if (this.rev.equals(newValue)) return this;
    return new ImmutableGroupUser(this.id, newValue, this.created, this.userId, this.groupId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.GroupUser#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupUser withCreated(LocalDateTime value) {
    if (this.created == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "created");
    return new ImmutableGroupUser(this.id, this.rev, newValue, this.userId, this.groupId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.GroupUser#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupUser withUserId(String value) {
    String newValue = Objects.requireNonNull(value, "userId");
    if (this.userId.equals(newValue)) return this;
    return new ImmutableGroupUser(this.id, this.rev, this.created, newValue, this.groupId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.GroupUser#getGroupId() groupId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for groupId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupUser withGroupId(String value) {
    String newValue = Objects.requireNonNull(value, "groupId");
    if (this.groupId.equals(newValue)) return this;
    return new ImmutableGroupUser(this.id, this.rev, this.created, this.userId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGroupUser} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGroupUser
        && equalTo((ImmutableGroupUser) another);
  }

  private boolean equalTo(ImmutableGroupUser another) {
    return id.equals(another.id)
        && rev.equals(another.rev)
        && created.equals(another.created)
        && userId.equals(another.userId)
        && groupId.equals(another.groupId);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code created}, {@code userId}, {@code groupId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rev.hashCode();
    h += (h << 5) + created.hashCode();
    h += (h << 5) + userId.hashCode();
    h += (h << 5) + groupId.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GroupUser} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GroupUser{"
        + "id=" + id
        + ", rev=" + rev
        + ", created=" + created
        + ", userId=" + userId
        + ", groupId=" + groupId
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PmRepository.GroupUser", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PmRepository.GroupUser {
    @Nullable String id;
    @Nullable String rev;
    @Nullable LocalDateTime created;
    @Nullable String userId;
    @Nullable String groupId;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("rev")
    public void setRev(String rev) {
      this.rev = rev;
    }
    @JsonProperty("created")
    public void setCreated(LocalDateTime created) {
      this.created = created;
    }
    @JsonProperty("userId")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty("groupId")
    public void setGroupId(String groupId) {
      this.groupId = groupId;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public String getGroupId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableGroupUser fromJson(Json json) {
    ImmutableGroupUser.Builder builder = ImmutableGroupUser.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.userId != null) {
      builder.userId(json.userId);
    }
    if (json.groupId != null) {
      builder.groupId(json.groupId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PmRepository.GroupUser} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GroupUser instance
   */
  public static ImmutableGroupUser copyOf(PmRepository.GroupUser instance) {
    if (instance instanceof ImmutableGroupUser) {
      return (ImmutableGroupUser) instance;
    }
    return ImmutableGroupUser.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGroupUser ImmutableGroupUser}.
   * <pre>
   * ImmutableGroupUser.builder()
   *    .id(String) // required {@link PmRepository.GroupUser#getId() id}
   *    .rev(String) // required {@link PmRepository.GroupUser#getRev() rev}
   *    .created(java.time.LocalDateTime) // required {@link PmRepository.GroupUser#getCreated() created}
   *    .userId(String) // required {@link PmRepository.GroupUser#getUserId() userId}
   *    .groupId(String) // required {@link PmRepository.GroupUser#getGroupId() groupId}
   *    .build();
   * </pre>
   * @return A new ImmutableGroupUser builder
   */
  public static ImmutableGroupUser.Builder builder() {
    return new ImmutableGroupUser.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGroupUser ImmutableGroupUser}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRepository.GroupUser", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_REV = 0x2L;
    private static final long INIT_BIT_CREATED = 0x4L;
    private static final long INIT_BIT_USER_ID = 0x8L;
    private static final long INIT_BIT_GROUP_ID = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable LocalDateTime created;
    private @Nullable String userId;
    private @Nullable String groupId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GroupUser} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.GroupUser instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rev(instance.getRev());
      created(instance.getCreated());
      userId(instance.getUserId());
      groupId(instance.getGroupId());
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.GroupUser#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.GroupUser#getRev() rev} attribute.
     * @param rev The value for rev 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rev")
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      initBits &= ~INIT_BIT_REV;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.GroupUser#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(LocalDateTime created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.GroupUser#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userId")
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.GroupUser#getGroupId() groupId} attribute.
     * @param groupId The value for groupId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupId")
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      initBits &= ~INIT_BIT_GROUP_ID;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGroupUser ImmutableGroupUser}.
     * @return An immutable instance of GroupUser
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGroupUser build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGroupUser(id, rev, created, userId, groupId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_REV) != 0) attributes.add("rev");
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      if ((initBits & INIT_BIT_USER_ID) != 0) attributes.add("userId");
      if ((initBits & INIT_BIT_GROUP_ID) != 0) attributes.add("groupId");
      return "Cannot build GroupUser, some of required attributes are not set " + attributes;
    }
  }
}
