package io.resys.hdes.projects.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRepository.GroupResource}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGroupResource.builder()}.
 */
@Generated(from = "PmRepository.GroupResource", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableGroupResource implements PmRepository.GroupResource {
  private final PmRepository.Group group;
  private final Map<String, PmRepository.User> users;
  private final Map<String, PmRepository.Project> projects;
  private final Map<String, PmRepository.Access> access;
  private final Map<String, PmRepository.GroupUser> groupUser;

  private ImmutableGroupResource(
      PmRepository.Group group,
      Map<String, PmRepository.User> users,
      Map<String, PmRepository.Project> projects,
      Map<String, PmRepository.Access> access,
      Map<String, PmRepository.GroupUser> groupUser) {
    this.group = group;
    this.users = users;
    this.projects = projects;
    this.access = access;
    this.groupUser = groupUser;
  }

  /**
   * @return The value of the {@code group} attribute
   */
  @JsonProperty("group")
  @Override
  public PmRepository.Group getGroup() {
    return group;
  }

  /**
   * @return The value of the {@code users} attribute
   */
  @JsonProperty("users")
  @Override
  public Map<String, PmRepository.User> getUsers() {
    return users;
  }

  /**
   * @return The value of the {@code projects} attribute
   */
  @JsonProperty("projects")
  @Override
  public Map<String, PmRepository.Project> getProjects() {
    return projects;
  }

  /**
   * @return The value of the {@code access} attribute
   */
  @JsonProperty("access")
  @Override
  public Map<String, PmRepository.Access> getAccess() {
    return access;
  }

  /**
   * @return The value of the {@code groupUser} attribute
   */
  @JsonProperty("groupUser")
  @Override
  public Map<String, PmRepository.GroupUser> getGroupUser() {
    return groupUser;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.GroupResource#getGroup() group} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for group
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroupResource withGroup(PmRepository.Group value) {
    if (this.group == value) return this;
    PmRepository.Group newValue = Objects.requireNonNull(value, "group");
    return new ImmutableGroupResource(newValue, this.users, this.projects, this.access, this.groupUser);
  }

  /**
   * Copy the current immutable object by replacing the {@link PmRepository.GroupResource#getUsers() users} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the users map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroupResource withUsers(Map<String, ? extends PmRepository.User> entries) {
    if (this.users == entries) return this;
    Map<String, PmRepository.User> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableGroupResource(this.group, newValue, this.projects, this.access, this.groupUser);
  }

  /**
   * Copy the current immutable object by replacing the {@link PmRepository.GroupResource#getProjects() projects} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the projects map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroupResource withProjects(Map<String, ? extends PmRepository.Project> entries) {
    if (this.projects == entries) return this;
    Map<String, PmRepository.Project> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableGroupResource(this.group, this.users, newValue, this.access, this.groupUser);
  }

  /**
   * Copy the current immutable object by replacing the {@link PmRepository.GroupResource#getAccess() access} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the access map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroupResource withAccess(Map<String, ? extends PmRepository.Access> entries) {
    if (this.access == entries) return this;
    Map<String, PmRepository.Access> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableGroupResource(this.group, this.users, this.projects, newValue, this.groupUser);
  }

  /**
   * Copy the current immutable object by replacing the {@link PmRepository.GroupResource#getGroupUser() groupUser} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the groupUser map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroupResource withGroupUser(Map<String, ? extends PmRepository.GroupUser> entries) {
    if (this.groupUser == entries) return this;
    Map<String, PmRepository.GroupUser> newValue = createUnmodifiableMap(true, false, entries);
    return new ImmutableGroupResource(this.group, this.users, this.projects, this.access, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGroupResource} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGroupResource
        && equalTo((ImmutableGroupResource) another);
  }

  private boolean equalTo(ImmutableGroupResource another) {
    return group.equals(another.group)
        && users.equals(another.users)
        && projects.equals(another.projects)
        && access.equals(another.access)
        && groupUser.equals(another.groupUser);
  }

  /**
   * Computes a hash code from attributes: {@code group}, {@code users}, {@code projects}, {@code access}, {@code groupUser}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + group.hashCode();
    h += (h << 5) + users.hashCode();
    h += (h << 5) + projects.hashCode();
    h += (h << 5) + access.hashCode();
    h += (h << 5) + groupUser.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code GroupResource} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "GroupResource{"
        + "group=" + group
        + ", users=" + users
        + ", projects=" + projects
        + ", access=" + access
        + ", groupUser=" + groupUser
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PmRepository.GroupResource", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PmRepository.GroupResource {
    @Nullable PmRepository.Group group;
    @Nullable Map<String, PmRepository.User> users = Collections.emptyMap();
    @Nullable Map<String, PmRepository.Project> projects = Collections.emptyMap();
    @Nullable Map<String, PmRepository.Access> access = Collections.emptyMap();
    @Nullable Map<String, PmRepository.GroupUser> groupUser = Collections.emptyMap();
    @JsonProperty("group")
    public void setGroup(PmRepository.Group group) {
      this.group = group;
    }
    @JsonProperty("users")
    public void setUsers(Map<String, PmRepository.User> users) {
      this.users = users;
    }
    @JsonProperty("projects")
    public void setProjects(Map<String, PmRepository.Project> projects) {
      this.projects = projects;
    }
    @JsonProperty("access")
    public void setAccess(Map<String, PmRepository.Access> access) {
      this.access = access;
    }
    @JsonProperty("groupUser")
    public void setGroupUser(Map<String, PmRepository.GroupUser> groupUser) {
      this.groupUser = groupUser;
    }
    @Override
    public PmRepository.Group getGroup() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PmRepository.User> getUsers() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PmRepository.Project> getProjects() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PmRepository.Access> getAccess() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, PmRepository.GroupUser> getGroupUser() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableGroupResource fromJson(Json json) {
    ImmutableGroupResource.Builder builder = ImmutableGroupResource.builder();
    if (json.group != null) {
      builder.group(json.group);
    }
    if (json.users != null) {
      builder.putAllUsers(json.users);
    }
    if (json.projects != null) {
      builder.putAllProjects(json.projects);
    }
    if (json.access != null) {
      builder.putAllAccess(json.access);
    }
    if (json.groupUser != null) {
      builder.putAllGroupUser(json.groupUser);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PmRepository.GroupResource} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable GroupResource instance
   */
  public static ImmutableGroupResource copyOf(PmRepository.GroupResource instance) {
    if (instance instanceof ImmutableGroupResource) {
      return (ImmutableGroupResource) instance;
    }
    return ImmutableGroupResource.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGroupResource ImmutableGroupResource}.
   * <pre>
   * ImmutableGroupResource.builder()
   *    .group(io.resys.hdes.projects.api.PmRepository.Group) // required {@link PmRepository.GroupResource#getGroup() group}
   *    .putUsers|putAllUsers(String =&gt; io.resys.hdes.projects.api.PmRepository.User) // {@link PmRepository.GroupResource#getUsers() users} mappings
   *    .putProjects|putAllProjects(String =&gt; io.resys.hdes.projects.api.PmRepository.Project) // {@link PmRepository.GroupResource#getProjects() projects} mappings
   *    .putAccess|putAllAccess(String =&gt; io.resys.hdes.projects.api.PmRepository.Access) // {@link PmRepository.GroupResource#getAccess() access} mappings
   *    .putGroupUser|putAllGroupUser(String =&gt; io.resys.hdes.projects.api.PmRepository.GroupUser) // {@link PmRepository.GroupResource#getGroupUser() groupUser} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableGroupResource builder
   */
  public static ImmutableGroupResource.Builder builder() {
    return new ImmutableGroupResource.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGroupResource ImmutableGroupResource}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRepository.GroupResource", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_GROUP = 0x1L;
    private long initBits = 0x1L;

    private @Nullable PmRepository.Group group;
    private Map<String, PmRepository.User> users = new LinkedHashMap<String, PmRepository.User>();
    private Map<String, PmRepository.Project> projects = new LinkedHashMap<String, PmRepository.Project>();
    private Map<String, PmRepository.Access> access = new LinkedHashMap<String, PmRepository.Access>();
    private Map<String, PmRepository.GroupUser> groupUser = new LinkedHashMap<String, PmRepository.GroupUser>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code GroupResource} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.GroupResource instance) {
      Objects.requireNonNull(instance, "instance");
      group(instance.getGroup());
      putAllUsers(instance.getUsers());
      putAllProjects(instance.getProjects());
      putAllAccess(instance.getAccess());
      putAllGroupUser(instance.getGroupUser());
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.GroupResource#getGroup() group} attribute.
     * @param group The value for group 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("group")
    public final Builder group(PmRepository.Group group) {
      this.group = Objects.requireNonNull(group, "group");
      initBits &= ~INIT_BIT_GROUP;
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.GroupResource#getUsers() users} map.
     * @param key The key in the users map
     * @param value The associated value in the users map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putUsers(String key, PmRepository.User value) {
      this.users.put(
          Objects.requireNonNull(key, "users key"),
          Objects.requireNonNull(value, "users value"));
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.GroupResource#getUsers() users} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putUsers(Map.Entry<String, ? extends PmRepository.User> entry) {
      String k = entry.getKey();
      PmRepository.User v = entry.getValue();
      this.users.put(
          Objects.requireNonNull(k, "users key"),
          Objects.requireNonNull(v, "users value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PmRepository.GroupResource#getUsers() users} map. Nulls are not permitted
     * @param entries The entries that will be added to the users map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("users")
    public final Builder users(Map<String, ? extends PmRepository.User> entries) {
      this.users.clear();
      return putAllUsers(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PmRepository.GroupResource#getUsers() users} map. Nulls are not permitted
     * @param entries The entries that will be added to the users map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllUsers(Map<String, ? extends PmRepository.User> entries) {
      for (Map.Entry<String, ? extends PmRepository.User> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.User v = e.getValue();
        this.users.put(
            Objects.requireNonNull(k, "users key"),
            Objects.requireNonNull(v, "users value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.GroupResource#getProjects() projects} map.
     * @param key The key in the projects map
     * @param value The associated value in the projects map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProjects(String key, PmRepository.Project value) {
      this.projects.put(
          Objects.requireNonNull(key, "projects key"),
          Objects.requireNonNull(value, "projects value"));
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.GroupResource#getProjects() projects} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putProjects(Map.Entry<String, ? extends PmRepository.Project> entry) {
      String k = entry.getKey();
      PmRepository.Project v = entry.getValue();
      this.projects.put(
          Objects.requireNonNull(k, "projects key"),
          Objects.requireNonNull(v, "projects value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PmRepository.GroupResource#getProjects() projects} map. Nulls are not permitted
     * @param entries The entries that will be added to the projects map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("projects")
    public final Builder projects(Map<String, ? extends PmRepository.Project> entries) {
      this.projects.clear();
      return putAllProjects(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PmRepository.GroupResource#getProjects() projects} map. Nulls are not permitted
     * @param entries The entries that will be added to the projects map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllProjects(Map<String, ? extends PmRepository.Project> entries) {
      for (Map.Entry<String, ? extends PmRepository.Project> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.Project v = e.getValue();
        this.projects.put(
            Objects.requireNonNull(k, "projects key"),
            Objects.requireNonNull(v, "projects value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.GroupResource#getAccess() access} map.
     * @param key The key in the access map
     * @param value The associated value in the access map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAccess(String key, PmRepository.Access value) {
      this.access.put(
          Objects.requireNonNull(key, "access key"),
          Objects.requireNonNull(value, "access value"));
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.GroupResource#getAccess() access} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAccess(Map.Entry<String, ? extends PmRepository.Access> entry) {
      String k = entry.getKey();
      PmRepository.Access v = entry.getValue();
      this.access.put(
          Objects.requireNonNull(k, "access key"),
          Objects.requireNonNull(v, "access value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PmRepository.GroupResource#getAccess() access} map. Nulls are not permitted
     * @param entries The entries that will be added to the access map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("access")
    public final Builder access(Map<String, ? extends PmRepository.Access> entries) {
      this.access.clear();
      return putAllAccess(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PmRepository.GroupResource#getAccess() access} map. Nulls are not permitted
     * @param entries The entries that will be added to the access map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllAccess(Map<String, ? extends PmRepository.Access> entries) {
      for (Map.Entry<String, ? extends PmRepository.Access> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.Access v = e.getValue();
        this.access.put(
            Objects.requireNonNull(k, "access key"),
            Objects.requireNonNull(v, "access value"));
      }
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.GroupResource#getGroupUser() groupUser} map.
     * @param key The key in the groupUser map
     * @param value The associated value in the groupUser map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroupUser(String key, PmRepository.GroupUser value) {
      this.groupUser.put(
          Objects.requireNonNull(key, "groupUser key"),
          Objects.requireNonNull(value, "groupUser value"));
      return this;
    }

    /**
     * Put one entry to the {@link PmRepository.GroupResource#getGroupUser() groupUser} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putGroupUser(Map.Entry<String, ? extends PmRepository.GroupUser> entry) {
      String k = entry.getKey();
      PmRepository.GroupUser v = entry.getValue();
      this.groupUser.put(
          Objects.requireNonNull(k, "groupUser key"),
          Objects.requireNonNull(v, "groupUser value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link PmRepository.GroupResource#getGroupUser() groupUser} map. Nulls are not permitted
     * @param entries The entries that will be added to the groupUser map
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupUser")
    public final Builder groupUser(Map<String, ? extends PmRepository.GroupUser> entries) {
      this.groupUser.clear();
      return putAllGroupUser(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link PmRepository.GroupResource#getGroupUser() groupUser} map. Nulls are not permitted
     * @param entries The entries that will be added to the groupUser map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllGroupUser(Map<String, ? extends PmRepository.GroupUser> entries) {
      for (Map.Entry<String, ? extends PmRepository.GroupUser> e : entries.entrySet()) {
        String k = e.getKey();
        PmRepository.GroupUser v = e.getValue();
        this.groupUser.put(
            Objects.requireNonNull(k, "groupUser key"),
            Objects.requireNonNull(v, "groupUser value"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableGroupResource ImmutableGroupResource}.
     * @return An immutable instance of GroupResource
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGroupResource build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGroupResource(
          group,
          createUnmodifiableMap(false, false, users),
          createUnmodifiableMap(false, false, projects),
          createUnmodifiableMap(false, false, access),
          createUnmodifiableMap(false, false, groupUser));
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GROUP) != 0) attributes.add("group");
      return "Cannot build GroupResource, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
