package io.resys.hdes.projects.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRepository.Group}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableGroup.builder()}.
 */
@Generated(from = "PmRepository.Group", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableGroup implements PmRepository.Group {
  private final String id;
  private final String rev;
  private final LocalDateTime created;
  private final PmRepository.GroupType type;
  private final @Nullable String matcher;
  private final String name;

  private ImmutableGroup(
      String id,
      String rev,
      LocalDateTime created,
      PmRepository.GroupType type,
      @Nullable String matcher,
      String name) {
    this.id = id;
    this.rev = rev;
    this.created = created;
    this.type = type;
    this.matcher = matcher;
    this.name = name;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("rev")
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public LocalDateTime getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty("type")
  @Override
  public PmRepository.GroupType getType() {
    return type;
  }

  /**
   * @return The value of the {@code matcher} attribute
   */
  @JsonProperty("matcher")
  @Override
  public Optional<String> getMatcher() {
    return Optional.ofNullable(matcher);
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public String getName() {
    return name;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Group#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroup withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableGroup(newValue, this.rev, this.created, this.type, this.matcher, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Group#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroup withRev(String value) {
    String newValue = Objects.requireNonNull(value, "rev");
    if (this.rev.equals(newValue)) return this;
    return new ImmutableGroup(this.id, newValue, this.created, this.type, this.matcher, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Group#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroup withCreated(LocalDateTime value) {
    if (this.created == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "created");
    return new ImmutableGroup(this.id, this.rev, newValue, this.type, this.matcher, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Group#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroup withType(PmRepository.GroupType value) {
    if (this.type == value) return this;
    PmRepository.GroupType newValue = Objects.requireNonNull(value, "type");
    if (this.type.equals(newValue)) return this;
    return new ImmutableGroup(this.id, this.rev, this.created, newValue, this.matcher, this.name);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PmRepository.Group#getMatcher() matcher} attribute.
   * @param value The value for matcher
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withMatcher(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "matcher");
    if (Objects.equals(this.matcher, newValue)) return this;
    return new ImmutableGroup(this.id, this.rev, this.created, this.type, newValue, this.name);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PmRepository.Group#getMatcher() matcher} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for matcher
   * @return A modified copy of {@code this} object
   */
  public final ImmutableGroup withMatcher(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.matcher, value)) return this;
    return new ImmutableGroup(this.id, this.rev, this.created, this.type, value, this.name);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Group#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableGroup withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new ImmutableGroup(this.id, this.rev, this.created, this.type, this.matcher, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableGroup
        && equalTo((ImmutableGroup) another);
  }

  private boolean equalTo(ImmutableGroup another) {
    return id.equals(another.id)
        && rev.equals(another.rev)
        && created.equals(another.created)
        && type.equals(another.type)
        && Objects.equals(matcher, another.matcher)
        && name.equals(another.name);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code created}, {@code type}, {@code matcher}, {@code name}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rev.hashCode();
    h += (h << 5) + created.hashCode();
    h += (h << 5) + type.hashCode();
    h += (h << 5) + Objects.hashCode(matcher);
    h += (h << 5) + name.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code Group} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Group{");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("rev=").append(rev);
    builder.append(", ");
    builder.append("created=").append(created);
    builder.append(", ");
    builder.append("type=").append(type);
    if (matcher != null) {
      builder.append(", ");
      builder.append("matcher=").append(matcher);
    }
    builder.append(", ");
    builder.append("name=").append(name);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PmRepository.Group", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PmRepository.Group {
    @Nullable String id;
    @Nullable String rev;
    @Nullable LocalDateTime created;
    @Nullable PmRepository.GroupType type;
    @Nullable Optional<String> matcher = Optional.empty();
    @Nullable String name;
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("rev")
    public void setRev(String rev) {
      this.rev = rev;
    }
    @JsonProperty("created")
    public void setCreated(LocalDateTime created) {
      this.created = created;
    }
    @JsonProperty("type")
    public void setType(PmRepository.GroupType type) {
      this.type = type;
    }
    @JsonProperty("matcher")
    public void setMatcher(Optional<String> matcher) {
      this.matcher = matcher;
    }
    @JsonProperty("name")
    public void setName(String name) {
      this.name = name;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public PmRepository.GroupType getType() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getMatcher() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableGroup fromJson(Json json) {
    ImmutableGroup.Builder builder = ImmutableGroup.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.type != null) {
      builder.type(json.type);
    }
    if (json.matcher != null) {
      builder.matcher(json.matcher);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PmRepository.Group} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Group instance
   */
  public static ImmutableGroup copyOf(PmRepository.Group instance) {
    if (instance instanceof ImmutableGroup) {
      return (ImmutableGroup) instance;
    }
    return ImmutableGroup.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableGroup ImmutableGroup}.
   * <pre>
   * ImmutableGroup.builder()
   *    .id(String) // required {@link PmRepository.Group#getId() id}
   *    .rev(String) // required {@link PmRepository.Group#getRev() rev}
   *    .created(java.time.LocalDateTime) // required {@link PmRepository.Group#getCreated() created}
   *    .type(io.resys.hdes.projects.api.PmRepository.GroupType) // required {@link PmRepository.Group#getType() type}
   *    .matcher(String) // optional {@link PmRepository.Group#getMatcher() matcher}
   *    .name(String) // required {@link PmRepository.Group#getName() name}
   *    .build();
   * </pre>
   * @return A new ImmutableGroup builder
   */
  public static ImmutableGroup.Builder builder() {
    return new ImmutableGroup.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableGroup ImmutableGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRepository.Group", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_REV = 0x2L;
    private static final long INIT_BIT_CREATED = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private static final long INIT_BIT_NAME = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable LocalDateTime created;
    private @Nullable PmRepository.GroupType type;
    private @Nullable String matcher;
    private @Nullable String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Group} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.Group instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rev(instance.getRev());
      created(instance.getCreated());
      type(instance.getType());
      Optional<String> matcherOptional = instance.getMatcher();
      if (matcherOptional.isPresent()) {
        matcher(matcherOptional);
      }
      name(instance.getName());
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Group#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Group#getRev() rev} attribute.
     * @param rev The value for rev 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rev")
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      initBits &= ~INIT_BIT_REV;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Group#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(LocalDateTime created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Group#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("type")
    public final Builder type(PmRepository.GroupType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.Group#getMatcher() matcher} to matcher.
     * @param matcher The value for matcher
     * @return {@code this} builder for chained invocation
     */
    public final Builder matcher(String matcher) {
      this.matcher = Objects.requireNonNull(matcher, "matcher");
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.Group#getMatcher() matcher} to matcher.
     * @param matcher The value for matcher
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("matcher")
    public final Builder matcher(Optional<String> matcher) {
      this.matcher = matcher.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Group#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Builds a new {@link ImmutableGroup ImmutableGroup}.
     * @return An immutable instance of Group
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableGroup build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableGroup(id, rev, created, type, matcher, name);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_REV) != 0) attributes.add("rev");
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build Group, some of required attributes are not set " + attributes;
    }
  }
}
