package io.resys.hdes.projects.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRepository.BatchUser}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBatchUser.builder()}.
 */
@Generated(from = "PmRepository.BatchUser", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableBatchUser implements PmRepository.BatchUser {
  private final @Nullable String id;
  private final @Nullable String rev;
  private final @Nullable String name;
  private final @Nullable String email;
  private final @Nullable String externalId;
  private final @Nullable PmRepository.UserStatus status;
  private final @Nullable List<String> projects;
  private final @Nullable List<String> groups;

  private ImmutableBatchUser(
      @Nullable String id,
      @Nullable String rev,
      @Nullable String name,
      @Nullable String email,
      @Nullable String externalId,
      @Nullable PmRepository.UserStatus status,
      @Nullable List<String> projects,
      @Nullable List<String> groups) {
    this.id = id;
    this.rev = rev;
    this.name = name;
    this.email = email;
    this.externalId = externalId;
    this.status = status;
    this.projects = projects;
    this.groups = groups;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("rev")
  @Override
  public @Nullable String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code email} attribute
   */
  @JsonProperty("email")
  @Override
  public @Nullable String getEmail() {
    return email;
  }

  /**
   * @return The value of the {@code externalId} attribute
   */
  @JsonProperty("externalId")
  @Override
  public @Nullable String getExternalId() {
    return externalId;
  }

  /**
   * @return The value of the {@code status} attribute
   */
  @JsonProperty("status")
  @Override
  public @Nullable PmRepository.UserStatus getStatus() {
    return status;
  }

  /**
   * @return The value of the {@code projects} attribute
   */
  @JsonProperty("projects")
  @Override
  public @Nullable List<String> getProjects() {
    return projects;
  }

  /**
   * @return The value of the {@code groups} attribute
   */
  @JsonProperty("groups")
  @Override
  public @Nullable List<String> getGroups() {
    return groups;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchUser#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchUser withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableBatchUser(
        value,
        this.rev,
        this.name,
        this.email,
        this.externalId,
        this.status,
        this.projects,
        this.groups);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchUser#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchUser withRev(@Nullable String value) {
    if (Objects.equals(this.rev, value)) return this;
    return new ImmutableBatchUser(this.id, value, this.name, this.email, this.externalId, this.status, this.projects, this.groups);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchUser#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchUser withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableBatchUser(this.id, this.rev, value, this.email, this.externalId, this.status, this.projects, this.groups);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchUser#getEmail() email} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for email (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchUser withEmail(@Nullable String value) {
    if (Objects.equals(this.email, value)) return this;
    return new ImmutableBatchUser(this.id, this.rev, this.name, value, this.externalId, this.status, this.projects, this.groups);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchUser#getExternalId() externalId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for externalId (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchUser withExternalId(@Nullable String value) {
    if (Objects.equals(this.externalId, value)) return this;
    return new ImmutableBatchUser(this.id, this.rev, this.name, this.email, value, this.status, this.projects, this.groups);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchUser#getStatus() status} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for status (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchUser withStatus(@Nullable PmRepository.UserStatus value) {
    if (this.status == value) return this;
    if (Objects.equals(this.status, value)) return this;
    return new ImmutableBatchUser(this.id, this.rev, this.name, this.email, this.externalId, value, this.projects, this.groups);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.BatchUser#getProjects() projects}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchUser withProjects(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableBatchUser(this.id, this.rev, this.name, this.email, this.externalId, this.status, null, this.groups);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBatchUser(this.id, this.rev, this.name, this.email, this.externalId, this.status, newValue, this.groups);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.BatchUser#getProjects() projects}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of projects elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchUser withProjects(@Nullable Iterable<String> elements) {
    if (this.projects == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBatchUser(this.id, this.rev, this.name, this.email, this.externalId, this.status, newValue, this.groups);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.BatchUser#getGroups() groups}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchUser withGroups(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableBatchUser(this.id, this.rev, this.name, this.email, this.externalId, this.status, this.projects, null);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBatchUser(this.id, this.rev, this.name, this.email, this.externalId, this.status, this.projects, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.BatchUser#getGroups() groups}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of groups elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchUser withGroups(@Nullable Iterable<String> elements) {
    if (this.groups == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBatchUser(this.id, this.rev, this.name, this.email, this.externalId, this.status, this.projects, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBatchUser} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBatchUser
        && equalTo((ImmutableBatchUser) another);
  }

  private boolean equalTo(ImmutableBatchUser another) {
    return Objects.equals(id, another.id)
        && Objects.equals(rev, another.rev)
        && Objects.equals(name, another.name)
        && Objects.equals(email, another.email)
        && Objects.equals(externalId, another.externalId)
        && Objects.equals(status, another.status)
        && Objects.equals(projects, another.projects)
        && Objects.equals(groups, another.groups);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code name}, {@code email}, {@code externalId}, {@code status}, {@code projects}, {@code groups}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(rev);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(email);
    h += (h << 5) + Objects.hashCode(externalId);
    h += (h << 5) + Objects.hashCode(status);
    h += (h << 5) + Objects.hashCode(projects);
    h += (h << 5) + Objects.hashCode(groups);
    return h;
  }

  /**
   * Prints the immutable value {@code BatchUser} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BatchUser{"
        + "id=" + id
        + ", rev=" + rev
        + ", name=" + name
        + ", email=" + email
        + ", externalId=" + externalId
        + ", status=" + status
        + ", projects=" + projects
        + ", groups=" + groups
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PmRepository.BatchUser", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PmRepository.BatchUser {
    @Nullable String id;
    @Nullable String rev;
    @Nullable String name;
    @Nullable String email;
    @Nullable String externalId;
    @Nullable PmRepository.UserStatus status;
    @Nullable List<String> projects = null;
    @Nullable List<String> groups = null;
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("rev")
    public void setRev(@Nullable String rev) {
      this.rev = rev;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("email")
    public void setEmail(@Nullable String email) {
      this.email = email;
    }
    @JsonProperty("externalId")
    public void setExternalId(@Nullable String externalId) {
      this.externalId = externalId;
    }
    @JsonProperty("status")
    public void setStatus(@Nullable PmRepository.UserStatus status) {
      this.status = status;
    }
    @JsonProperty("projects")
    public void setProjects(@Nullable List<String> projects) {
      this.projects = projects;
    }
    @JsonProperty("groups")
    public void setGroups(@Nullable List<String> groups) {
      this.groups = groups;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getEmail() { throw new UnsupportedOperationException(); }
    @Override
    public String getExternalId() { throw new UnsupportedOperationException(); }
    @Override
    public PmRepository.UserStatus getStatus() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getProjects() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getGroups() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBatchUser fromJson(Json json) {
    ImmutableBatchUser.Builder builder = ImmutableBatchUser.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.email != null) {
      builder.email(json.email);
    }
    if (json.externalId != null) {
      builder.externalId(json.externalId);
    }
    if (json.status != null) {
      builder.status(json.status);
    }
    if (json.projects != null) {
      builder.addAllProjects(json.projects);
    }
    if (json.groups != null) {
      builder.addAllGroups(json.groups);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PmRepository.BatchUser} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BatchUser instance
   */
  public static ImmutableBatchUser copyOf(PmRepository.BatchUser instance) {
    if (instance instanceof ImmutableBatchUser) {
      return (ImmutableBatchUser) instance;
    }
    return ImmutableBatchUser.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBatchUser ImmutableBatchUser}.
   * <pre>
   * ImmutableBatchUser.builder()
   *    .id(String | null) // nullable {@link PmRepository.BatchUser#getId() id}
   *    .rev(String | null) // nullable {@link PmRepository.BatchUser#getRev() rev}
   *    .name(String | null) // nullable {@link PmRepository.BatchUser#getName() name}
   *    .email(String | null) // nullable {@link PmRepository.BatchUser#getEmail() email}
   *    .externalId(String | null) // nullable {@link PmRepository.BatchUser#getExternalId() externalId}
   *    .status(io.resys.hdes.projects.api.PmRepository.UserStatus | null) // nullable {@link PmRepository.BatchUser#getStatus() status}
   *    .projects(List&amp;lt;String&amp;gt; | null) // nullable {@link PmRepository.BatchUser#getProjects() projects}
   *    .groups(List&amp;lt;String&amp;gt; | null) // nullable {@link PmRepository.BatchUser#getGroups() groups}
   *    .build();
   * </pre>
   * @return A new ImmutableBatchUser builder
   */
  public static ImmutableBatchUser.Builder builder() {
    return new ImmutableBatchUser.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBatchUser ImmutableBatchUser}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRepository.BatchUser", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable String name;
    private @Nullable String email;
    private @Nullable String externalId;
    private @Nullable PmRepository.UserStatus status;
    private List<String> projects = null;
    private List<String> groups = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.hdes.projects.api.PmRepository.BatchMutator} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.BatchMutator instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.hdes.projects.api.PmRepository.BatchUser} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.BatchUser instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PmRepository.BatchMutator) {
        PmRepository.BatchMutator instance = (PmRepository.BatchMutator) object;
        @Nullable String revValue = instance.getRev();
        if (revValue != null) {
          rev(revValue);
        }
        @Nullable String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
      }
      if (object instanceof PmRepository.BatchUser) {
        PmRepository.BatchUser instance = (PmRepository.BatchUser) object;
        @Nullable String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        @Nullable String externalIdValue = instance.getExternalId();
        if (externalIdValue != null) {
          externalId(externalIdValue);
        }
        @Nullable List<String> groupsValue = instance.getGroups();
        if (groupsValue != null) {
          addAllGroups(groupsValue);
        }
        @Nullable List<String> projectsValue = instance.getProjects();
        if (projectsValue != null) {
          addAllProjects(projectsValue);
        }
        @Nullable String emailValue = instance.getEmail();
        if (emailValue != null) {
          email(emailValue);
        }
        @Nullable PmRepository.UserStatus statusValue = instance.getStatus();
        if (statusValue != null) {
          status(statusValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchUser#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchUser#getRev() rev} attribute.
     * @param rev The value for rev (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rev")
    public final Builder rev(@Nullable String rev) {
      this.rev = rev;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchUser#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchUser#getEmail() email} attribute.
     * @param email The value for email (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("email")
    public final Builder email(@Nullable String email) {
      this.email = email;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchUser#getExternalId() externalId} attribute.
     * @param externalId The value for externalId (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("externalId")
    public final Builder externalId(@Nullable String externalId) {
      this.externalId = externalId;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchUser#getStatus() status} attribute.
     * @param status The value for status (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("status")
    public final Builder status(@Nullable PmRepository.UserStatus status) {
      this.status = status;
      return this;
    }

    /**
     * Adds one element to {@link PmRepository.BatchUser#getProjects() projects} list.
     * @param element A projects element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addProjects(String element) {
      if (this.projects == null) {
        this.projects = new ArrayList<String>();
      }
      this.projects.add(Objects.requireNonNull(element, "projects element"));
      return this;
    }

    /**
     * Adds elements to {@link PmRepository.BatchUser#getProjects() projects} list.
     * @param elements An array of projects elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addProjects(String... elements) {
      if (this.projects == null) {
        this.projects = new ArrayList<String>();
      }
      for (String element : elements) {
        this.projects.add(Objects.requireNonNull(element, "projects element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PmRepository.BatchUser#getProjects() projects} list.
     * @param elements An iterable of projects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("projects")
    public final Builder projects(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.projects = null;
        return this;
      }
      this.projects = new ArrayList<String>();
      return addAllProjects(elements);
    }

    /**
     * Adds elements to {@link PmRepository.BatchUser#getProjects() projects} list.
     * @param elements An iterable of projects elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProjects(Iterable<String> elements) {
      Objects.requireNonNull(elements, "projects element");
      if (this.projects == null) {
        this.projects = new ArrayList<String>();
      }
      for (String element : elements) {
        this.projects.add(Objects.requireNonNull(element, "projects element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link PmRepository.BatchUser#getGroups() groups} list.
     * @param element A groups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroups(String element) {
      if (this.groups == null) {
        this.groups = new ArrayList<String>();
      }
      this.groups.add(Objects.requireNonNull(element, "groups element"));
      return this;
    }

    /**
     * Adds elements to {@link PmRepository.BatchUser#getGroups() groups} list.
     * @param elements An array of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroups(String... elements) {
      if (this.groups == null) {
        this.groups = new ArrayList<String>();
      }
      for (String element : elements) {
        this.groups.add(Objects.requireNonNull(element, "groups element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PmRepository.BatchUser#getGroups() groups} list.
     * @param elements An iterable of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groups")
    public final Builder groups(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.groups = null;
        return this;
      }
      this.groups = new ArrayList<String>();
      return addAllGroups(elements);
    }

    /**
     * Adds elements to {@link PmRepository.BatchUser#getGroups() groups} list.
     * @param elements An iterable of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGroups(Iterable<String> elements) {
      Objects.requireNonNull(elements, "groups element");
      if (this.groups == null) {
        this.groups = new ArrayList<String>();
      }
      for (String element : elements) {
        this.groups.add(Objects.requireNonNull(element, "groups element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableBatchUser ImmutableBatchUser}.
     * @return An immutable instance of BatchUser
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBatchUser build() {
      return new ImmutableBatchUser(
          id,
          rev,
          name,
          email,
          externalId,
          status,
          projects == null ? null : createUnmodifiableList(true, projects),
          groups == null ? null : createUnmodifiableList(true, groups));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
