package io.resys.hdes.projects.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRepository.BatchProject}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBatchProject.builder()}.
 */
@Generated(from = "PmRepository.BatchProject", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableBatchProject implements PmRepository.BatchProject {
  private final @Nullable String id;
  private final @Nullable String rev;
  private final @Nullable String name;
  private final @Nullable List<String> users;
  private final @Nullable List<String> groups;

  private ImmutableBatchProject(
      @Nullable String id,
      @Nullable String rev,
      @Nullable String name,
      @Nullable List<String> users,
      @Nullable List<String> groups) {
    this.id = id;
    this.rev = rev;
    this.name = name;
    this.users = users;
    this.groups = groups;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("rev")
  @Override
  public @Nullable String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code users} attribute
   */
  @JsonProperty("users")
  @Override
  public @Nullable List<String> getUsers() {
    return users;
  }

  /**
   * @return The value of the {@code groups} attribute
   */
  @JsonProperty("groups")
  @Override
  public @Nullable List<String> getGroups() {
    return groups;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchProject#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchProject withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableBatchProject(value, this.rev, this.name, this.users, this.groups);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchProject#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchProject withRev(@Nullable String value) {
    if (Objects.equals(this.rev, value)) return this;
    return new ImmutableBatchProject(this.id, value, this.name, this.users, this.groups);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchProject#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchProject withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableBatchProject(this.id, this.rev, value, this.users, this.groups);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.BatchProject#getUsers() users}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchProject withUsers(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableBatchProject(this.id, this.rev, this.name, null, this.groups);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBatchProject(this.id, this.rev, this.name, newValue, this.groups);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.BatchProject#getUsers() users}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of users elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchProject withUsers(@Nullable Iterable<String> elements) {
    if (this.users == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBatchProject(this.id, this.rev, this.name, newValue, this.groups);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.BatchProject#getGroups() groups}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchProject withGroups(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableBatchProject(this.id, this.rev, this.name, this.users, null);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBatchProject(this.id, this.rev, this.name, this.users, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.BatchProject#getGroups() groups}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of groups elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchProject withGroups(@Nullable Iterable<String> elements) {
    if (this.groups == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBatchProject(this.id, this.rev, this.name, this.users, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBatchProject} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBatchProject
        && equalTo((ImmutableBatchProject) another);
  }

  private boolean equalTo(ImmutableBatchProject another) {
    return Objects.equals(id, another.id)
        && Objects.equals(rev, another.rev)
        && Objects.equals(name, another.name)
        && Objects.equals(users, another.users)
        && Objects.equals(groups, another.groups);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code name}, {@code users}, {@code groups}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(rev);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(users);
    h += (h << 5) + Objects.hashCode(groups);
    return h;
  }

  /**
   * Prints the immutable value {@code BatchProject} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BatchProject{"
        + "id=" + id
        + ", rev=" + rev
        + ", name=" + name
        + ", users=" + users
        + ", groups=" + groups
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PmRepository.BatchProject", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PmRepository.BatchProject {
    @Nullable String id;
    @Nullable String rev;
    @Nullable String name;
    @Nullable List<String> users = null;
    @Nullable List<String> groups = null;
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("rev")
    public void setRev(@Nullable String rev) {
      this.rev = rev;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("users")
    public void setUsers(@Nullable List<String> users) {
      this.users = users;
    }
    @JsonProperty("groups")
    public void setGroups(@Nullable List<String> groups) {
      this.groups = groups;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getUsers() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getGroups() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBatchProject fromJson(Json json) {
    ImmutableBatchProject.Builder builder = ImmutableBatchProject.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.users != null) {
      builder.addAllUsers(json.users);
    }
    if (json.groups != null) {
      builder.addAllGroups(json.groups);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PmRepository.BatchProject} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BatchProject instance
   */
  public static ImmutableBatchProject copyOf(PmRepository.BatchProject instance) {
    if (instance instanceof ImmutableBatchProject) {
      return (ImmutableBatchProject) instance;
    }
    return ImmutableBatchProject.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBatchProject ImmutableBatchProject}.
   * <pre>
   * ImmutableBatchProject.builder()
   *    .id(String | null) // nullable {@link PmRepository.BatchProject#getId() id}
   *    .rev(String | null) // nullable {@link PmRepository.BatchProject#getRev() rev}
   *    .name(String | null) // nullable {@link PmRepository.BatchProject#getName() name}
   *    .users(List&amp;lt;String&amp;gt; | null) // nullable {@link PmRepository.BatchProject#getUsers() users}
   *    .groups(List&amp;lt;String&amp;gt; | null) // nullable {@link PmRepository.BatchProject#getGroups() groups}
   *    .build();
   * </pre>
   * @return A new ImmutableBatchProject builder
   */
  public static ImmutableBatchProject.Builder builder() {
    return new ImmutableBatchProject.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBatchProject ImmutableBatchProject}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRepository.BatchProject", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable String name;
    private List<String> users = null;
    private List<String> groups = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.hdes.projects.api.PmRepository.BatchMutator} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.BatchMutator instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.hdes.projects.api.PmRepository.BatchProject} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.BatchProject instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PmRepository.BatchMutator) {
        PmRepository.BatchMutator instance = (PmRepository.BatchMutator) object;
        @Nullable String revValue = instance.getRev();
        if (revValue != null) {
          rev(revValue);
        }
        @Nullable String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
      }
      if (object instanceof PmRepository.BatchProject) {
        PmRepository.BatchProject instance = (PmRepository.BatchProject) object;
        @Nullable String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        @Nullable List<String> groupsValue = instance.getGroups();
        if (groupsValue != null) {
          addAllGroups(groupsValue);
        }
        @Nullable List<String> usersValue = instance.getUsers();
        if (usersValue != null) {
          addAllUsers(usersValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchProject#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchProject#getRev() rev} attribute.
     * @param rev The value for rev (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rev")
    public final Builder rev(@Nullable String rev) {
      this.rev = rev;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchProject#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Adds one element to {@link PmRepository.BatchProject#getUsers() users} list.
     * @param element A users element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUsers(String element) {
      if (this.users == null) {
        this.users = new ArrayList<String>();
      }
      this.users.add(Objects.requireNonNull(element, "users element"));
      return this;
    }

    /**
     * Adds elements to {@link PmRepository.BatchProject#getUsers() users} list.
     * @param elements An array of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUsers(String... elements) {
      if (this.users == null) {
        this.users = new ArrayList<String>();
      }
      for (String element : elements) {
        this.users.add(Objects.requireNonNull(element, "users element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PmRepository.BatchProject#getUsers() users} list.
     * @param elements An iterable of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("users")
    public final Builder users(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.users = null;
        return this;
      }
      this.users = new ArrayList<String>();
      return addAllUsers(elements);
    }

    /**
     * Adds elements to {@link PmRepository.BatchProject#getUsers() users} list.
     * @param elements An iterable of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUsers(Iterable<String> elements) {
      Objects.requireNonNull(elements, "users element");
      if (this.users == null) {
        this.users = new ArrayList<String>();
      }
      for (String element : elements) {
        this.users.add(Objects.requireNonNull(element, "users element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link PmRepository.BatchProject#getGroups() groups} list.
     * @param element A groups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroups(String element) {
      if (this.groups == null) {
        this.groups = new ArrayList<String>();
      }
      this.groups.add(Objects.requireNonNull(element, "groups element"));
      return this;
    }

    /**
     * Adds elements to {@link PmRepository.BatchProject#getGroups() groups} list.
     * @param elements An array of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroups(String... elements) {
      if (this.groups == null) {
        this.groups = new ArrayList<String>();
      }
      for (String element : elements) {
        this.groups.add(Objects.requireNonNull(element, "groups element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PmRepository.BatchProject#getGroups() groups} list.
     * @param elements An iterable of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groups")
    public final Builder groups(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.groups = null;
        return this;
      }
      this.groups = new ArrayList<String>();
      return addAllGroups(elements);
    }

    /**
     * Adds elements to {@link PmRepository.BatchProject#getGroups() groups} list.
     * @param elements An iterable of groups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGroups(Iterable<String> elements) {
      Objects.requireNonNull(elements, "groups element");
      if (this.groups == null) {
        this.groups = new ArrayList<String>();
      }
      for (String element : elements) {
        this.groups.add(Objects.requireNonNull(element, "groups element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableBatchProject ImmutableBatchProject}.
     * @return An immutable instance of BatchProject
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBatchProject build() {
      return new ImmutableBatchProject(
          id,
          rev,
          name,
          users == null ? null : createUnmodifiableList(true, users),
          groups == null ? null : createUnmodifiableList(true, groups));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
