package io.resys.hdes.projects.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRepository.BatchGroup}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableBatchGroup.builder()}.
 */
@Generated(from = "PmRepository.BatchGroup", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableBatchGroup implements PmRepository.BatchGroup {
  private final @Nullable String id;
  private final @Nullable String rev;
  private final @Nullable String name;
  private final @Nullable String matcher;
  private final @Nullable List<String> users;
  private final @Nullable List<String> projects;

  private ImmutableBatchGroup(
      @Nullable String id,
      @Nullable String rev,
      @Nullable String name,
      @Nullable String matcher,
      @Nullable List<String> users,
      @Nullable List<String> projects) {
    this.id = id;
    this.rev = rev;
    this.name = name;
    this.matcher = matcher;
    this.users = users;
    this.projects = projects;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public @Nullable String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("rev")
  @Override
  public @Nullable String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty("name")
  @Override
  public @Nullable String getName() {
    return name;
  }

  /**
   * @return The value of the {@code matcher} attribute
   */
  @JsonProperty("matcher")
  @Override
  public @Nullable String getMatcher() {
    return matcher;
  }

  /**
   * @return The value of the {@code users} attribute
   */
  @JsonProperty("users")
  @Override
  public @Nullable List<String> getUsers() {
    return users;
  }

  /**
   * @return The value of the {@code projects} attribute
   */
  @JsonProperty("projects")
  @Override
  public @Nullable List<String> getProjects() {
    return projects;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchGroup#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchGroup withId(@Nullable String value) {
    if (Objects.equals(this.id, value)) return this;
    return new ImmutableBatchGroup(value, this.rev, this.name, this.matcher, this.users, this.projects);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchGroup#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchGroup withRev(@Nullable String value) {
    if (Objects.equals(this.rev, value)) return this;
    return new ImmutableBatchGroup(this.id, value, this.name, this.matcher, this.users, this.projects);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchGroup#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchGroup withName(@Nullable String value) {
    if (Objects.equals(this.name, value)) return this;
    return new ImmutableBatchGroup(this.id, this.rev, value, this.matcher, this.users, this.projects);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.BatchGroup#getMatcher() matcher} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for matcher (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableBatchGroup withMatcher(@Nullable String value) {
    if (Objects.equals(this.matcher, value)) return this;
    return new ImmutableBatchGroup(this.id, this.rev, this.name, value, this.users, this.projects);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.BatchGroup#getUsers() users}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchGroup withUsers(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableBatchGroup(this.id, this.rev, this.name, this.matcher, null, this.projects);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBatchGroup(this.id, this.rev, this.name, this.matcher, newValue, this.projects);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.BatchGroup#getUsers() users}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of users elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchGroup withUsers(@Nullable Iterable<String> elements) {
    if (this.users == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBatchGroup(this.id, this.rev, this.name, this.matcher, newValue, this.projects);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.BatchGroup#getProjects() projects}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchGroup withProjects(@Nullable String... elements) {
    if (elements == null) {
      return new ImmutableBatchGroup(this.id, this.rev, this.name, this.matcher, this.users, null);
    }
    @Nullable List<String> newValue = Arrays.asList(elements) == null ? null : createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ImmutableBatchGroup(this.id, this.rev, this.name, this.matcher, this.users, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link PmRepository.BatchGroup#getProjects() projects}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of projects elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableBatchGroup withProjects(@Nullable Iterable<String> elements) {
    if (this.projects == elements) return this;
    @Nullable List<String> newValue = elements == null ? null : createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ImmutableBatchGroup(this.id, this.rev, this.name, this.matcher, this.users, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableBatchGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableBatchGroup
        && equalTo((ImmutableBatchGroup) another);
  }

  private boolean equalTo(ImmutableBatchGroup another) {
    return Objects.equals(id, another.id)
        && Objects.equals(rev, another.rev)
        && Objects.equals(name, another.name)
        && Objects.equals(matcher, another.matcher)
        && Objects.equals(users, another.users)
        && Objects.equals(projects, another.projects);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code name}, {@code matcher}, {@code users}, {@code projects}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + Objects.hashCode(id);
    h += (h << 5) + Objects.hashCode(rev);
    h += (h << 5) + Objects.hashCode(name);
    h += (h << 5) + Objects.hashCode(matcher);
    h += (h << 5) + Objects.hashCode(users);
    h += (h << 5) + Objects.hashCode(projects);
    return h;
  }

  /**
   * Prints the immutable value {@code BatchGroup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "BatchGroup{"
        + "id=" + id
        + ", rev=" + rev
        + ", name=" + name
        + ", matcher=" + matcher
        + ", users=" + users
        + ", projects=" + projects
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PmRepository.BatchGroup", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PmRepository.BatchGroup {
    @Nullable String id;
    @Nullable String rev;
    @Nullable String name;
    @Nullable String matcher;
    @Nullable List<String> users = null;
    @Nullable List<String> projects = null;
    @JsonProperty("id")
    public void setId(@Nullable String id) {
      this.id = id;
    }
    @JsonProperty("rev")
    public void setRev(@Nullable String rev) {
      this.rev = rev;
    }
    @JsonProperty("name")
    public void setName(@Nullable String name) {
      this.name = name;
    }
    @JsonProperty("matcher")
    public void setMatcher(@Nullable String matcher) {
      this.matcher = matcher;
    }
    @JsonProperty("users")
    public void setUsers(@Nullable List<String> users) {
      this.users = users;
    }
    @JsonProperty("projects")
    public void setProjects(@Nullable List<String> projects) {
      this.projects = projects;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getMatcher() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getUsers() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getProjects() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableBatchGroup fromJson(Json json) {
    ImmutableBatchGroup.Builder builder = ImmutableBatchGroup.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.name != null) {
      builder.name(json.name);
    }
    if (json.matcher != null) {
      builder.matcher(json.matcher);
    }
    if (json.users != null) {
      builder.addAllUsers(json.users);
    }
    if (json.projects != null) {
      builder.addAllProjects(json.projects);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PmRepository.BatchGroup} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable BatchGroup instance
   */
  public static ImmutableBatchGroup copyOf(PmRepository.BatchGroup instance) {
    if (instance instanceof ImmutableBatchGroup) {
      return (ImmutableBatchGroup) instance;
    }
    return ImmutableBatchGroup.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableBatchGroup ImmutableBatchGroup}.
   * <pre>
   * ImmutableBatchGroup.builder()
   *    .id(String | null) // nullable {@link PmRepository.BatchGroup#getId() id}
   *    .rev(String | null) // nullable {@link PmRepository.BatchGroup#getRev() rev}
   *    .name(String | null) // nullable {@link PmRepository.BatchGroup#getName() name}
   *    .matcher(String | null) // nullable {@link PmRepository.BatchGroup#getMatcher() matcher}
   *    .users(List&amp;lt;String&amp;gt; | null) // nullable {@link PmRepository.BatchGroup#getUsers() users}
   *    .projects(List&amp;lt;String&amp;gt; | null) // nullable {@link PmRepository.BatchGroup#getProjects() projects}
   *    .build();
   * </pre>
   * @return A new ImmutableBatchGroup builder
   */
  public static ImmutableBatchGroup.Builder builder() {
    return new ImmutableBatchGroup.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableBatchGroup ImmutableBatchGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRepository.BatchGroup", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable String name;
    private @Nullable String matcher;
    private List<String> users = null;
    private List<String> projects = null;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.hdes.projects.api.PmRepository.BatchGroup} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.BatchGroup instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code io.resys.hdes.projects.api.PmRepository.BatchMutator} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.BatchMutator instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof PmRepository.BatchGroup) {
        PmRepository.BatchGroup instance = (PmRepository.BatchGroup) object;
        @Nullable String nameValue = instance.getName();
        if (nameValue != null) {
          name(nameValue);
        }
        @Nullable List<String> projectsValue = instance.getProjects();
        if (projectsValue != null) {
          addAllProjects(projectsValue);
        }
        @Nullable String matcherValue = instance.getMatcher();
        if (matcherValue != null) {
          matcher(matcherValue);
        }
        @Nullable List<String> usersValue = instance.getUsers();
        if (usersValue != null) {
          addAllUsers(usersValue);
        }
      }
      if (object instanceof PmRepository.BatchMutator) {
        PmRepository.BatchMutator instance = (PmRepository.BatchMutator) object;
        @Nullable String revValue = instance.getRev();
        if (revValue != null) {
          rev(revValue);
        }
        @Nullable String idValue = instance.getId();
        if (idValue != null) {
          id(idValue);
        }
      }
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchGroup#getId() id} attribute.
     * @param id The value for id (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(@Nullable String id) {
      this.id = id;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchGroup#getRev() rev} attribute.
     * @param rev The value for rev (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rev")
    public final Builder rev(@Nullable String rev) {
      this.rev = rev;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchGroup#getName() name} attribute.
     * @param name The value for name (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("name")
    public final Builder name(@Nullable String name) {
      this.name = name;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.BatchGroup#getMatcher() matcher} attribute.
     * @param matcher The value for matcher (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("matcher")
    public final Builder matcher(@Nullable String matcher) {
      this.matcher = matcher;
      return this;
    }

    /**
     * Adds one element to {@link PmRepository.BatchGroup#getUsers() users} list.
     * @param element A users element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUsers(String element) {
      if (this.users == null) {
        this.users = new ArrayList<String>();
      }
      this.users.add(Objects.requireNonNull(element, "users element"));
      return this;
    }

    /**
     * Adds elements to {@link PmRepository.BatchGroup#getUsers() users} list.
     * @param elements An array of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUsers(String... elements) {
      if (this.users == null) {
        this.users = new ArrayList<String>();
      }
      for (String element : elements) {
        this.users.add(Objects.requireNonNull(element, "users element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PmRepository.BatchGroup#getUsers() users} list.
     * @param elements An iterable of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("users")
    public final Builder users(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.users = null;
        return this;
      }
      this.users = new ArrayList<String>();
      return addAllUsers(elements);
    }

    /**
     * Adds elements to {@link PmRepository.BatchGroup#getUsers() users} list.
     * @param elements An iterable of users elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUsers(Iterable<String> elements) {
      Objects.requireNonNull(elements, "users element");
      if (this.users == null) {
        this.users = new ArrayList<String>();
      }
      for (String element : elements) {
        this.users.add(Objects.requireNonNull(element, "users element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link PmRepository.BatchGroup#getProjects() projects} list.
     * @param element A projects element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addProjects(String element) {
      if (this.projects == null) {
        this.projects = new ArrayList<String>();
      }
      this.projects.add(Objects.requireNonNull(element, "projects element"));
      return this;
    }

    /**
     * Adds elements to {@link PmRepository.BatchGroup#getProjects() projects} list.
     * @param elements An array of projects elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addProjects(String... elements) {
      if (this.projects == null) {
        this.projects = new ArrayList<String>();
      }
      for (String element : elements) {
        this.projects.add(Objects.requireNonNull(element, "projects element"));
      }
      return this;
    }


    /**
     * Sets or replaces all elements for {@link PmRepository.BatchGroup#getProjects() projects} list.
     * @param elements An iterable of projects elements
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("projects")
    public final Builder projects(@Nullable Iterable<String> elements) {
      if (elements == null) {
        this.projects = null;
        return this;
      }
      this.projects = new ArrayList<String>();
      return addAllProjects(elements);
    }

    /**
     * Adds elements to {@link PmRepository.BatchGroup#getProjects() projects} list.
     * @param elements An iterable of projects elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllProjects(Iterable<String> elements) {
      Objects.requireNonNull(elements, "projects element");
      if (this.projects == null) {
        this.projects = new ArrayList<String>();
      }
      for (String element : elements) {
        this.projects.add(Objects.requireNonNull(element, "projects element"));
      }
      return this;
    }

    /**
     * Builds a new {@link ImmutableBatchGroup ImmutableBatchGroup}.
     * @return An immutable instance of BatchGroup
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableBatchGroup build() {
      return new ImmutableBatchGroup(
          id,
          rev,
          name,
          matcher,
          users == null ? null : createUnmodifiableList(true, users),
          projects == null ? null : createUnmodifiableList(true, projects));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
