package io.resys.hdes.projects.api;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link PmRepository.Access}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableAccess.builder()}.
 */
@Generated(from = "PmRepository.Access", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
public final class ImmutableAccess implements PmRepository.Access {
  private final String id;
  private final String rev;
  private final LocalDateTime created;
  private final String projectId;
  private final @Nullable String comment;
  private final @Nullable String userId;
  private final @Nullable String groupId;

  private ImmutableAccess(
      String id,
      String rev,
      LocalDateTime created,
      String projectId,
      @Nullable String comment,
      @Nullable String userId,
      @Nullable String groupId) {
    this.id = id;
    this.rev = rev;
    this.created = created;
    this.projectId = projectId;
    this.comment = comment;
    this.userId = userId;
    this.groupId = groupId;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty("id")
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code rev} attribute
   */
  @JsonProperty("rev")
  @Override
  public String getRev() {
    return rev;
  }

  /**
   * @return The value of the {@code created} attribute
   */
  @JsonProperty("created")
  @Override
  public LocalDateTime getCreated() {
    return created;
  }

  /**
   * @return The value of the {@code projectId} attribute
   */
  @JsonProperty("projectId")
  @Override
  public String getProjectId() {
    return projectId;
  }

  /**
   * @return The value of the {@code comment} attribute
   */
  @JsonProperty("comment")
  @Override
  public Optional<String> getComment() {
    return Optional.ofNullable(comment);
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("userId")
  @Override
  public Optional<String> getUserId() {
    return Optional.ofNullable(userId);
  }

  /**
   * @return The value of the {@code groupId} attribute
   */
  @JsonProperty("groupId")
  @Override
  public Optional<String> getGroupId() {
    return Optional.ofNullable(groupId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Access#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccess withId(String value) {
    String newValue = Objects.requireNonNull(value, "id");
    if (this.id.equals(newValue)) return this;
    return new ImmutableAccess(newValue, this.rev, this.created, this.projectId, this.comment, this.userId, this.groupId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Access#getRev() rev} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for rev
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccess withRev(String value) {
    String newValue = Objects.requireNonNull(value, "rev");
    if (this.rev.equals(newValue)) return this;
    return new ImmutableAccess(this.id, newValue, this.created, this.projectId, this.comment, this.userId, this.groupId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Access#getCreated() created} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for created
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccess withCreated(LocalDateTime value) {
    if (this.created == value) return this;
    LocalDateTime newValue = Objects.requireNonNull(value, "created");
    return new ImmutableAccess(this.id, this.rev, newValue, this.projectId, this.comment, this.userId, this.groupId);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PmRepository.Access#getProjectId() projectId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for projectId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableAccess withProjectId(String value) {
    String newValue = Objects.requireNonNull(value, "projectId");
    if (this.projectId.equals(newValue)) return this;
    return new ImmutableAccess(this.id, this.rev, this.created, newValue, this.comment, this.userId, this.groupId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PmRepository.Access#getComment() comment} attribute.
   * @param value The value for comment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccess withComment(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "comment");
    if (Objects.equals(this.comment, newValue)) return this;
    return new ImmutableAccess(this.id, this.rev, this.created, this.projectId, newValue, this.userId, this.groupId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PmRepository.Access#getComment() comment} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for comment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccess withComment(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.comment, value)) return this;
    return new ImmutableAccess(this.id, this.rev, this.created, this.projectId, value, this.userId, this.groupId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PmRepository.Access#getUserId() userId} attribute.
   * @param value The value for userId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccess withUserId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "userId");
    if (Objects.equals(this.userId, newValue)) return this;
    return new ImmutableAccess(this.id, this.rev, this.created, this.projectId, this.comment, newValue, this.groupId);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PmRepository.Access#getUserId() userId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for userId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccess withUserId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.userId, value)) return this;
    return new ImmutableAccess(this.id, this.rev, this.created, this.projectId, this.comment, value, this.groupId);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link PmRepository.Access#getGroupId() groupId} attribute.
   * @param value The value for groupId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccess withGroupId(String value) {
    @Nullable String newValue = Objects.requireNonNull(value, "groupId");
    if (Objects.equals(this.groupId, newValue)) return this;
    return new ImmutableAccess(this.id, this.rev, this.created, this.projectId, this.comment, this.userId, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link PmRepository.Access#getGroupId() groupId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for groupId
   * @return A modified copy of {@code this} object
   */
  public final ImmutableAccess withGroupId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.groupId, value)) return this;
    return new ImmutableAccess(this.id, this.rev, this.created, this.projectId, this.comment, this.userId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableAccess} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableAccess
        && equalTo((ImmutableAccess) another);
  }

  private boolean equalTo(ImmutableAccess another) {
    return id.equals(another.id)
        && rev.equals(another.rev)
        && created.equals(another.created)
        && projectId.equals(another.projectId)
        && Objects.equals(comment, another.comment)
        && Objects.equals(userId, another.userId)
        && Objects.equals(groupId, another.groupId);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code rev}, {@code created}, {@code projectId}, {@code comment}, {@code userId}, {@code groupId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + rev.hashCode();
    h += (h << 5) + created.hashCode();
    h += (h << 5) + projectId.hashCode();
    h += (h << 5) + Objects.hashCode(comment);
    h += (h << 5) + Objects.hashCode(userId);
    h += (h << 5) + Objects.hashCode(groupId);
    return h;
  }

  /**
   * Prints the immutable value {@code Access} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Access{");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("rev=").append(rev);
    builder.append(", ");
    builder.append("created=").append(created);
    builder.append(", ");
    builder.append("projectId=").append(projectId);
    if (comment != null) {
      builder.append(", ");
      builder.append("comment=").append(comment);
    }
    if (userId != null) {
      builder.append(", ");
      builder.append("userId=").append(userId);
    }
    if (groupId != null) {
      builder.append(", ");
      builder.append("groupId=").append(groupId);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "PmRepository.Access", generator = "Immutables")
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PmRepository.Access {
    @Nullable String id;
    @Nullable String rev;
    @Nullable LocalDateTime created;
    @Nullable String projectId;
    @Nullable Optional<String> comment = Optional.empty();
    @Nullable Optional<String> userId = Optional.empty();
    @Nullable Optional<String> groupId = Optional.empty();
    @JsonProperty("id")
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("rev")
    public void setRev(String rev) {
      this.rev = rev;
    }
    @JsonProperty("created")
    public void setCreated(LocalDateTime created) {
      this.created = created;
    }
    @JsonProperty("projectId")
    public void setProjectId(String projectId) {
      this.projectId = projectId;
    }
    @JsonProperty("comment")
    public void setComment(Optional<String> comment) {
      this.comment = comment;
    }
    @JsonProperty("userId")
    public void setUserId(Optional<String> userId) {
      this.userId = userId;
    }
    @JsonProperty("groupId")
    public void setGroupId(Optional<String> groupId) {
      this.groupId = groupId;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getRev() { throw new UnsupportedOperationException(); }
    @Override
    public LocalDateTime getCreated() { throw new UnsupportedOperationException(); }
    @Override
    public String getProjectId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getComment() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getGroupId() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableAccess fromJson(Json json) {
    ImmutableAccess.Builder builder = ImmutableAccess.builder();
    if (json.id != null) {
      builder.id(json.id);
    }
    if (json.rev != null) {
      builder.rev(json.rev);
    }
    if (json.created != null) {
      builder.created(json.created);
    }
    if (json.projectId != null) {
      builder.projectId(json.projectId);
    }
    if (json.comment != null) {
      builder.comment(json.comment);
    }
    if (json.userId != null) {
      builder.userId(json.userId);
    }
    if (json.groupId != null) {
      builder.groupId(json.groupId);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PmRepository.Access} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Access instance
   */
  public static ImmutableAccess copyOf(PmRepository.Access instance) {
    if (instance instanceof ImmutableAccess) {
      return (ImmutableAccess) instance;
    }
    return ImmutableAccess.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableAccess ImmutableAccess}.
   * <pre>
   * ImmutableAccess.builder()
   *    .id(String) // required {@link PmRepository.Access#getId() id}
   *    .rev(String) // required {@link PmRepository.Access#getRev() rev}
   *    .created(java.time.LocalDateTime) // required {@link PmRepository.Access#getCreated() created}
   *    .projectId(String) // required {@link PmRepository.Access#getProjectId() projectId}
   *    .comment(String) // optional {@link PmRepository.Access#getComment() comment}
   *    .userId(String) // optional {@link PmRepository.Access#getUserId() userId}
   *    .groupId(String) // optional {@link PmRepository.Access#getGroupId() groupId}
   *    .build();
   * </pre>
   * @return A new ImmutableAccess builder
   */
  public static ImmutableAccess.Builder builder() {
    return new ImmutableAccess.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableAccess ImmutableAccess}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "PmRepository.Access", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_REV = 0x2L;
    private static final long INIT_BIT_CREATED = 0x4L;
    private static final long INIT_BIT_PROJECT_ID = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String id;
    private @Nullable String rev;
    private @Nullable LocalDateTime created;
    private @Nullable String projectId;
    private @Nullable String comment;
    private @Nullable String userId;
    private @Nullable String groupId;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Access} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PmRepository.Access instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      rev(instance.getRev());
      created(instance.getCreated());
      projectId(instance.getProjectId());
      Optional<String> commentOptional = instance.getComment();
      if (commentOptional.isPresent()) {
        comment(commentOptional);
      }
      Optional<String> userIdOptional = instance.getUserId();
      if (userIdOptional.isPresent()) {
        userId(userIdOptional);
      }
      Optional<String> groupIdOptional = instance.getGroupId();
      if (groupIdOptional.isPresent()) {
        groupId(groupIdOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Access#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("id")
    public final Builder id(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Access#getRev() rev} attribute.
     * @param rev The value for rev 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("rev")
    public final Builder rev(String rev) {
      this.rev = Objects.requireNonNull(rev, "rev");
      initBits &= ~INIT_BIT_REV;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Access#getCreated() created} attribute.
     * @param created The value for created 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("created")
    public final Builder created(LocalDateTime created) {
      this.created = Objects.requireNonNull(created, "created");
      initBits &= ~INIT_BIT_CREATED;
      return this;
    }

    /**
     * Initializes the value for the {@link PmRepository.Access#getProjectId() projectId} attribute.
     * @param projectId The value for projectId 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("projectId")
    public final Builder projectId(String projectId) {
      this.projectId = Objects.requireNonNull(projectId, "projectId");
      initBits &= ~INIT_BIT_PROJECT_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.Access#getComment() comment} to comment.
     * @param comment The value for comment
     * @return {@code this} builder for chained invocation
     */
    public final Builder comment(String comment) {
      this.comment = Objects.requireNonNull(comment, "comment");
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.Access#getComment() comment} to comment.
     * @param comment The value for comment
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("comment")
    public final Builder comment(Optional<String> comment) {
      this.comment = comment.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.Access#getUserId() userId} to userId.
     * @param userId The value for userId
     * @return {@code this} builder for chained invocation
     */
    public final Builder userId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.Access#getUserId() userId} to userId.
     * @param userId The value for userId
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("userId")
    public final Builder userId(Optional<String> userId) {
      this.userId = userId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.Access#getGroupId() groupId} to groupId.
     * @param groupId The value for groupId
     * @return {@code this} builder for chained invocation
     */
    public final Builder groupId(String groupId) {
      this.groupId = Objects.requireNonNull(groupId, "groupId");
      return this;
    }

    /**
     * Initializes the optional value {@link PmRepository.Access#getGroupId() groupId} to groupId.
     * @param groupId The value for groupId
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("groupId")
    public final Builder groupId(Optional<String> groupId) {
      this.groupId = groupId.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableAccess ImmutableAccess}.
     * @return An immutable instance of Access
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableAccess build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableAccess(id, rev, created, projectId, comment, userId, groupId);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_REV) != 0) attributes.add("rev");
      if ((initBits & INIT_BIT_CREATED) != 0) attributes.add("created");
      if ((initBits & INIT_BIT_PROJECT_ID) != 0) attributes.add("projectId");
      return "Cannot build Access, some of required attributes are not set " + attributes;
    }
  }
}
