/*
 * Decompiled with CFR 0.152.
 */
package restx.specs.shell;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import restx.AppSettings;
import restx.Apps;
import restx.core.shell.DepsShellCommand;
import restx.core.shell.ShellAppRunner;
import restx.factory.Component;
import restx.factory.FactoryMachine;
import restx.factory.NamedComponent;
import restx.factory.SingletonFactoryMachine;
import restx.server.simple.simple.SimpleWebServer;
import restx.shell.RestxShell;
import restx.shell.ShellCommandRunner;
import restx.shell.StdShellCommand;

@Component
public class SpecsShellCommand
extends StdShellCommand {
    protected SpecsShellCommand() {
        super(ImmutableList.of((Object)"spec"), "restx spec commands: server, test, ... ");
    }

    protected String resourceMan() {
        return "restx/specs/shell/spec.man";
    }

    protected Optional<ShellCommandRunner> doMatch(String line) {
        List args = this.splitArgs(line);
        if (args.size() < 2) {
            return Optional.absent();
        }
        switch ((String)args.get(1)) {
            case "server": {
                return Optional.of((Object)new SpecServerCommandRunner(args));
            }
            case "test": {
                if (args.size() <= 2 || !((String)args.get(2)).equals("server")) break;
                return Optional.of((Object)new SpecTestServerCommandRunner(args));
            }
        }
        return Optional.absent();
    }

    public Iterable<Completer> getCompleters() {
        return ImmutableList.of((Object)new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{"spec"}), new StringsCompleter(new String[]{"server", "test"}), new StringsCompleter(new String[]{"server"})}));
    }

    private class SpecServerCommandRunner
    implements ShellCommandRunner {
        private final List<String> args;

        public SpecServerCommandRunner(List<String> args) {
            this.args = args;
        }

        public void run(RestxShell shell) throws Exception {
            String routerPath = this.args.size() > 2 ? this.args.get(2) : "/api";
            int port = 8888;
            if (this.args.size() > 3) {
                port = Integer.parseInt(this.args.get(3));
            }
            System.setProperty("restx.factory.load", "onrequest");
            SimpleWebServer webServer = SimpleWebServer.builder().setRouterPath(routerPath).setAppBase(".").setPort(port).build();
            webServer.start();
            String uri = webServer.baseUrl() + routerPath;
            shell.printIn("SPECS SERVER READY on " + uri + "/\n", "\u001b[32m");
            shell.println("type `stop` to stop the server, `help` to get help on available commands");
            shell.getConsoleReader().setPrompt("spec-server> ");
            shell.getConsoleReader().addCompleter((Completer)new StringsCompleter(new String[]{"stop", "open", "help"}));
            boolean exit = false;
            block10: while (!exit) {
                String line;
                switch (line = shell.getConsoleReader().readLine().trim()) {
                    case "stop": {
                        exit = this.stop(shell, webServer);
                        continue block10;
                    }
                    case "open": {
                        this.openInBrowser(shell, uri);
                        continue block10;
                    }
                    case "help": {
                        this.help(shell);
                        continue block10;
                    }
                }
                shell.println("command not found. use `help` to get the list of commands.");
            }
        }

        private void openInBrowser(RestxShell shell, String uri) throws IOException {
            try {
                Desktop.getDesktop().browse(new URI(uri));
            }
            catch (UnsupportedOperationException e) {
                shell.printIn("can't open browser: " + e.getMessage(), "\u001b[31m");
            }
            catch (IOException e) {
                shell.printIn("can't open browser: " + e.getMessage(), "\u001b[31m");
            }
            catch (URISyntaxException e) {
                shell.printIn("can't open browser: " + e.getMessage(), "\u001b[31m");
            }
        }

        private boolean stop(RestxShell consoleReader, SimpleWebServer webServer) {
            boolean exit;
            try {
                consoleReader.println("stopping server...");
                webServer.stop();
                exit = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return exit;
        }

        private void help(RestxShell shell) throws IOException {
            shell.printIn("stop", "\u001b[32m");
            shell.println(" - to stop the server");
            shell.printIn("open", "\u001b[32m");
            shell.println(" - open a browser on the spec server");
            shell.printIn("help", "\u001b[32m");
            shell.println(" - this help");
            shell.println("");
            shell.println("to add new routes simply create/edit .spec.yaml file in\ncurrent directory or subdirectories.");
        }
    }

    private class SpecTestServerCommandRunner
    implements ShellCommandRunner {
        private final List<String> args;

        public SpecTestServerCommandRunner(List<String> args) {
            this.args = new ArrayList<String>(args);
        }

        public void run(RestxShell shell) throws Exception {
            String basePack;
            boolean quiet = false;
            if (this.args.size() > 3 && this.args.get(3).equalsIgnoreCase("--quiet")) {
                this.args.remove(3);
                quiet = true;
            }
            if (this.args.size() > 3) {
                basePack = this.args.get(3);
            } else {
                Optional pack = Apps.with((AppSettings)((AppSettings)shell.getFactory().getComponent(AppSettings.class))).guessAppBasePackage(shell.currentLocation());
                if (!pack.isPresent()) {
                    shell.printIn("can't find base app package, src/main/java should contain a AppServer.java source file somewhere", "\u001b[31m");
                    shell.println("");
                    shell.println("alternatively you can provide the base package with `spec test server <base.pack>`");
                    return;
                }
                basePack = (String)pack.get();
            }
            AppSettings appSettings = (AppSettings)shell.getFactory().concat((FactoryMachine)new SingletonFactoryMachine(-10000, NamedComponent.of(String.class, (String)"restx.app.package", (Object)basePack))).getComponent(AppSettings.class);
            if (!DepsShellCommand.depsUpToDate((RestxShell)shell)) {
                shell.println("restx> deps install");
                new DepsShellCommand.InstallDepsCommandRunner(new DepsShellCommand()).run(shell);
            }
            new ShellAppRunner(appSettings, "restx.tests.RestxSpecTestServer", ShellAppRunner.CompileMode.RESOURCES_ONLY, quiet, false, Collections.emptyList()).run(shell);
        }
    }
}

