/*
 * Decompiled with CFR 0.152.
 */
package restx.specs.shell;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import restx.factory.Component;
import restx.server.simple.simple.SimpleWebServer;
import restx.shell.RestxShell;
import restx.shell.ShellCommandRunner;
import restx.shell.StdShellCommand;

@Component
public class SpecsShellCommand
extends StdShellCommand {
    protected SpecsShellCommand() {
        super(ImmutableList.of((Object)"spec"), "restx spec commands: list, server, ... ");
    }

    protected Optional<ShellCommandRunner> doMatch(String line) {
        List args = this.splitArgs(line);
        if (args.size() < 2) {
            return Optional.absent();
        }
        switch ((String)args.get(1)) {
            case "server": {
                return Optional.of((Object)new SpecServerCommandRunner(args));
            }
        }
        return Optional.absent();
    }

    public Iterable<Completer> getCompleters() {
        return ImmutableList.of((Object)new ArgumentCompleter(new Completer[]{new StringsCompleter(new String[]{"spec"}), new StringsCompleter(new String[]{"server"})}));
    }

    private class SpecServerCommandRunner
    implements ShellCommandRunner {
        private final List<String> args;

        public SpecServerCommandRunner(List<String> args) {
            this.args = args;
        }

        public void run(RestxShell shell) throws Exception {
            String routerPath = this.args.size() > 2 ? this.args.get(2) : "/api";
            int port = 8888;
            if (this.args.size() > 3) {
                port = Integer.parseInt(this.args.get(3));
            }
            System.setProperty("restx.factory.load", "onrequest");
            SimpleWebServer webServer = new SimpleWebServer(routerPath, ".", port);
            webServer.start();
            String uri = webServer.baseUrl() + routerPath;
            shell.printIn("SPECS SERVER READY on " + uri + "/\n", "\u001b[32m");
            shell.println("type `stop` to stop the server, `help` to get help on available commands");
            shell.getConsoleReader().setPrompt("spec-server> ");
            shell.getConsoleReader().addCompleter((Completer)new StringsCompleter(new String[]{"stop", "open", "help"}));
            boolean exit = false;
            block10: while (!exit) {
                String line;
                switch (line = shell.getConsoleReader().readLine().trim()) {
                    case "stop": {
                        exit = this.stop(shell, webServer);
                        continue block10;
                    }
                    case "open": {
                        this.openInBrowser(shell, uri);
                        continue block10;
                    }
                    case "help": {
                        this.help(shell);
                        continue block10;
                    }
                }
                shell.println("command not found. use `help` to get the list of commands.");
            }
        }

        private void openInBrowser(RestxShell shell, String uri) throws IOException {
            try {
                Desktop.getDesktop().browse(new URI(uri));
            }
            catch (UnsupportedOperationException e) {
                shell.printIn("can't open browser: " + e.getMessage(), "\u001b[31m");
            }
            catch (IOException e) {
                shell.printIn("can't open browser: " + e.getMessage(), "\u001b[31m");
            }
            catch (URISyntaxException e) {
                shell.printIn("can't open browser: " + e.getMessage(), "\u001b[31m");
            }
        }

        private boolean stop(RestxShell consoleReader, SimpleWebServer webServer) {
            boolean exit;
            try {
                consoleReader.println("stopping server...");
                webServer.stop();
                exit = true;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return exit;
        }

        private void help(RestxShell shell) throws IOException {
            shell.printIn("stop", "\u001b[32m");
            shell.println(" - to stop the server");
            shell.printIn("open", "\u001b[32m");
            shell.println(" - open a browser on the spec server");
            shell.printIn("help", "\u001b[32m");
            shell.println(" - this help");
            shell.println("");
            shell.println("to add new routes simply create/edit .spec.yaml file in\ncurrent directory or subdirectories.");
        }
    }
}

