/*
 * Decompiled with CFR 0.152.
 */
package restx.exceptions;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Named;
import restx.RestxRequest;
import restx.RestxRequestMatch;
import restx.RestxRequestMatcher;
import restx.StdRestxRequestMatcher;
import restx.exceptions.ErrorDescriptor;
import restx.factory.Component;
import restx.jackson.StdJsonProducerEntityRoute;

@Component
public class ErrorDescriptorsRoute
extends StdJsonProducerEntityRoute {
    private final ImmutableMap<String, ErrorDescriptor> errorDescriptors;

    public ErrorDescriptorsRoute(Iterable<ErrorDescriptor> errorDescriptors, @Named(value="FrontObjectWriter") ObjectWriter objectWriter) {
        super("ErrorDescriptorsRoute", objectWriter, (RestxRequestMatcher)new StdRestxRequestMatcher("GET", "/@/errors/descriptors"));
        LinkedHashMap map = Maps.newLinkedHashMap();
        for (ErrorDescriptor errorDescriptor : errorDescriptors) {
            if (map.containsKey(errorDescriptor.getErrorCode())) {
                throw new IllegalStateException("duplicate error code found: " + errorDescriptor.getErrorCode());
            }
            map.put(errorDescriptor.getErrorCode(), errorDescriptor);
        }
        this.errorDescriptors = ImmutableMap.copyOf((Map)map);
    }

    protected Optional<?> doRoute(RestxRequest restxRequest, RestxRequestMatch match, Object i) throws IOException {
        return Optional.of((Object)this.errorDescriptors.values());
    }
}

