/*
 * Decompiled with CFR 0.152.
 */
package restx.admin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import restx.admin.AdminPage;
import restx.annotations.GET;
import restx.annotations.Param;
import restx.annotations.RestxResource;
import restx.factory.Component;
import restx.security.RolesAllowed;

@Component
@RestxResource(group="restx-admin")
public class AdminPagesResource {
    private final Iterable<AdminPage> pages;

    public AdminPagesResource(Iterable<AdminPage> pages) {
        this.pages = pages;
    }

    @RolesAllowed(value={"restx-admin"})
    @GET(value="/@/pages")
    public Iterable<AdminPage> findPages(@Param(kind=Param.Kind.CONTEXT, value="baseUri") String baseUri) {
        ArrayList rootedPages = Lists.newArrayList();
        for (AdminPage page : this.pages) {
            rootedPages.add(page.rootOn(baseUri));
        }
        return rootedPages;
    }
}

