/*
 * Decompiled with CFR 0.152.
 */
package restx.admin;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import com.google.common.hash.Hashing;
import javax.inject.Named;
import restx.factory.Module;
import restx.factory.Provides;
import restx.security.BasicPrincipalAuthenticator;
import restx.security.RestxPrincipal;
import restx.security.SecuritySettings;
import restx.security.StdBasicPrincipalAuthenticator;
import restx.security.UserService;

@Module(priority=10000)
public class AdminModule {
    public static final String RESTX_ADMIN_ROLE = "restx-admin";
    public static final RestxAdminPrincipal RESTX_ADMIN_PRINCIPAL = new RestxAdminPrincipal();

    @Named(value="restx.admin.password")
    @Provides
    public String restxAdminPassword() {
        return "juma";
    }

    @Named(value="restx.admin.passwordHash")
    @Provides
    public String restxAdminPasswordHash(@Named(value="restx.admin.password") String password) {
        return Hashing.md5().hashString((CharSequence)password, Charsets.UTF_8).toString();
    }

    @Provides
    public BasicPrincipalAuthenticator basicPrincipalAuthenticator(final @Named(value="restx.admin.passwordHash") String adminPasswordHash, SecuritySettings securitySettings) {
        return new StdBasicPrincipalAuthenticator((UserService)new UserService<RestxAdminPrincipal>(){

            public Optional<RestxAdminPrincipal> findUserByName(String name) {
                return "admin".equals(name) ? Optional.of((Object)RESTX_ADMIN_PRINCIPAL) : Optional.absent();
            }

            public Optional<RestxAdminPrincipal> findAndCheckCredentials(String name, String passwordHash) {
                return "admin".equals(name) && adminPasswordHash.equals(passwordHash) ? Optional.of((Object)RESTX_ADMIN_PRINCIPAL) : Optional.absent();
            }
        }, securitySettings);
    }

    public static class RestxAdminPrincipal
    implements RestxPrincipal {
        public ImmutableSet<String> getPrincipalRoles() {
            return ImmutableSet.of((Object)AdminModule.RESTX_ADMIN_ROLE);
        }

        public String getName() {
            return "admin";
        }
    }
}

