/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.internal;

import io.restassured.authentication.AuthenticationScheme;
import io.restassured.authentication.NoAuthScheme;
import io.restassured.builder.MultiPartSpecBuilder;
import io.restassured.filter.FilterContext;
import io.restassured.filter.log.RequestLoggingFilter;
import io.restassured.http.Cookie;
import io.restassured.http.Cookies;
import io.restassured.http.Header;
import io.restassured.http.Headers;
import io.restassured.http.Method;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.internal.ResponseParserRegistrar;
import io.restassured.internal.ResponseSpecificationImpl;
import io.restassured.internal.common.assertion.AssertParameter;
import io.restassured.internal.filter.FilterContextImpl;
import io.restassured.internal.log.LogRepository;
import io.restassured.internal.support.PathSupport;
import io.restassured.internal.util.SafeExceptionRethrower;
import io.restassured.module.mockmvc.config.RestAssuredMockMvcConfig;
import io.restassured.module.mockmvc.intercept.MockHttpServletRequestBuilderInterceptor;
import io.restassured.module.mockmvc.internal.MockMvcMultiPart;
import io.restassured.module.mockmvc.internal.MockMvcRestAssuredResponseImpl;
import io.restassured.module.mockmvc.internal.ResponseConverter;
import io.restassured.module.mockmvc.internal.RestDocsClassPathChecker;
import io.restassured.module.mockmvc.internal.SpringSecurityClassPathChecker;
import io.restassured.module.mockmvc.response.MockMvcResponse;
import io.restassured.module.mockmvc.specification.MockMvcRequestAsyncConfigurer;
import io.restassured.module.mockmvc.specification.MockMvcRequestAsyncSender;
import io.restassured.module.mockmvc.specification.MockMvcRequestSender;
import io.restassured.module.spring.commons.BodyHelper;
import io.restassured.module.spring.commons.HeaderHelper;
import io.restassured.module.spring.commons.ParamApplier;
import io.restassured.module.spring.commons.RequestLogger;
import io.restassured.module.spring.commons.config.AsyncConfig;
import io.restassured.module.spring.commons.config.ConfigConverter;
import io.restassured.module.spring.commons.config.SpecificationConfig;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.ResponseSpecification;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.Cookie;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.MvcResult;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.request.MockHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMultipartHttpServletRequestBuilder;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.web.util.UriComponentsBuilder;

class MockMvcRequestSenderImpl
implements MockMvcRequestSender,
MockMvcRequestAsyncConfigurer,
MockMvcRequestAsyncSender {
    private static final String ATTRIBUTE_NAME_URL_TEMPLATE = "org.springframework.restdocs.urlTemplate";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String CHARSET = "charset";
    private final MockMvc mockMvc;
    private final Map<String, Object> params;
    private final Map<String, Object> queryParams;
    private final Map<String, Object> formParams;
    private final Map<String, Object> attributes;
    private final RestAssuredMockMvcConfig config;
    private final Object requestBody;
    private Headers headers;
    private final Cookies cookies;
    private final List<MockMvcMultiPart> multiParts;
    private final RequestLoggingFilter requestLoggingFilter;
    private final List<ResultHandler> resultHandlers;
    private final List<RequestPostProcessor> requestPostProcessors;
    private final MockHttpServletRequestBuilderInterceptor interceptor;
    private final String basePath;
    private final ResponseSpecification responseSpecification;
    private final Object authentication;
    private final LogRepository logRepository;
    private final boolean isAsyncRequest;
    private final Map<String, Object> sessionAttributes;

    MockMvcRequestSenderImpl(MockMvc mockMvc, Map<String, Object> params, Map<String, Object> queryParams, Map<String, Object> formParams, Map<String, Object> attributes, RestAssuredMockMvcConfig config, Object requestBody, Headers headers, Cookies cookies, Map<String, Object> sessionAttributes, List<MockMvcMultiPart> multiParts, RequestLoggingFilter requestLoggingFilter, List<ResultHandler> resultHandlers, List<RequestPostProcessor> requestPostProcessors, MockHttpServletRequestBuilderInterceptor interceptor, String basePath, ResponseSpecification responseSpecification, Object authentication, LogRepository logRepository) {
        this(mockMvc, params, queryParams, formParams, attributes, config, requestBody, headers, cookies, sessionAttributes, multiParts, requestLoggingFilter, resultHandlers, requestPostProcessors, interceptor, basePath, responseSpecification, authentication, logRepository, false);
    }

    private MockMvcRequestSenderImpl(MockMvc mockMvc, Map<String, Object> params, Map<String, Object> queryParams, Map<String, Object> formParams, Map<String, Object> attributes, RestAssuredMockMvcConfig config, Object requestBody, Headers headers, Cookies cookies, Map<String, Object> sessionAttributes, List<MockMvcMultiPart> multiParts, RequestLoggingFilter requestLoggingFilter, List<ResultHandler> resultHandlers, List<RequestPostProcessor> requestPostProcessors, MockHttpServletRequestBuilderInterceptor interceptor, String basePath, ResponseSpecification responseSpecification, Object authentication, LogRepository logRepository, boolean isAsyncRequest) {
        this.mockMvc = mockMvc;
        this.params = params;
        this.queryParams = queryParams;
        this.formParams = formParams;
        this.attributes = attributes;
        this.config = config;
        this.requestBody = requestBody;
        this.headers = headers;
        this.cookies = cookies;
        this.sessionAttributes = sessionAttributes;
        this.multiParts = multiParts;
        this.requestLoggingFilter = requestLoggingFilter;
        this.resultHandlers = resultHandlers;
        this.requestPostProcessors = requestPostProcessors;
        this.interceptor = interceptor;
        this.basePath = basePath;
        this.responseSpecification = responseSpecification;
        this.authentication = authentication;
        this.logRepository = logRepository;
        this.isAsyncRequest = isAsyncRequest;
    }

    private Object assembleHeaders(MockHttpServletResponse response) {
        Collection headerNames = response.getHeaderNames();
        ArrayList<Header> headers = new ArrayList<Header>();
        for (String headerName : headerNames) {
            List headerValues = response.getHeaders(headerName);
            for (String headerValue : headerValues) {
                headers.add(new Header(headerName, headerValue));
            }
        }
        return new Headers(headers);
    }

    private Cookies convertCookies(Cookie[] servletCookies) {
        ArrayList<io.restassured.http.Cookie> cookies = new ArrayList<io.restassured.http.Cookie>();
        for (Cookie servletCookie : servletCookies) {
            Cookie.Builder cookieBuilder = new Cookie.Builder(servletCookie.getName(), servletCookie.getValue());
            if (servletCookie.getComment() != null) {
                cookieBuilder.setComment(servletCookie.getComment());
            }
            if (servletCookie.getDomain() != null) {
                cookieBuilder.setDomain(servletCookie.getDomain());
            }
            if (servletCookie.getPath() != null) {
                cookieBuilder.setPath(servletCookie.getPath());
            }
            cookieBuilder.setMaxAge(servletCookie.getMaxAge());
            cookieBuilder.setVersion(servletCookie.getVersion());
            cookieBuilder.setSecured(servletCookie.getSecure());
            cookies.add(cookieBuilder.build());
        }
        return new Cookies(cookies);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MockMvcResponse performRequest(MockHttpServletRequestBuilder requestBuilder) {
        MockMvcRestAssuredResponseImpl restAssuredResponse;
        if (this.interceptor != null) {
            this.interceptor.intercept(requestBuilder);
        }
        if (SpringSecurityClassPathChecker.isSpringSecurityInClasspath() && this.authentication instanceof Authentication) {
            SecurityContextHolder.getContext().setAuthentication((Authentication)this.authentication);
        }
        if (this.authentication instanceof Principal) {
            requestBuilder.principal((Principal)this.authentication);
        }
        for (RequestPostProcessor requestPostProcessor : this.requestPostProcessors) {
            requestBuilder.with(requestPostProcessor);
        }
        try {
            long start = System.currentTimeMillis();
            ResultActions perform = this.mockMvc.perform((RequestBuilder)requestBuilder);
            final long responseTime = System.currentTimeMillis() - start;
            if (!this.resultHandlers.isEmpty()) {
                for (ResultHandler resultHandler : this.resultHandlers) {
                    perform.andDo(resultHandler);
                }
            }
            MvcResult mvcResult = this.getMvcResult(perform, this.isAsyncRequest);
            MockHttpServletResponse response = mvcResult.getResponse();
            restAssuredResponse = new MockMvcRestAssuredResponseImpl(perform, this.logRepository);
            restAssuredResponse.setConfig(ConfigConverter.convertToRestAssuredConfig((SpecificationConfig)this.config));
            restAssuredResponse.setDecoderConfig(this.config.getDecoderConfig());
            restAssuredResponse.setContent(response.getContentAsByteArray());
            restAssuredResponse.setContentType(response.getContentType());
            restAssuredResponse.setHasExpectations(false);
            restAssuredResponse.setStatusCode(response.getStatus());
            restAssuredResponse.setResponseHeaders(this.assembleHeaders(response));
            restAssuredResponse.setRpr(this.getRpr());
            restAssuredResponse.setStatusLine(this.assembleStatusLine(response, mvcResult.getResolvedException()));
            restAssuredResponse.setFilterContextProperties(new HashMap(){
                {
                    this.put("RA_RESPONSE_TIME_MILLIS", responseTime);
                }
            });
            restAssuredResponse.setCookies(this.convertCookies(response.getCookies()));
            if (this.responseSpecification != null) {
                this.responseSpecification.validate(ResponseConverter.toStandardResponse(restAssuredResponse));
            }
        }
        catch (Exception e) {
            MockMvcResponse mockMvcResponse = (MockMvcResponse)SafeExceptionRethrower.safeRethrow((Throwable)e);
            return mockMvcResponse;
        }
        finally {
            if (SpringSecurityClassPathChecker.isSpringSecurityInClasspath()) {
                SecurityContextHolder.clearContext();
            }
        }
        return restAssuredResponse;
    }

    private MvcResult getMvcResult(ResultActions perform, boolean isAsyncRequest) throws Exception {
        MvcResult mvcResult;
        if (isAsyncRequest) {
            MvcResult startedAsyncRequestProcessing = perform.andExpect(MockMvcResultMatchers.request().asyncStarted()).andReturn();
            startedAsyncRequestProcessing.getAsyncResult(this.config.getAsyncConfig().timeoutInMs());
            mvcResult = this.mockMvc.perform(MockMvcRequestBuilders.asyncDispatch((MvcResult)startedAsyncRequestProcessing)).andReturn();
        } else {
            mvcResult = perform.andReturn();
        }
        return mvcResult;
    }

    private ResponseParserRegistrar getRpr() {
        if (this.responseSpecification instanceof ResponseSpecificationImpl) {
            return ((ResponseSpecificationImpl)this.responseSpecification).getRpr();
        }
        return new ResponseParserRegistrar();
    }

    private String assembleStatusLine(MockHttpServletResponse response, Exception resolvedException) {
        StringBuilder builder = new StringBuilder();
        builder.append(response.getStatus());
        if (StringUtils.isNotBlank((CharSequence)response.getErrorMessage())) {
            builder.append(" ").append(response.getErrorMessage());
        } else if (resolvedException != null) {
            builder.append(" ").append(resolvedException.getMessage());
        }
        return builder.toString();
    }

    private MockMvcResponse sendRequest(final HttpMethod method, String path, Object[] pathParams) {
        MockHttpServletRequestBuilder request;
        AssertParameter.notNull((Object)path, (String)"Path");
        if (this.requestBody != null && !this.multiParts.isEmpty()) {
            throw new IllegalStateException("You cannot specify a request body and a multi-part body in the same request. Perhaps you want to change the body to a multi part?");
        }
        String baseUri = StringUtils.isNotBlank((CharSequence)this.basePath) ? PathSupport.mergeAndRemoveDoubleSlash((String)this.basePath, (String)path) : path;
        final UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromUriString((String)baseUri);
        if (!this.queryParams.isEmpty()) {
            new ParamApplier(this.queryParams){

                protected void applyParam(String paramName, String[] paramValues) {
                    uriComponentsBuilder.queryParam(paramName, (Object[])paramValues);
                }
            }.applyParams();
        }
        String uri = uriComponentsBuilder.build().toUriString();
        if (this.multiParts.isEmpty()) {
            request = MockMvcRequestBuilders.request((HttpMethod)method, (String)uri, (Object[])pathParams);
        } else if (method == HttpMethod.POST || method == HttpMethod.PUT) {
            request = MockMvcRequestBuilders.fileUpload((String)uri, (Object[])pathParams);
            request.with(new RequestPostProcessor(){

                public MockHttpServletRequest postProcessRequest(MockHttpServletRequest request) {
                    request.setMethod(method.name());
                    return request;
                }
            });
        } else {
            throw new IllegalArgumentException("Currently multi-part file data uploading only works for POST and PUT methods");
        }
        String requestContentType = HeaderHelper.findContentType((Headers)this.headers, this.multiParts, (SpecificationConfig)this.config);
        if (!this.params.isEmpty()) {
            new ParamApplier(this.params){

                protected void applyParam(String paramName, String[] paramValues) {
                    request.param(paramName, paramValues);
                }
            }.applyParams();
            if (StringUtils.isBlank((CharSequence)requestContentType) && method == HttpMethod.POST && !this.isInMultiPartMode(request)) {
                this.setContentTypeToApplicationFormUrlEncoded(request);
            }
        }
        if (!this.formParams.isEmpty()) {
            if (method == HttpMethod.GET) {
                throw new IllegalArgumentException("Cannot use form parameters in a GET request");
            }
            new ParamApplier(this.formParams){

                protected void applyParam(String paramName, String[] paramValues) {
                    request.param(paramName, paramValues);
                }
            }.applyParams();
            boolean isInMultiPartMode = this.isInMultiPartMode(request);
            if (StringUtils.isBlank((CharSequence)requestContentType) && !isInMultiPartMode) {
                this.setContentTypeToApplicationFormUrlEncoded(request);
            }
        }
        if (!this.attributes.isEmpty()) {
            new ParamApplier(this.attributes){

                protected void applyParam(String paramName, String[] paramValues) {
                    request.requestAttr(paramName, (Object)paramValues[0]);
                }
            }.applyParams();
        }
        if (RestDocsClassPathChecker.isSpringRestDocsInClasspath() && this.config.getMockMvcConfig().shouldAutomaticallyApplySpringRestDocsMockMvcSupport()) {
            request.requestAttr(ATTRIBUTE_NAME_URL_TEMPLATE, (Object)PathSupport.getPath((String)uri));
        }
        if (this.headers.exist()) {
            for (Header header : this.headers) {
                request.header(header.getName(), new Object[]{header.getValue()});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)requestContentType)) {
            request.contentType(MediaType.parseMediaType((String)requestContentType));
        }
        if (this.cookies.exist()) {
            for (io.restassured.http.Cookie cookie : this.cookies) {
                Cookie servletCookie = new Cookie(cookie.getName(), cookie.getValue());
                if (cookie.hasComment()) {
                    servletCookie.setComment(cookie.getComment());
                }
                if (cookie.hasDomain()) {
                    servletCookie.setDomain(cookie.getDomain());
                }
                if (cookie.hasMaxAge()) {
                    servletCookie.setMaxAge(cookie.getMaxAge());
                }
                if (cookie.hasPath()) {
                    servletCookie.setPath(cookie.getPath());
                }
                if (cookie.hasVersion()) {
                    servletCookie.setVersion(cookie.getVersion());
                }
                servletCookie.setSecure(cookie.isSecured());
                request.cookie(new Cookie[]{servletCookie});
            }
        }
        if (!this.sessionAttributes.isEmpty()) {
            request.sessionAttrs(this.sessionAttributes);
        }
        if (!this.multiParts.isEmpty()) {
            MockMultipartHttpServletRequestBuilder multiPartRequest = (MockMultipartHttpServletRequestBuilder)request;
            for (MockMvcMultiPart multiPart : this.multiParts) {
                MockMultipartFile multipartFile;
                String fileName = multiPart.getFileName();
                String controlName = multiPart.getControlName();
                String mimeType = multiPart.getMimeType();
                if (multiPart.isByteArray()) {
                    multipartFile = new MockMultipartFile(controlName, fileName, mimeType, (byte[])multiPart.getContent());
                } else if (multiPart.isFile() || multiPart.isInputStream()) {
                    InputStream inputStream;
                    if (multiPart.isFile()) {
                        try {
                            inputStream = new FileInputStream((File)multiPart.getContent());
                        }
                        catch (FileNotFoundException e) {
                            return (MockMvcResponse)SafeExceptionRethrower.safeRethrow((Throwable)e);
                        }
                    } else {
                        inputStream = (InputStream)multiPart.getContent();
                    }
                    try {
                        multipartFile = new MockMultipartFile(controlName, fileName, mimeType, inputStream);
                    }
                    catch (IOException e) {
                        return (MockMvcResponse)SafeExceptionRethrower.safeRethrow((Throwable)e);
                    }
                } else {
                    multipartFile = new MockMultipartFile(controlName, fileName, mimeType, ((String)multiPart.getContent()).getBytes());
                }
                multiPartRequest.file(multipartFile);
            }
        }
        if (this.requestBody != null) {
            if (this.requestBody instanceof byte[]) {
                request.content((byte[])this.requestBody);
            } else if (this.requestBody instanceof File) {
                byte[] bytes = BodyHelper.toByteArray((File)((File)this.requestBody));
                request.content(bytes);
            } else {
                request.content(this.requestBody.toString());
            }
        }
        this.logRequestIfApplicable(method, baseUri, path, pathParams);
        return this.performRequest(request);
    }

    private void setContentTypeToApplicationFormUrlEncoded(MockHttpServletRequestBuilder request) {
        MediaType mediaType = MediaType.parseMediaType((String)HeaderHelper.buildApplicationFormEncodedContentType((SpecificationConfig)this.config, (String)"application/x-www-form-urlencoded"));
        request.contentType(mediaType);
        ArrayList<Header> newHeaders = new ArrayList<Header>(this.headers.asList());
        newHeaders.add(new Header(CONTENT_TYPE, mediaType.toString()));
        this.headers = new Headers(newHeaders);
    }

    private boolean isInMultiPartMode(MockHttpServletRequestBuilder request) {
        return request instanceof MockMultipartHttpServletRequestBuilder;
    }

    private void logRequestIfApplicable(HttpMethod method, String uri, String originalPath, Object[] unnamedPathParams) {
        if (this.requestLoggingFilter == null) {
            return;
        }
        RequestSpecificationImpl reqSpec = new RequestSpecificationImpl("http://localhost", -1, "", (AuthenticationScheme)new NoAuthScheme(), Collections.emptyList(), null, true, ConfigConverter.convertToRestAssuredConfig((SpecificationConfig)this.config), this.logRepository, null);
        RequestLogger.logParamsAndHeaders((RequestSpecificationImpl)reqSpec, (String)method.toString(), (String)uri, (Object[])unnamedPathParams, this.params, this.queryParams, this.formParams, (Headers)this.headers, (Cookies)this.cookies);
        RequestLogger.logRequestBody((RequestSpecificationImpl)reqSpec, (Object)this.requestBody, (Headers)this.headers, this.multiParts, (SpecificationConfig)this.config);
        if (this.multiParts != null) {
            for (MockMvcMultiPart multiPart : this.multiParts) {
                reqSpec.multiPart(new MultiPartSpecBuilder(multiPart.getContent()).controlName(multiPart.getControlName()).fileName(multiPart.getFileName()).mimeType(multiPart.getMimeType()).build());
            }
        }
        String uriPath = PathSupport.getPath((String)uri);
        String originalUriPath = PathSupport.getPath((String)originalPath);
        this.requestLoggingFilter.filter((FilterableRequestSpecification)reqSpec, null, (FilterContext)new FilterContextImpl(uri, originalUriPath, uriPath, uri, uri, new Object[0], method.toString(), null, Collections.emptyList().iterator(), new HashMap()));
    }

    public MockMvcResponse get(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.GET, path, pathParams);
    }

    public MockMvcResponse get(String path, Map<String, ?> pathParams) {
        return this.get(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse post(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.POST, path, pathParams);
    }

    public MockMvcResponse post(String path, Map<String, ?> pathParams) {
        return this.post(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse put(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.PUT, path, pathParams);
    }

    public MockMvcResponse put(String path, Map<String, ?> pathParams) {
        return this.put(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse delete(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.DELETE, path, pathParams);
    }

    public MockMvcResponse delete(String path, Map<String, ?> pathParams) {
        return this.delete(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse head(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.HEAD, path, pathParams);
    }

    public MockMvcResponse head(String path, Map<String, ?> pathParams) {
        return this.head(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse patch(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.PATCH, path, pathParams);
    }

    public MockMvcResponse patch(String path, Map<String, ?> pathParams) {
        return this.patch(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse options(String path, Object ... pathParams) {
        return this.sendRequest(HttpMethod.OPTIONS, path, pathParams);
    }

    public MockMvcResponse options(String path, Map<String, ?> pathParams) {
        return this.options(path, HeaderHelper.mapToArray(pathParams));
    }

    public MockMvcResponse get(URI uri) {
        return this.get(uri.toString(), new Object[0]);
    }

    public MockMvcResponse post(URI uri) {
        return this.post(uri.toString(), new Object[0]);
    }

    public MockMvcResponse put(URI uri) {
        return this.put(uri.toString(), new Object[0]);
    }

    public MockMvcResponse delete(URI uri) {
        return this.delete(uri.toString(), new Object[0]);
    }

    public MockMvcResponse head(URI uri) {
        return this.head(uri.toString(), new Object[0]);
    }

    public MockMvcResponse patch(URI uri) {
        return this.patch(uri.toString(), new Object[0]);
    }

    public MockMvcResponse options(URI uri) {
        return this.options(uri.toString(), new Object[0]);
    }

    public MockMvcResponse get(URL url) {
        return this.get(url.toString(), new Object[0]);
    }

    public MockMvcResponse post(URL url) {
        return this.post(url.toString(), new Object[0]);
    }

    public MockMvcResponse put(URL url) {
        return this.put(url.toString(), new Object[0]);
    }

    public MockMvcResponse delete(URL url) {
        return this.delete(url.toString(), new Object[0]);
    }

    public MockMvcResponse head(URL url) {
        return this.head(url.toString(), new Object[0]);
    }

    public MockMvcResponse patch(URL url) {
        return this.patch(url.toString(), new Object[0]);
    }

    public MockMvcResponse options(URL url) {
        return this.options(url.toString(), new Object[0]);
    }

    public MockMvcResponse get() {
        return this.get("", new Object[0]);
    }

    public MockMvcResponse post() {
        return this.post("", new Object[0]);
    }

    public MockMvcResponse put() {
        return this.put("", new Object[0]);
    }

    public MockMvcResponse delete() {
        return this.delete("", new Object[0]);
    }

    public MockMvcResponse head() {
        return this.head("", new Object[0]);
    }

    public MockMvcResponse patch() {
        return this.patch("", new Object[0]);
    }

    public MockMvcResponse options() {
        return this.options("", new Object[0]);
    }

    public MockMvcResponse request(Method method) {
        return this.request(method, "", new Object[0]);
    }

    public MockMvcResponse request(String method) {
        return this.request(method, "", new Object[0]);
    }

    public MockMvcResponse request(Method method, String path, Object ... pathParams) {
        return this.request(((Method)AssertParameter.notNull((Object)method, Method.class)).name(), path, pathParams);
    }

    public MockMvcResponse request(String method, String path, Object ... pathParams) {
        return this.sendRequest(this.toValidHttpMethod(method), path, pathParams);
    }

    public MockMvcResponse request(Method method, URI uri) {
        return this.request(method, ((URI)AssertParameter.notNull((Object)uri, URI.class)).toString(), new Object[0]);
    }

    public MockMvcResponse request(Method method, URL url) {
        return this.request(method, ((URL)AssertParameter.notNull((Object)url, URL.class)).toString(), new Object[0]);
    }

    public MockMvcResponse request(String method, URI uri) {
        return this.request(method, ((URI)AssertParameter.notNull((Object)uri, URI.class)).toString(), new Object[0]);
    }

    public MockMvcResponse request(String method, URL url) {
        return this.request(method, ((URL)AssertParameter.notNull((Object)url, URL.class)).toString(), new Object[0]);
    }

    @Override
    public MockMvcRequestAsyncConfigurer with() {
        return this;
    }

    @Override
    public MockMvcRequestAsyncConfigurer and() {
        return this;
    }

    @Override
    public MockMvcRequestAsyncConfigurer timeout(long duration, TimeUnit timeUnit) {
        RestAssuredMockMvcConfig newConfig = this.config.asyncConfig(new AsyncConfig(duration, timeUnit));
        return new MockMvcRequestSenderImpl(this.mockMvc, this.params, this.queryParams, this.formParams, this.attributes, newConfig, this.requestBody, this.headers, this.cookies, this.sessionAttributes, this.multiParts, this.requestLoggingFilter, this.resultHandlers, this.requestPostProcessors, this.interceptor, this.basePath, this.responseSpecification, this.authentication, this.logRepository, this.isAsyncRequest);
    }

    @Override
    public MockMvcRequestAsyncConfigurer timeout(long durationInMs) {
        return this.timeout(durationInMs, TimeUnit.MILLISECONDS);
    }

    @Override
    public MockMvcRequestSender then() {
        return this;
    }

    @Override
    public MockMvcRequestAsyncConfigurer async() {
        return new MockMvcRequestSenderImpl(this.mockMvc, this.params, this.queryParams, this.formParams, this.attributes, this.config, this.requestBody, this.headers, this.cookies, this.sessionAttributes, this.multiParts, this.requestLoggingFilter, this.resultHandlers, this.requestPostProcessors, this.interceptor, this.basePath, this.responseSpecification, this.authentication, this.logRepository, true);
    }

    private HttpMethod toValidHttpMethod(String method) {
        String httpMethodAsString = (String)AssertParameter.notNull((Object)StringUtils.trimToNull((String)method), (String)"HTTP Method");
        HttpMethod httpMethod = HttpMethod.resolve((String)httpMethodAsString.toUpperCase());
        if (httpMethod == null) {
            throw new IllegalArgumentException("HTTP method '" + method + "' is not supported by MockMvc");
        }
        return httpMethod;
    }
}

