/*
 * Decompiled with CFR 0.152.
 */
package io.restassured.module.mockmvc.internal;

import io.restassured.config.RestAssuredConfig;
import io.restassured.internal.ResponseParserRegistrar;
import io.restassured.internal.ValidatableResponseOptionsImpl;
import io.restassured.internal.assertion.AssertParameter;
import io.restassured.internal.log.LogRepository;
import io.restassured.internal.util.SafeExceptionRethrower;
import io.restassured.module.mockmvc.internal.ResponseConverter;
import io.restassured.module.mockmvc.response.MockMvcResponse;
import io.restassured.module.mockmvc.response.ValidatableMockMvcResponse;
import io.restassured.response.ExtractableResponse;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.ResultHandler;
import org.springframework.test.web.servlet.ResultMatcher;

public class ValidatableMockMvcResponseImpl
extends ValidatableResponseOptionsImpl<ValidatableMockMvcResponse, MockMvcResponse>
implements ValidatableMockMvcResponse {
    private final ResultActions resultActions;
    private final MockMvcResponse mockMvcResponse;

    public ValidatableMockMvcResponseImpl(ResultActions resultActions, String contentType, ResponseParserRegistrar rpr, RestAssuredConfig config, MockMvcResponse response, ExtractableResponse<MockMvcResponse> extractableResponse, LogRepository logRepository) {
        super(rpr, config, ResponseConverter.toStandardResponse(response), extractableResponse, logRepository);
        this.mockMvcResponse = response;
        AssertParameter.notNull((Object)resultActions, ResultActions.class);
        this.resultActions = resultActions;
    }

    @Override
    public ValidatableMockMvcResponse expect(ResultMatcher resultMatcher) {
        AssertParameter.notNull((Object)resultMatcher, ResultMatcher.class);
        try {
            this.resultActions.andExpect(resultMatcher);
        }
        catch (Exception e) {
            SafeExceptionRethrower.safeRethrow((Throwable)e);
        }
        return this;
    }

    @Override
    public ValidatableMockMvcResponse assertThat(ResultMatcher resultMatcher) {
        return this.expect(resultMatcher);
    }

    @Override
    public ValidatableMockMvcResponse apply(ResultHandler resultHandler, ResultHandler ... resultHandlers) {
        AssertParameter.notNull((Object)resultHandler, ResultMatcher.class);
        try {
            this.resultActions.andDo(resultHandler);
        }
        catch (Exception e) {
            SafeExceptionRethrower.safeRethrow((Throwable)e);
        }
        for (ResultHandler handler : resultHandlers) {
            try {
                this.resultActions.andDo(handler);
            }
            catch (Exception e) {
                SafeExceptionRethrower.safeRethrow((Throwable)e);
            }
        }
        return this;
    }

    public MockMvcResponse originalResponse() {
        return this.mockMvcResponse;
    }
}

