/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.ssdp.client.impl;

import io.resourcepool.ssdp.client.SsdpClient;
import io.resourcepool.ssdp.client.SsdpParams;
import io.resourcepool.ssdp.client.parser.ResponseParser;
import io.resourcepool.ssdp.client.request.SsdpDiscovery;
import io.resourcepool.ssdp.client.response.SsdpResponse;
import io.resourcepool.ssdp.client.util.Utils;
import io.resourcepool.ssdp.exception.NoSerialNumberException;
import io.resourcepool.ssdp.model.DiscoveryListener;
import io.resourcepool.ssdp.model.DiscoveryRequest;
import io.resourcepool.ssdp.model.SsdpService;
import io.resourcepool.ssdp.model.SsdpServiceAnnouncement;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SsdpClientImpl
extends SsdpClient {
    public static final long DEFAULT_INTERVAL_BETWEEN_REQUESTS = 10000L;
    private static final DiscoveryListener NOOP_LISTENER = new DiscoveryListener(){

        @Override
        public void onServiceDiscovered(SsdpService service) {
        }

        @Override
        public void onServiceAnnouncement(SsdpServiceAnnouncement announcement) {
        }

        @Override
        public void onFailed(Exception ex) {
        }
    };
    private ScheduledExecutorService sendExecutor = Executors.newScheduledThreadPool(1);
    private ExecutorService receiveExecutor = Executors.newSingleThreadExecutor();
    private List<DiscoveryRequest> requests;
    private DiscoveryListener callback = NOOP_LISTENER;
    private State state;
    private Map<String, SsdpService> cache = new ConcurrentHashMap<String, SsdpService>();
    private MulticastSocket clientSocket;
    private List<NetworkInterface> interfaces;

    private void reset(DiscoveryRequest req, DiscoveryListener callback) {
        this.callback = callback;
        this.state = State.ACTIVE;
        this.requests = new ArrayList<DiscoveryRequest>();
        if (req != null) {
            this.requests.add(req);
        }
        for (Map.Entry<String, SsdpService> e : this.cache.entrySet()) {
            if (e.getValue().isExpired()) {
                this.cache.remove(e.getKey());
                continue;
            }
            callback.onServiceDiscovered(e.getValue());
        }
    }

    @Override
    public void discoverServices(DiscoveryRequest req, final DiscoveryListener callback) {
        if (State.ACTIVE.equals((Object)this.state)) {
            callback.onFailed(new IllegalStateException("Another discovery is in progress. Stop the first discovery before starting a new one."));
            return;
        }
        this.reset(req, callback);
        this.openAndBindSocket();
        this.sendExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SsdpClientImpl.this.sendDiscoveryRequest();
            }
        }, 0L, req.getDiscoveryOptions().getIntervalBetweenRequests(), TimeUnit.MILLISECONDS);
        this.receiveExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    while (State.ACTIVE.equals((Object)SsdpClientImpl.this.state)) {
                        byte[] buffer = new byte[8192];
                        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                        SsdpClientImpl.this.clientSocket.receive(packet);
                        SsdpClientImpl.this.handleIncomingPacket(packet);
                    }
                }
                catch (IOException e) {
                    if (SsdpClientImpl.this.clientSocket.isClosed() && !State.ACTIVE.equals((Object)SsdpClientImpl.this.state)) {
                        return;
                    }
                    callback.onFailed(e);
                }
            }
        });
    }

    private void handleIncomingPacket(DatagramPacket packet) {
        SsdpResponse response = ResponseParser.parse(packet);
        if (response == null) {
            return;
        }
        if (response.getType().equals((Object)SsdpResponse.Type.DISCOVERY_RESPONSE)) {
            this.handleDiscoveryResponse(response);
        } else if (response.getType().equals((Object)SsdpResponse.Type.PRESENCE_ANNOUNCEMENT)) {
            this.handlePresenceAnnouncement(response);
        }
    }

    private void sendDiscoveryRequest() {
        try {
            if (this.requests.isEmpty()) {
                return;
            }
            for (DiscoveryRequest req : this.requests) {
                if (req.getServiceTypes() == null || req.getServiceTypes().isEmpty()) {
                    this.sendOnAllInterfaces(SsdpDiscovery.getDatagram(null, req.getDiscoveryOptions()));
                    continue;
                }
                for (String st : req.getServiceTypes()) {
                    this.sendOnAllInterfaces(SsdpDiscovery.getDatagram(st, req.getDiscoveryOptions()));
                }
            }
        }
        catch (IOException e) {
            if (this.clientSocket.isClosed() && !State.ACTIVE.equals((Object)this.state)) {
                return;
            }
            this.callback.onFailed(e);
        }
    }

    private void openAndBindSocket() {
        try {
            this.clientSocket = new MulticastSocket(SsdpParams.getSsdpMulticastPort());
            this.clientSocket.setReuseAddress(true);
            this.interfaces = Utils.getMulticastInterfaces();
            this.joinGroupOnAllInterfaces(SsdpParams.getSsdpMulticastAddress());
        }
        catch (IOException e) {
            this.callback.onFailed(e);
        }
    }

    private void handlePresenceAnnouncement(SsdpResponse response) {
        SsdpServiceAnnouncement ssdpServiceAnnouncement = response.toServiceAnnouncement();
        if (ssdpServiceAnnouncement.getSerialNumber() == null) {
            this.callback.onFailed(new NoSerialNumberException());
            return;
        }
        if (this.cache.containsKey(ssdpServiceAnnouncement.getSerialNumber())) {
            this.callback.onServiceAnnouncement(ssdpServiceAnnouncement);
        } else {
            this.requests.add(DiscoveryRequest.builder().serviceType(ssdpServiceAnnouncement.getServiceType()).build());
        }
    }

    private void handleDiscoveryResponse(SsdpResponse response) {
        SsdpService ssdpService = response.toService();
        if (ssdpService.getSerialNumber() == null) {
            this.callback.onFailed(new NoSerialNumberException());
            return;
        }
        if (!this.cache.containsKey(ssdpService.getSerialNumber())) {
            this.callback.onServiceDiscovered(ssdpService);
        }
        this.cache.put(ssdpService.getSerialNumber(), ssdpService);
    }

    private void sendOnAllInterfaces(DatagramPacket packet) throws IOException {
        if (this.interfaces != null && this.interfaces.size() > 0) {
            for (NetworkInterface iface : this.interfaces) {
                this.clientSocket.setNetworkInterface(iface);
                this.clientSocket.send(packet);
            }
        } else {
            this.clientSocket.send(packet);
        }
    }

    private void joinGroupOnAllInterfaces(InetAddress address) throws IOException {
        if (this.interfaces != null && this.interfaces.size() > 0) {
            InetSocketAddress socketAddress = new InetSocketAddress(address, 65535);
            for (NetworkInterface iface : this.interfaces) {
                this.clientSocket.joinGroup(socketAddress, iface);
            }
        } else {
            this.clientSocket.joinGroup(address);
        }
    }

    private void leaveGroupOnAllInterfaces(InetAddress address) throws IOException {
        if (this.interfaces != null && this.interfaces.size() > 0) {
            InetSocketAddress socketAddress = new InetSocketAddress(address, 65535);
            for (NetworkInterface iface : this.interfaces) {
                this.clientSocket.leaveGroup(socketAddress, iface);
            }
        } else {
            this.clientSocket.leaveGroup(address);
        }
    }

    @Override
    public void stopDiscovery() {
        this.state = State.STOPPING;
        this.receiveExecutor.shutdownNow();
        this.sendExecutor.shutdownNow();
        this.callback = NOOP_LISTENER;
        this.requests = null;
        try {
            this.leaveGroupOnAllInterfaces(SsdpParams.getSsdpMulticastAddress());
        }
        catch (IOException iOException) {
        }
        finally {
            this.clientSocket.close();
        }
        this.interfaces = null;
        this.state = State.IDLE;
    }

    private static enum State {
        ACTIVE,
        IDLE,
        STOPPING;

    }
}

