/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.ssdp.model;

import io.resourcepool.ssdp.client.response.SsdpResponse;
import java.net.InetAddress;
import java.util.Map;

public class SsdpService {
    private String serialNumber;
    private String serviceType;
    private String location;
    private final InetAddress remoteIp;
    private final SsdpResponse originalResponse;

    public SsdpService(SsdpResponse response) {
        Map<String, String> headers = response.getHeaders();
        this.serialNumber = headers.get("USN");
        this.serviceType = headers.get("ST");
        this.location = headers.get("LOCATION");
        if (this.location == null) {
            this.location = headers.get("AL");
        }
        this.remoteIp = response.getOriginAddress();
        this.originalResponse = response;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public InetAddress getRemoteIp() {
        return this.remoteIp;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public SsdpResponse getOriginalResponse() {
        return this.originalResponse;
    }

    public boolean isExpired() {
        return this.originalResponse.isExpired();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SsdpService that = (SsdpService)o;
        if (!this.serialNumber.equals(that.serialNumber)) {
            return false;
        }
        return this.serviceType.equals(that.serviceType);
    }

    public int hashCode() {
        int result = this.serialNumber.hashCode();
        result = 31 * result + this.serviceType.hashCode();
        return result;
    }

    public String toString() {
        return "SsdpService{serialNumber='" + this.serialNumber + '\'' + ", serviceType='" + this.serviceType + '\'' + ", location='" + this.location + '\'' + ", remoteIp=" + this.remoteIp + '}';
    }
}

