/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.ssdp.client.request;

import io.resourcepool.ssdp.client.SsdpParams;
import io.resourcepool.ssdp.model.DiscoveryOptions;
import java.net.DatagramPacket;

public abstract class SsdpDiscovery {
    public static DatagramPacket getDatagram(String serviceType, DiscoveryOptions options) {
        StringBuilder sb = new StringBuilder("M-SEARCH * HTTP/1.1\r\n");
        sb.append("HOST: " + SsdpParams.getSsdpMulticastAddress().getHostAddress() + ":" + SsdpParams.getSsdpMulticastPort() + "\r\n");
        sb.append("MAN: \"ssdp:discover\"\r\n");
        sb.append("MX: " + options.getMaxWaitTimeSeconds() + "\r\n");
        if (options.getUserAgent() != null) {
            sb.append("USER-AGENT: " + options.getUserAgent() + "\r\n");
        }
        sb.append(serviceType == null || serviceType.trim().isEmpty() ? "ST: ssdp:all\r\n" : "ST: " + serviceType + "\r\n");
        sb.append("\r\n");
        byte[] content = sb.toString().getBytes(SsdpParams.UTF_8);
        return new DatagramPacket(content, content.length, SsdpParams.getSsdpMulticastAddress(), SsdpParams.getSsdpMulticastPort());
    }
}

