/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.ssdp.model;

import io.resourcepool.ssdp.client.response.SsdpResponse;
import java.net.InetAddress;
import java.util.Map;

public class SsdpServiceAnnouncement {
    private String serialNumber;
    private String serviceType;
    private String location;
    private Status status;
    private final InetAddress remoteIp;
    private final SsdpResponse originalResponse;

    public SsdpServiceAnnouncement(SsdpResponse response) {
        Map<String, String> headers = response.getHeaders();
        this.serialNumber = headers.get("USN");
        this.serviceType = headers.get("NT");
        this.status = Status.parse(headers.get("NTS"));
        this.location = headers.get("LOCATION");
        if (this.location == null) {
            this.location = headers.get("AL");
        }
        this.remoteIp = response.getOriginAddress();
        this.originalResponse = response;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    public InetAddress getRemoteIp() {
        return this.remoteIp;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public SsdpResponse getOriginalResponse() {
        return this.originalResponse;
    }

    public long getExpiry() {
        return this.originalResponse.getExpiry();
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SsdpServiceAnnouncement that = (SsdpServiceAnnouncement)o;
        if (this.serialNumber != null ? !this.serialNumber.equals(that.serialNumber) : that.serialNumber != null) {
            return false;
        }
        if (this.serviceType != null ? !this.serviceType.equals(that.serviceType) : that.serviceType != null) {
            return false;
        }
        return this.status == that.status;
    }

    public int hashCode() {
        int result = this.serialNumber != null ? this.serialNumber.hashCode() : 0;
        result = 31 * result + (this.serviceType != null ? this.serviceType.hashCode() : 0);
        result = 31 * result + (this.status != null ? this.status.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "SsdpServiceAnnouncement{serialNumber='" + this.serialNumber + '\'' + ", serviceType='" + this.serviceType + '\'' + ", location='" + this.location + '\'' + ", status=" + (Object)((Object)this.status) + ", remoteIp=" + this.remoteIp + '}';
    }

    public static enum Status {
        ALIVE,
        BYEBYE,
        UPDATE;


        public static Status parse(String nts) {
            if ("ssdp:alive".equals(nts)) {
                return ALIVE;
            }
            if ("ssdp:byebye".equals(nts)) {
                return BYEBYE;
            }
            if ("ssdp:update".equals(nts)) {
                return UPDATE;
            }
            return null;
        }
    }
}

