/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.ssdp.model;

import io.resourcepool.ssdp.model.DiscoveryOptions;
import io.resourcepool.ssdp.model.SsdpRequest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DiscoveryRequest
extends SsdpRequest {
    private List<String> serviceTypes;
    private DiscoveryOptions discoveryOptions;

    public List<String> getServiceTypes() {
        return this.serviceTypes;
    }

    public DiscoveryOptions getDiscoveryOptions() {
        return this.discoveryOptions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Set<String> serviceTypes = new HashSet<String>();
        private DiscoveryOptions discoveryOptions = new DiscoveryOptions();

        private Builder() {
        }

        public Builder serviceType(String serviceType) {
            this.serviceTypes.add(serviceType);
            return this;
        }

        public Builder discoveryOptions(DiscoveryOptions discoveryOptions) {
            this.discoveryOptions = discoveryOptions;
            return this;
        }

        public DiscoveryRequest build() {
            DiscoveryRequest req = new DiscoveryRequest();
            req.serviceTypes = new ArrayList<String>(this.serviceTypes);
            req.discoveryOptions = this.discoveryOptions;
            return req;
        }
    }
}

