/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.ssdp.model;

public class DiscoveryOptions {
    private static final Long DEFAULT_INTERVAL_BETWEEN_REQUESTS = 10000L;
    private static final Integer DEFAULT_MAX_WAIT_TIME_SECONDS = 3;
    private static final String DEFAULT_USER_AGENT = "Resourcepool SSDP Client";
    private Long intervalBetweenRequests = DEFAULT_INTERVAL_BETWEEN_REQUESTS;
    private Integer maxWaitTimeSeconds = DEFAULT_MAX_WAIT_TIME_SECONDS;
    private String userAgent = "Resourcepool SSDP Client";

    public Long getIntervalBetweenRequests() {
        return this.intervalBetweenRequests;
    }

    public Integer getMaxWaitTimeSeconds() {
        return this.maxWaitTimeSeconds;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public Builder builder() {
        return new Builder();
    }

    static /* synthetic */ Long access$100() {
        return DEFAULT_INTERVAL_BETWEEN_REQUESTS;
    }

    static /* synthetic */ Integer access$200() {
        return DEFAULT_MAX_WAIT_TIME_SECONDS;
    }

    public static final class Builder {
        private Long intervalBetweenRequests = DiscoveryOptions.access$100();
        private Integer maxWaitTimeSeconds = DiscoveryOptions.access$200();
        private String userAgent = "Resourcepool SSDP Client";

        private Builder() {
        }

        public Builder intervalBetweenRequests(Long intervalBetweenRequests) {
            if (intervalBetweenRequests < 10L) {
                throw new IllegalArgumentException("Interval between requests must be at least 10 milliseconds");
            }
            this.intervalBetweenRequests = intervalBetweenRequests;
            return this;
        }

        public Builder maxWaitTimeSeconds(Integer maxWaitTimeSeconds) {
            if (this.intervalBetweenRequests < 1L) {
                throw new IllegalArgumentException("Max wait time must be at least one second");
            }
            this.maxWaitTimeSeconds = maxWaitTimeSeconds;
            return this;
        }

        public Builder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public DiscoveryOptions build() {
            DiscoveryOptions discoveryOptions = new DiscoveryOptions();
            discoveryOptions.maxWaitTimeSeconds = this.maxWaitTimeSeconds;
            discoveryOptions.intervalBetweenRequests = this.intervalBetweenRequests;
            discoveryOptions.userAgent = this.userAgent;
            return discoveryOptions;
        }
    }
}

