/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.ssdp.client.response;

import io.resourcepool.ssdp.model.SsdpService;
import io.resourcepool.ssdp.model.SsdpServiceAnnouncement;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class SsdpResponse {
    private final Map<String, String> headers;
    private final byte[] body;
    private final InetAddress originAddress;
    private final long expiry;
    private final Type type;

    public Type getType() {
        return this.type;
    }

    public SsdpResponse(Type type, Map<String, String> headers, byte[] body, long expiry, InetAddress originAddress) {
        this.type = type;
        this.headers = headers;
        this.body = body;
        this.expiry = expiry;
        this.originAddress = originAddress;
    }

    public byte[] getBody() {
        return this.body;
    }

    public Map<String, String> getHeaders() {
        return new HashMap<String, String>(this.headers);
    }

    public InetAddress getOriginAddress() {
        return this.originAddress;
    }

    public SsdpService toService() {
        return new SsdpService(this);
    }

    public SsdpServiceAnnouncement toServiceAnnouncement() {
        return new SsdpServiceAnnouncement(this);
    }

    public long getExpiry() {
        return this.expiry;
    }

    public boolean isExpired() {
        return this.expiry <= 0L || new Date().getTime() > this.expiry;
    }

    public String toString() {
        return "SsdpResponse{, headers=" + this.headers + ", body=" + Arrays.toString(this.body) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SsdpResponse that = (SsdpResponse)o;
        if (!this.headers.equals(that.headers)) {
            return false;
        }
        return Arrays.equals(this.body, that.body);
    }

    public int hashCode() {
        int result = this.headers.hashCode();
        result = 31 * result + Arrays.hashCode(this.body);
        return result;
    }

    public static enum Type {
        DISCOVERY_RESPONSE,
        PRESENCE_ANNOUNCEMENT;

    }
}

