/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.ssdp.client.parser;

import io.resourcepool.ssdp.client.SsdpParams;
import io.resourcepool.ssdp.client.response.SsdpResponse;
import java.net.DatagramPacket;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResponseParser {
    private static final Pattern CACHE_CONTROL_PATTERN = Pattern.compile("max-age[ ]*=[ ]*([0-9]+).*");
    private static final SimpleDateFormat DATE_HEADER_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final Pattern SEARCH_REQUEST_LINE_PATTERN = Pattern.compile("^HTTP/1\\.1 [0-9]+ .*");
    private static final Pattern SERVICE_ANNOUNCEMENT_LINE_PATTERN = Pattern.compile("NOTIFY \\* HTTP/1.1");
    private static final Pattern HEADER_PATTERN = Pattern.compile("(.*?):(.*)$");
    private static final byte[] CRLF = "\r\n".getBytes(SsdpParams.UTF_8);

    public static SsdpResponse parse(DatagramPacket packet) {
        String[] headerLines;
        HashMap<String, String> headers = new HashMap<String, String>();
        byte[] body = null;
        SsdpResponse.Type type = null;
        byte[] data = packet.getData();
        int endOfHeaders = ResponseParser.findEndOfHeaders(data);
        if (endOfHeaders == -1) {
            endOfHeaders = packet.getLength();
        }
        if (SEARCH_REQUEST_LINE_PATTERN.matcher((headerLines = new String(Arrays.copyOfRange(data, 0, endOfHeaders)).split("\r\n"))[0]).matches()) {
            type = SsdpResponse.Type.DISCOVERY_RESPONSE;
        } else if (SERVICE_ANNOUNCEMENT_LINE_PATTERN.matcher(headerLines[0]).matches()) {
            type = SsdpResponse.Type.PRESENCE_ANNOUNCEMENT;
        }
        if (type == null) {
            return null;
        }
        for (int i = 1; i < headerLines.length; ++i) {
            String line = headerLines[i];
            Matcher matcher = HEADER_PATTERN.matcher(line);
            if (!matcher.matches()) continue;
            headers.put(matcher.group(1).toUpperCase().trim(), matcher.group(2).trim());
        }
        long expiry = ResponseParser.parseCacheHeader(headers);
        int endOfBody = packet.getLength();
        if (endOfBody > endOfHeaders + 4) {
            body = Arrays.copyOfRange(data, endOfHeaders + 4, endOfBody);
        }
        return new SsdpResponse(type, headers, body, expiry, packet.getAddress());
    }

    private static long parseCacheHeader(Map<String, String> headers) {
        String cacheControlHeader;
        Matcher m;
        if (headers.get("CACHE-CONTROL") != null && (m = CACHE_CONTROL_PATTERN.matcher(cacheControlHeader = headers.get("CACHE-CONTROL"))).matches()) {
            return new Date().getTime() + Long.parseLong(m.group(1)) * 1000L;
        }
        if (headers.get("EXPIRES") != null) {
            try {
                return DATE_HEADER_FORMAT.parse(headers.get("EXPIRES")).getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private static int findEndOfHeaders(byte[] data) {
        for (int i = 0; i < data.length - 3; ++i) {
            if (data[i] != CRLF[0] || data[i + 1] != CRLF[1] || data[i + 2] != CRLF[0] || data[i + 3] != CRLF[1]) continue;
            return i;
        }
        return -1;
    }
}

