/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.jarpic.client;

import io.resourcepool.jarpic.client.Ssdp;
import io.resourcepool.jarpic.client.SsdpClient;
import io.resourcepool.jarpic.client.Utils;
import io.resourcepool.jarpic.client.request.SsdpDiscovery;
import io.resourcepool.jarpic.client.response.SsdpResponse;
import io.resourcepool.jarpic.model.DiscoveryListener;
import io.resourcepool.jarpic.model.DiscoveryRequest;
import io.resourcepool.jarpic.model.SsdpService;
import io.resourcepool.jarpic.model.SsdpServiceAnnouncement;
import io.resourcepool.jarpic.parser.ResponseParser;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.MulticastSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class SsdpClientImpl
implements SsdpClient {
    private static final long INTERVAL_BETWEEN_REQUESTS = 10000L;
    private ScheduledExecutorService sendExecutor = Executors.newScheduledThreadPool(1);
    private ExecutorService receiveExecutor = Executors.newSingleThreadExecutor();
    private List<DiscoveryRequest> requests;
    private DiscoveryListener callback;
    private State state;
    private Map<String, SsdpService> cache = new ConcurrentHashMap<String, SsdpService>();
    private MulticastSocket clientSocket;

    private void reset(DiscoveryRequest req, DiscoveryListener callback) {
        this.callback = callback;
        this.state = State.ACTIVE;
        this.requests = new ArrayList<DiscoveryRequest>();
        if (req != null) {
            this.requests.add(req);
        }
        for (Map.Entry<String, SsdpService> e : this.cache.entrySet()) {
            if (e.getValue().isExpired()) {
                this.cache.remove(e.getKey());
                continue;
            }
            callback.onServiceDiscovered(e.getValue());
        }
    }

    @Override
    public void discoverServices(DiscoveryRequest req, DiscoveryListener callback) {
        if (State.ACTIVE.equals((Object)this.state)) {
            throw new IllegalStateException("Another discovery is in progress. Stop the first discovery before starting a new one.");
        }
        this.reset(req, callback);
        this.openAndBindSocket();
        this.sendExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                SsdpClientImpl.this.sendDiscoveryRequest();
            }
        }, 0L, 10000L, TimeUnit.MILLISECONDS);
        this.receiveExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    while (State.ACTIVE.equals((Object)SsdpClientImpl.this.state)) {
                        byte[] buffer = new byte[8192];
                        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                        SsdpClientImpl.this.clientSocket.receive(packet);
                        SsdpClientImpl.this.handleIncomingPacket(packet);
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    private void handleIncomingPacket(DatagramPacket packet) {
        new ResponseParser();
        SsdpResponse response = ResponseParser.parse(packet);
        if (response == null) {
            return;
        }
        if (response.getType().equals((Object)SsdpResponse.Type.DISCOVERY_RESPONSE)) {
            this.handleDiscoveryResponse(response);
        } else if (response.getType().equals((Object)SsdpResponse.Type.PRESENCE_ANNOUNCEMENT)) {
            this.handlePresenceAnnouncement(response);
        }
    }

    private void sendDiscoveryRequest() {
        try {
            if (this.requests.isEmpty()) {
                return;
            }
            for (DiscoveryRequest req : this.requests) {
                if (req.getServiceTypes() == null || req.getServiceTypes().isEmpty()) {
                    this.clientSocket.send(SsdpDiscovery.getDatagram(null));
                    continue;
                }
                for (String st : req.getServiceTypes()) {
                    this.clientSocket.send(SsdpDiscovery.getDatagram(st));
                }
            }
            this.requests.clear();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void openAndBindSocket() {
        try {
            this.clientSocket = new MulticastSocket(Ssdp.getSsdpMulticastPort());
            Utils.selectAppropriateInterface(this.clientSocket);
            this.clientSocket.joinGroup(Ssdp.getSsdpMulticastAddress());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot bind multicast socket: " + e.getMessage(), e);
        }
    }

    private void handlePresenceAnnouncement(SsdpResponse response) {
        SsdpServiceAnnouncement ssdpServiceAnnouncement = response.toServiceAnnouncement();
        if (this.cache.containsKey(ssdpServiceAnnouncement.getSerialNumber())) {
            this.callback.onServiceAnnouncement(ssdpServiceAnnouncement);
        } else {
            this.requests.add(DiscoveryRequest.builder().serviceType(ssdpServiceAnnouncement.getServiceType()).build());
        }
    }

    private void handleDiscoveryResponse(SsdpResponse response) {
        SsdpService ssdpService = response.toService();
        if (!this.cache.containsKey(ssdpService.getSerialNumber())) {
            this.callback.onServiceDiscovered(ssdpService);
        }
        this.cache.put(ssdpService.getSerialNumber(), ssdpService);
    }

    @Override
    public void stopDiscovery() {
        this.state = State.IDLE;
        this.receiveExecutor.shutdownNow();
        this.sendExecutor.shutdownNow();
        this.callback = null;
        this.requests = null;
        try {
            this.clientSocket.leaveGroup(Ssdp.getSsdpMulticastAddress());
        }
        catch (IOException iOException) {
        }
        finally {
            this.clientSocket.close();
        }
    }

    private static enum State {
        ACTIVE,
        IDLE;

    }
}

