/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.jarpic.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.ParseException;

public abstract class JsonRpc2SchemaValidator {
    public static void assertValid(JsonNode tree) throws ParseException {
        if (tree == null) {
            throw new ParseException("The provided JSON cannot be null", 0);
        }
        if (!tree.isObject()) {
            throw new ParseException("The provided JSON is not an Object", 0);
        }
        if (!tree.has("jsonrpc") || !"2.0".equals(tree.get("jsonrpc").asText())) {
            throw new ParseException("Only JSON RPC 2.0 schema is supported. Please supply a valid format.", 1);
        }
        if (tree.has("method")) {
            JsonRpc2SchemaValidator.checkValidRequest((ObjectNode)tree);
        } else {
            JsonRpc2SchemaValidator.checkValidResponse((ObjectNode)tree);
        }
    }

    private static void checkValidRequest(ObjectNode tree) throws ParseException {
        JsonNode id;
        JsonNode params;
        if (tree.has("params") && !(params = tree.get("params")).isArray() && !params.isObject()) {
            throw new ParseException("JSON member 'params' must be an object or an array.", 2);
        }
        if (tree.has("id") && !(id = tree.get("id")).isTextual() && !id.isNumber() && !id.isNull()) {
            throw new ParseException("When provided, JSON member 'id' must be a String, a number, or NULL.", 2);
        }
    }

    private static void checkValidResponse(ObjectNode tree) throws ParseException {
        if (!tree.has("id")) {
            throw new ParseException("JSON member 'id' must be provided.", 3);
        }
        JsonNode id = tree.get("id");
        if (!(id.isTextual() || id.isNumber() || id.isNull())) {
            throw new ParseException("When provided, JSON member 'id' must be a String, a number, or NULL.", 3);
        }
        if (tree.has("error")) {
            if (tree.has("result")) {
                throw new ParseException("JSON member 'result' cannot be provided when 'error' is present.", 3);
            }
            JsonNode error = tree.get("error");
            if (!(error.isObject() && error.has("code") && error.get("code").isInt() && error.has("message") && error.get("message").isTextual())) {
                throw new ParseException("JSON member 'error' is not valid.", 3);
            }
        } else if (!tree.has("result")) {
            throw new ParseException("JSON member 'result' is mandatory.", 3);
        }
    }
}

