/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.jarpic.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import io.resourcepool.jarpic.model.JsonRpcRequest;
import java.util.List;
import java.util.Map;

public abstract class RequestMapper {
    private static final TextNode JSON_RPC_VERSION = new TextNode("2.0");

    public static ObjectNode map(JsonRpcRequest request) {
        Map<String, String> params;
        if (request == null) {
            return null;
        }
        ObjectNode node = new ObjectNode(JsonNodeFactory.instance);
        node.set("jsonrpc", (JsonNode)JSON_RPC_VERSION);
        node.set("method", (JsonNode)new TextNode(request.getMethod()));
        if (request.getId() != null) {
            node.set("id", (JsonNode)new TextNode(request.getId()));
        }
        if ((params = request.getParams()) != null && !params.isEmpty()) {
            ObjectMapper mapper = new ObjectMapper();
            node.set("params", mapper.valueToTree(params));
        }
        return node;
    }

    public static JsonNode map(List<JsonRpcRequest> requests) {
        ArrayNode node = new ArrayNode(JsonNodeFactory.instance);
        for (JsonRpcRequest request : requests) {
            node.add((JsonNode)RequestMapper.map(request));
        }
        return node;
    }
}

