/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.jarpic.model;

import io.resourcepool.jarpic.model.Error;

public class JsonRpcResponse<T> {
    protected String id;
    protected T result;
    protected Error error;

    public String getId() {
        return this.id;
    }

    public T getResult() {
        return this.result;
    }

    public Error getError() {
        return this.error;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRpcResponse response = (JsonRpcResponse)o;
        return !(this.id == null ? response.id != null : !this.id.equals(response.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return "Response{id='" + this.id + '\'' + ", result=" + this.result + ", error=" + this.error + '}';
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        protected String id;
        protected T result;
        protected Error error;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder result(T result) {
            this.result = result;
            return this;
        }

        public Builder error(Error error) {
            this.error = error;
            return this;
        }

        public JsonRpcResponse build() {
            JsonRpcResponse response = new JsonRpcResponse();
            response.id = this.id;
            response.result = this.result;
            response.error = this.error;
            return response;
        }
    }
}

