/*
 * Decompiled with CFR 0.152.
 */
package io.resourcepool.jarpic.client;

import io.resourcepool.jarpic.client.JsonRpcClient;
import io.resourcepool.jarpic.model.Error;
import io.resourcepool.jarpic.model.JsonRpcCallback;
import io.resourcepool.jarpic.model.JsonRpcMultiCallback;
import io.resourcepool.jarpic.model.JsonRpcRequest;
import io.resourcepool.jarpic.model.JsonRpcResponse;
import io.resourcepool.jarpic.parser.RequestMapper;
import io.resourcepool.jarpic.parser.ResponseParser;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpJsonRpcClient
implements JsonRpcClient {
    private OkHttpClient client;
    private String endpoint;
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=UTF-8");

    public HttpJsonRpcClient(String endpoint) {
        this.endpoint = endpoint;
        this.client = new OkHttpClient();
    }

    public HttpJsonRpcClient(String endpoint, OkHttpClient client) {
        this.endpoint = endpoint;
        this.client = client;
    }

    @Override
    public <T> JsonRpcResponse<T> send(JsonRpcRequest req, Class<T> resultClass) throws IOException {
        Request request = this.buildOkHttpRequest(req);
        Response response = this.client.newCall(request).execute();
        if (response.code() >= 300) {
            return this.buildError(req, response);
        }
        String contentType = response.header("content-type");
        if (contentType != null && contentType.contains("application/json")) {
            try {
                return ResponseParser.parseOne(response.body().byteStream(), resultClass);
            }
            catch (ParseException e) {
                return this.buildError(req, null);
            }
        }
        return null;
    }

    @Override
    public void send(final JsonRpcRequest req, final Class resultClass, final JsonRpcCallback callback) {
        Request request = this.buildOkHttpRequest(req);
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onFailure(e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.code() >= 300) {
                    callback.onResponse(HttpJsonRpcClient.this.buildError(req, response));
                    return;
                }
                String contentType = response.header("content-type");
                if (contentType != null && contentType.contains("application/json")) {
                    try {
                        callback.onResponse(ResponseParser.parseOne(response.body().byteStream(), resultClass));
                    }
                    catch (ParseException e) {
                        callback.onResponse(HttpJsonRpcClient.this.buildError(req, null));
                    }
                } else {
                    callback.onResponse(null);
                }
            }
        });
    }

    @Override
    public <T> List<JsonRpcResponse<T>> send(List<JsonRpcRequest> reqs, Class<T> resultClass) throws IOException {
        Request request = new Request.Builder().url(this.endpoint).post(RequestBody.create((MediaType)JSON, (String)RequestMapper.map(reqs).toString())).build();
        Response response = this.client.newCall(request).execute();
        if (response.code() >= 300) {
            ArrayList<JsonRpcResponse<T>> responses = new ArrayList<JsonRpcResponse<T>>(reqs.size());
            for (JsonRpcRequest req : reqs) {
                responses.add(this.buildError(req, response));
            }
            return responses;
        }
        String contentType = response.header("content-type");
        if (contentType != null && contentType.contains("application/json")) {
            return ResponseParser.parseList(response.body().byteStream(), resultClass);
        }
        return null;
    }

    @Override
    public void send(final List<JsonRpcRequest> reqs, final Class resultClass, final JsonRpcMultiCallback callback) {
        Request request = this.buildOkHttpRequest(reqs);
        this.client.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onFailure(e);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.code() >= 300) {
                    ArrayList responses = new ArrayList(reqs.size());
                    for (JsonRpcRequest req : reqs) {
                        responses.add(HttpJsonRpcClient.this.buildError(req, response));
                    }
                    callback.onResponse(responses);
                    return;
                }
                String contentType = response.header("content-type");
                if (contentType != null && contentType.contains("application/json")) {
                    callback.onResponse(ResponseParser.parseList(response.body().byteStream(), resultClass));
                    return;
                }
                callback.onResponse(null);
            }
        });
    }

    private Request buildOkHttpRequest(JsonRpcRequest req) {
        return new Request.Builder().url(this.endpoint).post(RequestBody.create((MediaType)JSON, (String)RequestMapper.map(req).toString())).build();
    }

    private Request buildOkHttpRequest(List<JsonRpcRequest> reqs) {
        return new Request.Builder().url(this.endpoint).post(RequestBody.create((MediaType)JSON, (String)RequestMapper.map(reqs).toString())).build();
    }

    private JsonRpcResponse buildError(JsonRpcRequest req, Response response) {
        JsonRpcResponse.Builder b = JsonRpcResponse.builder().id(req.getId());
        if (response == null) {
            b.error(new Error(-32700, "Parse error", null));
        } else if (response.code() == 400) {
            b.error(new Error(-32602, "Invalid params", null));
        } else if (response.code() == 404) {
            b.error(new Error(-32601, "Method not found", null));
        } else {
            b.error(new Error(-32000, Integer.toString(response.code()) + " - " + response.message(), null));
        }
        return b.build();
    }
}

