/*
 * Decompiled with CFR 0.152.
 */
package com.loicortola.jarpic.validator;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;

public abstract class JsonRpc2SchemaValidator {
    public static void assertValid(JsonNode tree) {
        if (tree == null) {
            throw new NullPointerException("The provided JSON cannot be null");
        }
        if (!tree.isObject()) {
            throw new IllegalArgumentException("The provided JSON is not an Object");
        }
        if (!tree.has("jsonrpc") || !"2.0".equals(tree.get("jsonrpc").asText())) {
            throw new IllegalArgumentException("Only JSON RPC 2.0 schema is supported. Please supply a valid format.");
        }
        if (tree.has("method")) {
            JsonRpc2SchemaValidator.checkValidRequest((ObjectNode)tree);
        } else {
            JsonRpc2SchemaValidator.checkValidResponse((ObjectNode)tree);
        }
    }

    private static void checkValidRequest(ObjectNode tree) {
        JsonNode id;
        JsonNode params;
        if (tree.has("params") && !(params = tree.get("params")).isArray() && !params.isObject()) {
            throw new IllegalArgumentException("JSON member 'params' must be an object or an array.");
        }
        if (tree.has("id") && !(id = tree.get("id")).isTextual() && !id.isNumber() && !id.isNull()) {
            throw new IllegalArgumentException("When provided, JSON member 'id' must be a String, a number, or NULL.");
        }
    }

    private static void checkValidResponse(ObjectNode tree) {
        if (!tree.has("id")) {
            throw new IllegalArgumentException("JSON member 'id' must be provided.");
        }
        JsonNode id = tree.get("id");
        if (!(id.isTextual() || id.isNumber() || id.isNull())) {
            throw new IllegalArgumentException("When provided, JSON member 'id' must be a String, a number, or NULL.");
        }
        if (tree.has("error")) {
            if (tree.has("result")) {
                throw new IllegalArgumentException("JSON member 'result' cannot be provided when 'error' is present.");
            }
            JsonNode error = tree.get("error");
            if (!(error.isObject() && error.has("code") && error.get("code").isInt() && error.has("message") && error.get("message").isTextual())) {
                throw new IllegalArgumentException("JSON member 'error' is not valid.");
            }
        } else if (!tree.has("result")) {
            throw new IllegalArgumentException("JSON member 'result' is mandatory.");
        }
    }
}

