/*
 * Decompiled with CFR 0.152.
 */
package com.loicortola.jarpic.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.loicortola.jarpic.model.Error;
import com.loicortola.jarpic.model.JsonRpcResponse;
import com.loicortola.jarpic.validator.JsonRpc2SchemaValidator;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public abstract class ResponseParser {
    public static void assertValid(JsonNode res) {
        if (res.isArray()) {
            ArrayNode values = (ArrayNode)res;
            for (int i = 0; i < values.size(); ++i) {
                JsonRpc2SchemaValidator.assertValid(values.get(i));
            }
        } else if (res.isObject()) {
            JsonRpc2SchemaValidator.assertValid(res);
        }
    }

    public static <T> JsonRpcResponse<T> parseOne(JsonNode content, Class<T> resultClass) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ResponseParser.assertValid(content);
        return ResponseParser.parse(mapper, (ObjectNode)content, resultClass);
    }

    public static <T> JsonRpcResponse<T> parseOne(InputStream content, Class<T> resultClass) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(content);
        if (!node.isObject()) {
            return null;
        }
        return ResponseParser.parseOne(node, resultClass);
    }

    public static <T> List<JsonRpcResponse<T>> parseList(JsonNode content, Class<T> resultClass) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<JsonRpcResponse<T>> responses = new ArrayList<JsonRpcResponse<T>>(content.size());
        for (int i = 0; i < content.size(); ++i) {
            ObjectNode node = (ObjectNode)content.get(i);
            responses.add(ResponseParser.parse(mapper, node, resultClass));
        }
        return responses;
    }

    public static <T> List<JsonRpcResponse<T>> parseList(InputStream content, Class<T> resultClass) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode nodes = mapper.readTree(content);
        if (!nodes.isArray()) {
            return null;
        }
        return ResponseParser.parseList(nodes, resultClass);
    }

    private static <T> JsonRpcResponse<T> parse(ObjectMapper mapper, ObjectNode node, Class<T> resultClass) throws IOException {
        JsonRpcResponse.Builder<Object> builder = JsonRpcResponse.builder();
        builder.id(node.get("id").asText());
        if (node.has("error")) {
            Error err = (Error)mapper.readValue(node.get("error").traverse(), Error.class);
            builder.error(err);
        } else {
            Object result = mapper.readValue(node.get("result").traverse(), resultClass);
            builder.result(result);
        }
        return builder.build();
    }
}

