/*
 * Decompiled with CFR 0.152.
 */
package com.loicortola.jarpic.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class JsonRpcRequest {
    protected String method;
    protected Map<String, String> params;
    protected String id;
    protected Type type;

    public String getMethod() {
        return this.method;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public String getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public static List<JsonRpcRequest> combine(JsonRpcRequest ... requests) {
        if (requests == null || requests.length == 0) {
            return null;
        }
        ArrayList<JsonRpcRequest> combined = new ArrayList<JsonRpcRequest>(requests.length);
        for (int i = 0; i < requests.length; ++i) {
            combined.add(requests[i]);
        }
        return combined;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonRpcRequest request = (JsonRpcRequest)o;
        if (this.method != null ? !this.method.equals(request.method) : request.method != null) {
            return false;
        }
        return !(this.id == null ? request.id != null : !this.id.equals(request.id));
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Request{method='" + this.method + '\'' + ", params=" + this.params + ", id='" + this.id + '\'' + ", type=" + (Object)((Object)this.type) + '}';
    }

    public static Builder builder() {
        return new Builder(Type.REQUEST);
    }

    public static Builder notifBuilder() {
        return new Builder(Type.NOTIFICATION);
    }

    public static class Builder {
        protected String method;
        protected Map<String, String> params;
        protected String id;
        protected Type type;

        private Builder(Type t) {
            this.type = t;
        }

        public Builder method(String method) {
            this.method = method;
            return this;
        }

        public Builder param(String key, String value) {
            if (this.params == null) {
                this.params = new HashMap<String, String>();
            }
            this.params.put(key, value);
            return this;
        }

        public JsonRpcRequest build() {
            JsonRpcRequest request = new JsonRpcRequest();
            request.method = this.method;
            request.params = this.params;
            request.id = Type.REQUEST.equals((Object)this.type) ? UUID.randomUUID().toString() : null;
            request.type = this.type;
            return request;
        }
    }

    public static enum Type {
        NOTIFICATION,
        REQUEST;

    }
}

