/*
 * Decompiled with CFR 0.152.
 */
package com.loicortola.jarpic.client;

import com.loicortola.jarpic.client.JsonRpcClient;
import com.loicortola.jarpic.model.Error;
import com.loicortola.jarpic.model.JsonRpcRequest;
import com.loicortola.jarpic.model.JsonRpcResponse;
import com.loicortola.jarpic.parser.RequestMapper;
import com.loicortola.jarpic.parser.ResponseParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class HttpJsonRpcClient
implements JsonRpcClient {
    private OkHttpClient client;
    private String endpoint;
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=UTF-8");

    public HttpJsonRpcClient(String endpoint) {
        this.endpoint = endpoint;
        this.client = new OkHttpClient();
    }

    public HttpJsonRpcClient(String endpoint, OkHttpClient client) {
        this.endpoint = endpoint;
        this.client = client;
    }

    @Override
    public <T> JsonRpcResponse<T> send(JsonRpcRequest req, Class<T> resultClass) throws IOException {
        Request request = new Request.Builder().url(this.endpoint).post(RequestBody.create((MediaType)JSON, (String)RequestMapper.map(req).toString())).build();
        Response response = this.client.newCall(request).execute();
        if (response.header("content-type", "").contains("application/json")) {
            return ResponseParser.parseOne(response.body().byteStream(), resultClass);
        }
        if (response.code() == 200) {
            return null;
        }
        return JsonRpcResponse.builder().id(req.getId()).error(new Error(-32000, Integer.toString(response.code()) + " - " + response.message(), null)).build();
    }

    @Override
    public <T> List<JsonRpcResponse<T>> send(List<JsonRpcRequest> reqs, Class<T> resultClass) throws IOException {
        Request request = new Request.Builder().url(this.endpoint).post(RequestBody.create((MediaType)JSON, (String)RequestMapper.map(reqs).toString())).build();
        Response response = this.client.newCall(request).execute();
        if (response.header("content-type", "").contains("application/json")) {
            return ResponseParser.parseList(response.body().byteStream(), resultClass);
        }
        if (response.code() == 200) {
            return null;
        }
        ArrayList<JsonRpcResponse<T>> responses = new ArrayList<JsonRpcResponse<T>>(reqs.size());
        for (JsonRpcRequest req : reqs) {
            responses.add(JsonRpcResponse.builder().id(req.getId()).error(new Error(-32000, Integer.toString(response.code()) + " - " + response.message(), null)).build());
        }
        return responses;
    }
}

