/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.processor.BaseProcessableElement;
import io.requery.processor.ElementValidator;
import io.requery.processor.SuperDescriptor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

class SuperType
extends BaseProcessableElement<TypeElement>
implements SuperDescriptor {
    private final Map<TypeElement, Set<Element>> annotatedElements = new LinkedHashMap<TypeElement, Set<Element>>();

    SuperType(TypeElement element) {
        super(element);
    }

    void addAnnotationElement(TypeElement annotation, Element element) {
        Set elements = this.annotatedElements.computeIfAbsent(annotation, key -> new LinkedHashSet());
        elements.add(element);
    }

    @Override
    public Set<ElementValidator> process(ProcessingEnvironment processingEnvironment) {
        ElementValidator validator = new ElementValidator((Element)this.element(), processingEnvironment);
        if (((TypeElement)this.element()).getKind().isClass() && ((TypeElement)this.element()).getModifiers().contains((Object)Modifier.FINAL)) {
            validator.warning("Superclass annotation cannot be applied to final class");
        }
        if (((TypeElement)this.element()).getKind() == ElementKind.ENUM) {
            validator.error("Superclass annotation cannot be applied to an enum class");
        }
        return Collections.singleton(validator);
    }

    @Override
    public Map<TypeElement, Set<Element>> annotatedElements() {
        return this.annotatedElements;
    }
}

