/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.processor.Names;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Name;

class QualifiedName
implements Name {
    private final String packageName;
    private final String className;

    QualifiedName(String packageName, String className) {
        if (Names.isEmpty(className)) {
            throw new IllegalArgumentException();
        }
        if (!SourceVersion.isIdentifier(className)) {
            throw new IllegalArgumentException("invalid class name identifier");
        }
        this.packageName = packageName;
        this.className = className;
    }

    QualifiedName(String qualifiedName) {
        String[] parts = qualifiedName.split("\\.");
        String className = "";
        StringBuilder packageBuilder = new StringBuilder();
        if (parts.length != 0) {
            for (String part : parts) {
                if (Character.isLowerCase(part.charAt(0))) {
                    packageBuilder.append(part);
                    packageBuilder.append(".");
                    continue;
                }
                className = part;
            }
        } else {
            className = qualifiedName;
        }
        if (packageBuilder.length() > 0 && packageBuilder.charAt(packageBuilder.length() - 1) == '.') {
            packageBuilder.deleteCharAt(packageBuilder.length() - 1);
        }
        this.packageName = packageBuilder.toString();
        if (Names.isEmpty(className)) {
            throw new IllegalArgumentException("empty class name");
        }
        if (!SourceVersion.isIdentifier(className)) {
            throw new IllegalArgumentException("invalid class name identifier");
        }
        this.className = className;
    }

    public String packageName() {
        return this.packageName;
    }

    public String className() {
        return this.className;
    }

    @Override
    public boolean contentEquals(CharSequence cs) {
        return this.toString().equals(cs.toString());
    }

    @Override
    public int length() {
        return this.toString().length();
    }

    @Override
    public char charAt(int index) {
        return this.toString().charAt(index);
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.toString().subSequence(start, end);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Name) {
            Name other = (Name)obj;
            return other.contentEquals(this.toString());
        }
        return false;
    }

    @Override
    public String toString() {
        return Names.isEmpty(this.packageName) ? this.className : this.packageName + "." + this.className;
    }
}

