/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.processor.BaseProcessableElement;
import io.requery.processor.ElementValidator;
import io.requery.processor.ListenerAnnotations;
import io.requery.processor.ListenerDescriptor;
import io.requery.processor.Mirrors;
import io.requery.processor.Names;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

class ListenerMethod
extends BaseProcessableElement<ExecutableElement>
implements ListenerDescriptor {
    private List<Annotation> annotations;

    ListenerMethod(ExecutableElement element) {
        super(element);
    }

    @Override
    public Set<ElementValidator> process(ProcessingEnvironment processingEnvironment) {
        ElementValidator validator = new ElementValidator((Element)this.element(), processingEnvironment);
        this.annotations = ListenerAnnotations.all().map(this::annotationOf).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (!this.annotations.isEmpty()) {
            ExecutableElement element = (ExecutableElement)this.element();
            if (!element.getParameters().isEmpty()) {
                validator.error("Callback method cannot have arguments");
            }
            if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
                validator.error("Callback method cannot be private");
            }
            if (element.getModifiers().contains((Object)Modifier.ABSTRACT)) {
                validator.error("Callback method cannot be abstract");
            }
            if (!element.getThrownTypes().isEmpty()) {
                Types types = processingEnvironment.getTypeUtils();
                for (TypeMirror typeMirror : element.getThrownTypes()) {
                    TypeElement typeElement;
                    Element exceptionElement = types.asElement(typeMirror);
                    if (exceptionElement.getKind() != ElementKind.CLASS || Mirrors.isInstance(types, typeElement = (TypeElement)exceptionElement, RuntimeException.class)) continue;
                    validator.error("Callback method cannot throw checked exception(s)");
                }
            }
            this.annotations.stream().filter(annotation -> ((ExecutableElement)this.element()).getSimpleName().toString().equals(Names.lowerCaseFirst(annotation.getClass().getSimpleName()))).forEach(annotation -> validator.error("Callback method cannot have the same name as the listener method"));
        }
        return Collections.singleton(validator);
    }

    @Override
    public Collection<Annotation> listenerAnnotations() {
        return this.annotations;
    }
}

