/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.Column;
import io.requery.ForeignKey;
import io.requery.JunctionTable;
import io.requery.ReferentialAction;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.AssociativeReference;
import io.requery.processor.AttributeMember;
import io.requery.processor.Mirrors;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

class JunctionTableAssociation
implements AssociativeEntityDescriptor {
    private final JunctionTable table;
    private final Set<AssociativeReference> columns;

    JunctionTableAssociation(Elements elements, AttributeMember member, JunctionTable table) {
        this.table = table;
        this.columns = new LinkedHashSet<AssociativeReference>();
        for (Column column : table.columns()) {
            ForeignKey key = column.foreignKey()[0];
            String columnName = column.name();
            ReferentialAction action = ReferentialAction.CASCADE;
            TypeElement referenceType = null;
            if (key != null) {
                action = key.action();
                Optional value = Mirrors.findAnnotationMirror(member.element(), JunctionTable.class).flatMap(m -> Mirrors.findAnnotationValue(m, "columns"));
                if (value.isPresent()) {
                    List mirrors = (List)((AnnotationValue)value.get()).getValue();
                    for (Object m2 : mirrors) {
                        List children;
                        Optional<AnnotationValue> annotationValue;
                        Optional<AnnotationValue> keyValue = Mirrors.findAnnotationValue((AnnotationMirror)m2, "foreignKey");
                        if (!keyValue.isPresent() || !(annotationValue = Mirrors.findAnnotationValue((AnnotationMirror)(children = (List)keyValue.get().getValue()).get(0), "references")).isPresent()) continue;
                        referenceType = elements.getTypeElement(annotationValue.get().getValue().toString());
                    }
                }
            }
            this.columns.add(new AssociativeReference(columnName, action, referenceType));
        }
    }

    @Override
    public String name() {
        return this.table.name();
    }

    @Override
    public Set<AssociativeReference> columns() {
        return this.columns;
    }
}

