/*
 * Decompiled with CFR 0.152.
 */
package io.requery.processor;

import io.requery.ReferentialAction;
import io.requery.processor.AssociativeEntityDescriptor;
import io.requery.processor.AssociativeReference;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.persistence.ConstraintMode;
import javax.persistence.ForeignKey;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;

class JoinTableAssociation
implements AssociativeEntityDescriptor {
    private final JoinTable table;
    private final Set<AssociativeReference> columns;

    JoinTableAssociation(JoinTable table) {
        ForeignKey foreignKey;
        ReferentialAction action;
        String columnName;
        this.table = table;
        this.columns = new LinkedHashSet<AssociativeReference>();
        for (JoinColumn column : table.joinColumns()) {
            columnName = column.name();
            action = ReferentialAction.CASCADE;
            foreignKey = column.foreignKey();
            if (foreignKey != null) {
                action = this.mapConstraint(foreignKey.value());
            }
            this.columns.add(new AssociativeReference(columnName, action, null));
        }
        for (JoinColumn column : table.inverseJoinColumns()) {
            columnName = column.name();
            action = ReferentialAction.CASCADE;
            foreignKey = column.foreignKey();
            if (foreignKey != null) {
                action = this.mapConstraint(foreignKey.value());
            }
            this.columns.add(new AssociativeReference(columnName, action, null));
        }
    }

    private ReferentialAction mapConstraint(ConstraintMode constraint) {
        switch (constraint) {
            case NO_CONSTRAINT: {
                return ReferentialAction.NO_ACTION;
            }
        }
        return ReferentialAction.CASCADE;
    }

    @Override
    public String name() {
        return this.table.name();
    }

    @Override
    public Set<AssociativeReference> columns() {
        return this.columns;
    }
}

